package com.ejianc.business.tender.rmat.controller;

import com.ejianc.business.tender.rmat.vo.RmatDocumentExpertVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentExpertEntity;
import com.ejianc.business.tender.rmat.service.IRmatDocumentExpertService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 招标文件专家表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatDocumentExpert")
@Api(value = "招标文件专家表", tags = {"招标文件专家表"})
public class RmatDocumentExpertController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRmatDocumentExpertService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatDocumentExpertVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RmatDocumentExpertVO saveOrUpdateVO) {
    	RmatDocumentExpertEntity entity = BeanMapper.map(saveOrUpdateVO, RmatDocumentExpertEntity.class);
    	service.saveOrUpdate(entity, false);
    	RmatDocumentExpertVO vo = BeanMapper.map(entity, RmatDocumentExpertVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatDocumentExpertVO> queryDetail(@RequestParam Long id) {
    	RmatDocumentExpertEntity entity = service.selectById(id);
    	RmatDocumentExpertVO vo = BeanMapper.map(entity, RmatDocumentExpertVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量新增")
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<RmatDocumentExpertEntity>> addBatch(@RequestBody RmatDocumentVO rmatDocumentVO) {
        List<RmatDocumentExpertEntity> list = service.addBatch(rmatDocumentVO);
        return CommonResponse.success("新增成功！",list);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deleteByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<RmatDocumentExpertEntity>> deleteByIds(@RequestBody List<Long> vos) {
        List<RmatDocumentExpertEntity> list = service.deleteByIds(vos);

        return CommonResponse.success("删除成功！",list);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




}
