package com.ejianc.business.tender.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.rmat.vo.RmatDocumentExpertVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentExpertEntity;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentExpertMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentExpertService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("rmatDocumentExpertService")
public class RmatDocumentExpertServiceImpl extends BaseServiceImpl<RmatDocumentExpertMapper, RmatDocumentExpertEntity> implements IRmatDocumentExpertService {

    @Override
    public List<RmatDocumentExpertEntity> addBatch(RmatDocumentVO rmatDocumentVO) {

        //先删后增
        LambdaQueryWrapper<RmatDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(RmatDocumentExpertEntity::getDocumentId,rmatDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<RmatDocumentExpertVO> expertVOList = rmatDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (RmatDocumentExpertVO rmatDocument: expertVOList){
                rmatDocument.setDocumentId(rmatDocumentVO.getId());
                rmatDocument.setId(null);
            }
            List<RmatDocumentExpertEntity> rmatDocumentExpertEntities = BeanMapper.mapList(expertVOList, RmatDocumentExpertEntity.class);
            super.saveBatch(rmatDocumentExpertEntities);
            return rmatDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<RmatDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        RmatDocumentExpertEntity rmatDocumentExpertEntity = super.selectById(pk);
        Long documentId = rmatDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<RmatDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(RmatDocumentExpertEntity::getDocumentId,documentId);
        List<RmatDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
