package com.ejianc.business.tender.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.api.IPurchaseBatchPlanApi;
import com.ejianc.business.pro.rmat.api.IBatchPlanApi;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.mapper.RmatInviteMapper;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubInviteVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料立项主表
 *
 * @author generator
 */
@Service("rmatInviteService")
public class RmatInviteServiceImpl extends BaseServiceImpl<RmatInviteMapper, RmatInviteEntity> implements IRmatInviteService {
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IBatchPlanApi batPlanApi;
    @Autowired
    private IPurchaseBatchPlanApi purchaseBatchPlanApi;

    @Override
    public void updateTenderStage(String id, int tenderStage) {
        baseMapper.updateTenderStage(id, tenderStage);
    }

    @Override
    public void updateAbolishType(String id, int abolishType) {
        baseMapper.updateAbolishType(id, abolishType);
    }

    @Override
    public List<RmatInviteDetailVO> selectSumDetail(Long inviteId) {
        return baseMapper.selectSumDetail(inviteId);
    }

    @Override
    public List<RmatInviteDetailVO> selectOrgSumDetail(Long inviteId) {
        return baseMapper.selectOrgSumDetail(inviteId);
    }

    @Override
    public Map<String, Object> getAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        LambdaQueryWrapper<ProcessEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProcessEntity::getTenderId, tenderId);
        lambda.eq(ProcessEntity::getBillId, tenderId);
        List<ProcessEntity> list = processService.list(lambda);
        switch (list.get(0).getType()) {
            case 0:
                map = rmatInviteService.getSuffAbolishType(tenderId);
                break;
            case 1:
                map = rmatInviteService.getSubAbolishType(tenderId);
                break;
        }
        return map;
    }

    @Override
    public Map<String, Object> getSuffAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(tenderId);
        RmatInviteVO vo = BeanMapper.map(rmatInviteEntity, RmatInviteVO.class);
        if (vo.getAbolishType() == null) {
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId", vo.getEmployeeId());
        return map;
    }

    @Override
    public Map<String, Object> getSubAbolishType(Long tenderId) {
        Map<String, Object> map = new HashMap<>();
        SubInviteEntity subInviteEntity = subInviteService.selectById(tenderId);
        SubInviteVO vo = BeanMapper.map(subInviteEntity, SubInviteVO.class);
        if (vo.getAbolishType() == null) {
            vo.setAbolishType(0);
        }
        map.put("abolishType", vo.getAbolishType());
        map.put("employeeId", vo.getEmployeeId());
        return map;
    }

    @Override
    public List<RmatInviteDetailBidderVO> selectDetailBidder(Long inviteId) {
        return baseMapper.selectDetailBidder(inviteId);
    }

    @Override
    public void updateApiState(RmatInviteEntity entity, Integer BatchPlanState,Integer MaterialBatchPlanState) {
        List<String> batPlanList = entity.getRmatDetailRecord().stream().map(RmatInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList());
       // if (entity.getPurchaseType()==0){
            if (CollectionUtils.isNotEmpty(batPlanList)) {
                CommonResponse<String> response = batPlanApi.updateBatPlanQuote(batPlanList, BatchPlanState);
                if (!response.isSuccess()) {
                    throw new BusinessException("修改计划状态失败" + response.getMsg());
                }
            }
//        }else {
//            if (CollectionUtils.isNotEmpty(batPlanList)) {
//                CommonResponse<String> response = purchaseBatchPlanApi.updateBatPlanQuote(batPlanList, MaterialBatchPlanState);
//                if (!response.isSuccess()) {
//                    throw new BusinessException("修改租赁申请状态失败" + response.getMsg());
//                }
//            }
//        }
    }
}
