/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.controller;

import com.ejianc.business.tender.prosub.bean.ProsubAdviceEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.service.IProsubAdviceService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.vo.ProsubAdviceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prosubAdvice"})
public class ProsubAdviceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sub-advice-code";
    @Autowired
    private IProsubAdviceService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProsubPicketageService subPicketageService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProsubAdviceVO> saveOrUpdate(@RequestBody ProsubAdviceVO saveOrUpdateVO) {
        ProsubAdviceEntity entity = (ProsubAdviceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProsubAdviceEntity.class));
        if (entity.getBillCode() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setScFlag(0);
        this.service.saveOrUpdate((Object)entity, false);
        ProsubAdviceVO vo = (ProsubAdviceVO)BeanMapper.map((Object)((Object)entity), ProsubAdviceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProsubAdviceVO> queryDetail(Long id) {
        ProsubAdviceEntity entity = (ProsubAdviceEntity)((Object)this.service.selectById(id));
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(entity.getPicketageId()));
        ProsubAdviceVO vo = (ProsubAdviceVO)BeanMapper.map((Object)((Object)entity), ProsubAdviceVO.class);
        vo.setTrusteesId(subPicketageEntity.getTrusteesId());
        vo.setTrusteesName(subPicketageEntity.getTrusteesName());
        vo.setTrusteesPhone(subPicketageEntity.getTrusteesPhone());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryAdviceList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ProsubAdviceVO>> queryAdviceList(@RequestParam Long id) {
        List<ProsubAdviceVO> list = this.service.queryAdviceList(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/sendAdvice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> sendAdvice(Long id) {
        String s = this.service.sendAdvice(id);
        return CommonResponse.success((String)"\u53d1\u9001\u6210\u529f\uff01", (Object)s);
    }
}

