package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentPicketageSupplierMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentWinnoticeService;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 定标供应商表
 * 
 * @author generator
 * 
 */
@Service("equipmentPicketageSupplierService")
public class EquipmentPicketageSupplierServiceImpl extends BaseServiceImpl<EquipmentPicketageSupplierMapper, EquipmentPicketageSupplierEntity> implements IEquipmentPicketageSupplierService {
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentWinnoticeService equipmentWinnoticeService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<EquipmentPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<EquipmentPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(EquipmentPicketageSupplierEntity::getPicketageId,id);
        List<EquipmentPicketageSupplierEntity> listSupplier = equipmentPicketageSupplierService.list(lambdaSupplierList);
        List<EquipmentPicketageSupplierVO> equipmentPicketageSupplierVOS = BeanMapper.mapList(listSupplier, EquipmentPicketageSupplierVO.class);

        return equipmentPicketageSupplierVOS;
    }
}
