package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherWinnoticeMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.other.vo.*;
import com.ejianc.business.tender.stuff.bean.StuffPicketageSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffWinnoticeEntity;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中标公告表
 * 
 * @author generator
 * 
 */
@Service("otherWinnoticeService")
public class OtherWinnoticeServiceImpl extends BaseServiceImpl<OtherWinnoticeMapper, OtherWinnoticeEntity> implements IOtherWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherBidDetailService otherBidDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherBidSupplierService otherBidSupplierService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value("${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IOtherPicketageSupplierService OtherPicketageSupplierService;
    private static final String BILL_TYPE = "BT220210000000021";//此处需要根据实际修改
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Transactional
    @Override
    public OtherWinnoticeVO saveWinnotice(Long picketageId) {
        OtherWinnoticeEntity entity = new OtherWinnoticeEntity();
        entity.setPicketageId(picketageId);
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(picketageId);
        OtherInviteEntity inviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());
        entity.setInviteId(otherPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName()+"中标公告");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());

        //采购方式(0-项目采购,1-单位采购)
        if (inviteEntity.getPurchaseType().equals(0)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)){
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }

        OtherDocumentEntity otherDocumentEntity = otherDocumentService.selectById(otherPicketageEntity.getDocumentId());
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);//签章状态，未签章
        entity.setLineTypeName(CommonUtils.getTypeName(5));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate(entity, false);

        //回写定标数据
        otherPicketageEntity.setWinnoticeStatus(1);
        otherPicketageEntity.setWinnoticeId(entity.getId());
        otherPicketageService.updateById(otherPicketageEntity);

        //回写招标阶段
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        otherInviteService.updateById(inviteEntity);
        //回写定标子表数据
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : picketageSupplierList){
            otherPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        OtherPicketageSupplierService.updateBatchById(picketageSupplierList);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("other/winnotice");
        processService.saveOrUpdate(processEntity);
        OtherWinnoticeVO otherWinnoticeVO = BeanMapper.map(entity, OtherWinnoticeVO.class);
        return otherWinnoticeVO;
    }

    @Override
    public OtherWinnoticeVO queryDetail(Long id) {
        OtherWinnoticeEntity otherWinnoticeEntity = super.selectById(id);
        OtherWinnoticeVO otherWinnoticeVO = BeanMapper.map(otherWinnoticeEntity, OtherWinnoticeVO.class);
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(otherWinnoticeEntity.getPicketageId());
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        List<OtherPicketageSupplierVO> otherPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, OtherPicketageSupplierVO.class);
        otherWinnoticeVO.setPicketageSupplierList(otherPicketageSupplierList);



        //处理签章附件信息
        if (otherWinnoticeVO!=null) {
            Long id1 = otherWinnoticeVO.getId();
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(id1, BILL_TYPE, "tenderWinnotice", "");
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));

                    AttachmentVO attachmentVO = attacMap.get(otherWinnoticeVO.getId());
                    if (attachmentVO != null) {
                        otherWinnoticeVO.setAttachId(attachmentVO.getId());
                        otherWinnoticeVO.setFileName(attachmentVO.getFileName());
                        otherWinnoticeVO.setFilePath(attachmentVO.getFilePath());
                    }

                }
            }
        }
        return otherWinnoticeVO;
    }

    @Override
    public OtherWinnoticeVO publishWinnotice(Long id) {
        
        //更新发布状态
        OtherWinnoticeEntity otherWinnoticeEntity = super.selectById(id);
        otherWinnoticeEntity.setPublishFlag(0);
        super.updateById(otherWinnoticeEntity);

        //回写定标数据
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(otherWinnoticeEntity.getPicketageId());
        otherPicketageEntity.setWinnoticeStatus(2);
        otherPicketageService.updateById(otherPicketageEntity);

        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());

        //调用供方接口
        //调用第三方报名接口
        //推送供应商
        OtherWinVO winVO = new OtherWinVO();
        winVO.setSourceType("郑州一建中标公告");
        winVO.setSourceId(Long.toString(otherWinnoticeEntity.getInviteId()));
        winVO.setBillCode(otherInviteEntity.getBillCode());
        //采购方式(0-项目采购,1-单位采购)
        if (otherInviteEntity.getPurchaseType() == 0){
            winVO.setSourceProjectId(Long.toString(otherInviteEntity.getProjectId()));
            winVO.setProjectName(otherInviteEntity.getProjectName());
            winVO.setProjectCode(otherInviteEntity.getProjectCode());
        }

        if (otherInviteEntity.getPurchaseType() == 1){
            winVO.setOrgName(otherInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(otherInviteEntity.getOrgId()));

        }
        winVO.setSourceUnitId(Long.toString(otherInviteEntity.getUnitId()));
        winVO.setUnitName(otherInviteEntity.getUnitName());
        winVO.setType("OTHER");
        winVO.setTenderName(otherInviteEntity.getTenderName());
        winVO.setTenderType(otherInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(otherWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(otherWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(otherWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(otherInviteEntity.getPurchaseType());
        winVO.setWinDate(otherWinnoticeEntity.getWinDate());
        winVO.setStopDate(otherWinnoticeEntity.getStopDate());
        winVO.setWinTitle(otherWinnoticeEntity.getTitleName());
        winVO.setMemo(otherWinnoticeEntity.getMemo());
        winVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());

        //明细设置
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        ArrayList<OtherWinDetailVO> winDetailVOS = new ArrayList<>();
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : picketageSupplierList){
            OtherWinDetailVO winDetailVO = new OtherWinDetailVO();
            winDetailVO.setWinId(otherWinnoticeEntity.getId());
            winDetailVO.setSupplierName(otherPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(otherPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = shareSupplierApi.queryById(otherPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(otherPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString(winVO);
        logger.info("中标公告发布" + stringFb);
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(winSaveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("中标公告同步供方接口报错" + stringCommonResponse.getMsg());
        }
        return queryDetail(id);
    }

    @Override
    public OtherWinnoticeVO saveOrUpdates(OtherWinnoticeEntity entity) {
        super.saveOrUpdate(entity,false);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        //status   发起:3,  甲方-4  已签章
        //签章状态 未签章 -0,待签章-1,已签章-2
        OtherWinnoticeEntity otherWinnoticeEntity = super.selectById(billId);
        if(status == 5 || status == 6 || status == 7 || status == 8){
            otherWinnoticeEntity.setSignFlag(0);
        }
        if(status == 2 || status == 3){
            otherWinnoticeEntity.setSignFlag(1);
        }
        if(status == 4){
            otherWinnoticeEntity.setSignFlag(2);
            // 先同步签章附件
            ContractVO cv = new ContractVO();
            cv.setContractId(otherWinnoticeEntity.getId());
            cv.setContractName(otherWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<>();
            cvs.add(cv);

            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
            if(!signResp.isSuccess()){
                throw new BusinessException("同步签章附件失败!");
            }
        }
        super.updateById(otherWinnoticeEntity);

        return CommonResponse.success("更新成功!");
    }
}
