package com.ejianc.business.tender.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentExpertEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentExpertMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentExpertService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentExpertVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.sub.bean.SubDocumentExpertEntity;
import com.ejianc.business.tender.sub.mapper.SubDocumentExpertMapper;
import com.ejianc.business.tender.sub.vo.SubDocumentExpertVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("prosubDocumentExpertService")
public class ProsubDocumentExpertServiceImpl extends BaseServiceImpl<ProsubDocumentExpertMapper, ProsubDocumentExpertEntity> implements IProsubDocumentExpertService {

    @Override
    public List<ProsubDocumentExpertEntity> addBatch(ProsubDocumentVO subDocumentVO) {

        //先删后增
        LambdaQueryWrapper<ProsubDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(ProsubDocumentExpertEntity::getDocumentId,subDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<ProsubDocumentExpertVO> expertVOList = subDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (ProsubDocumentExpertVO subDocument: expertVOList){
                subDocument.setDocumentId(subDocumentVO.getId());
                subDocument.setId(null);
            }
            List<ProsubDocumentExpertEntity> subDocumentExpertEntities = BeanMapper.mapList(expertVOList, ProsubDocumentExpertEntity.class);
            super.saveBatch(subDocumentExpertEntities);
            return subDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<ProsubDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        ProsubDocumentExpertEntity subDocumentExpertEntity = super.selectById(pk);
        Long documentId = subDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<ProsubDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(ProsubDocumentExpertEntity::getDocumentId,documentId);
        List<ProsubDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
