package com.ejianc.business.tender.rent.controller;

import java.io.Serializable;

import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.bean.RentAdviceEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.vo.RentAdviceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.tender.rent.bean.RentAdviceEntity;
import com.ejianc.business.tender.rent.service.IRentAdviceService;
import com.ejianc.business.tender.rent.vo.RentAdviceVO;

/**
 * 设备租赁-中标通知书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentAdvice")
public class RentAdviceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "rent-advice-code";//此处需要根据实际修改

    @Autowired
    private IRentAdviceService service;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentAdviceVO> saveOrUpdate(@RequestBody RentAdviceVO saveOrUpdateVO) {
        RentAdviceEntity entity = BeanMapper.map(saveOrUpdateVO, RentAdviceEntity.class);
        if(entity.getBillCode() == null){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setScFlag(0);
        service.saveOrUpdate(entity, false);
        RentAdviceVO vo = BeanMapper.map(entity, RentAdviceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentAdviceVO> queryDetail(Long id) {
        RentAdviceEntity entity = service.selectById(id);
        RentPicketageEntity rentPicketageEntity = rentPicketageService.selectById(entity.getPicketageId());
        RentAdviceVO vo = BeanMapper.map(entity, RentAdviceVO.class);
        vo.setTrusteesId(rentPicketageEntity.getTrusteesId());
        vo.setTrusteesName(rentPicketageEntity.getTrusteesName());
        vo.setTrusteesPhone(rentPicketageEntity.getTrusteesPhone());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryAdviceList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentAdviceVO>> queryAdviceList(@RequestParam Long id) {
        List<RentAdviceVO> list = service.queryAdviceList(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    /**
     * @Description 发布接口
     * @param id
     */
    @RequestMapping(value = "/sendAdvice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> sendAdvice(Long id) {
        String s = service.sendAdvice(id);
        return CommonResponse.success("发送成功！",s);
    }
}
