package com.ejianc.business.tender.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_rmat_document_sell")
public class RmatDocumentSellEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="detail_id")
    private Long detailId; // 采购物料详情主键
    @TableField(value="scheme_id")
    private Long schemeId; // 方案子表主键
    @TableField(value="document_id")
    private Long documentId; // 招标文件主表主键
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商ID
    @TableField(value="supplier_tenant_id")
    private Long supplierTenantId; // 供应商租户id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="material_id")
    private Long materialId; // 材料ID
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="material_type_id")
    private Long materialTypeId; // 材料分类ID
    @TableField(value="material_type_name")
    private String materialTypeName; // 材料分类名称
    @TableField(value="unit")
    private String unit; // 单位
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="brand")
    private String brand; // 供货品牌
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_memo")
    private String materialMemo; // 定标立项备注
    @TableField(value="material_brand")
    private String materialBrand; // 定标立项品牌
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="price_tax")
    private BigDecimal priceTax; // 单价(含税)
    @TableField(value="money")
    private BigDecimal money; // 总额
    @TableField(value="money_tax")
    private BigDecimal moneyTax; // 总额(含税)
    @TableField(value="sell_tax")
    private BigDecimal sellTax; // 税额
    @TableField(value="tender_num")
    private BigDecimal tenderNum; // 中标数量
    @TableField(value="tender_money")
    private BigDecimal tenderMoney; // 中标金额
    @TableField(value="scheme_name")
    private String schemeName; // 方案名称
    @TableField(value="tender_flag")
    private Integer tenderFlag; // 是否中标,0-是1-否
    @TableField(value="calculate_type")
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    @TableField(value="tender_money_tax")
    private BigDecimal tenderMoneyTax;
    @TableField(value="talk_num")
    private Integer talkNum; // 洽商轮数
    @TableField(value="refer_flag")
    private Integer referFlag; // 是否推荐,1-是,2-否
    @TableField(value="pass_flag")
    private Integer passFlag; // 是否通过,1-是,2-否
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_enter_date")
    private Date planEnterDate; // 计划进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="plan_leave_date")
    private Date planLeaveDate; // 计划出场时间
    @TableField(value="plan_day")
    private BigDecimal planDay; // 计划周期
    @TableField(exist = false)
    private Long orgId; //
    @TableField(exist = false)
    private String orgName; //

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }
    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }

    public Integer getReferFlag() {
        return referFlag;
    }

    public void setReferFlag(Integer referFlag) {
        this.referFlag = referFlag;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    public BigDecimal getTenderMoneyTax() {
        return tenderMoneyTax;
    }

    public void setTenderMoneyTax(BigDecimal tenderMoneyTax) {
        this.tenderMoneyTax = tenderMoneyTax;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }

    public String getMaterialBrand() {
        return materialBrand;
    }

    public void setMaterialBrand(String materialBrand) {
        this.materialBrand = materialBrand;
    }

    /**
     * 采购物料详情主键
     */
    public Long getDetailId() {
        return detailId;
    }

    /**
     * 采购物料详情主键
     */
    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }
    /**
     * 方案子表主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案子表主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 招标文件主表主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主表主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商租户id
     */
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户id
     */
    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 供货品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 供货品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public BigDecimal getSellTax() {
        return sellTax;
    }

    /**
     * 税额
     */
    public void setSellTax(BigDecimal sellTax) {
        this.sellTax = sellTax;
    }
    /**
     * 中标数量
     */
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    /**
     * 中标数量
     */
    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }
    /**
     * 中标金额
     */
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 中标金额
     */
    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 方案名称
     */
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * 方案名称
     */
    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    /**
     * 是否中标,1-是2-否
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 是否中标,1-是2-否
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    
}
