package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.controller.StuffDocumentController;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffBidVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("stuffPicketage") 
public class StuffPicketageBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IStuffPicketageService stuffPicketageService;
	@Autowired
	private IStuffBidService stuffBidService;
	@Autowired
	private IStuffAdviceService stuffAdviceService;
	@Autowired
	private IStuffWinnoticeService stuffWinnoticeService;
	@Autowired
	private IStuffInviteService stuffInviteService;
	@Autowired
	private IStuffBidDetailService stuffBidDetailService;
	@Autowired
	private IStuffDocumentSellService stuffDocumentSellService;
	@Autowired
	private IStuffDocumentService stuffDocumentService;
	@Autowired
	private IStuffBidSupplierService stuffBidSupplierService;
	@Autowired
	private IStuffDocumentSupplierService stuffDocumentSupplierService;
	@Autowired
	private IProcessService processService;
	@Autowired
	private IShareSupplierApi shareSupplierApi;
	@Autowired
	private IStuffPicketageRefsupplierService stuffPicketageRefsupplierService;
	@Autowired
	private IStuffPicketageSupplierService stuffPicketageSupplierService;
	@Autowired
	private IStuffInviteDetailRecordService stuffInviteDetailRecordService;
	@Autowired
	private IBatPlanApi batPlanApi;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	@Autowired
	private IMaterialBatchPlanApi materialBatchPlanApi;

	@Autowired
	private StuffDocumentController documentController;

	@Value("${gysUrl.updateTimeUrl}")
	private String updateTimeUrl;

	@Value("${gysUrl.winbidSavesUrl}")
	private String winbidSavesUrl;
	private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(billId);
		StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffPicketageEntity.getInviteId());
		if (stuffInviteEntity.getIsPushZcw() == 1){//确认推送筑材网
			LambdaQueryWrapper<StuffDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
			sellWrapper.eq(StuffDocumentSellEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
			sellWrapper.eq(StuffDocumentSellEntity::getTenderFlag, 1);//是否中标  1是
			List<StuffDocumentSellEntity> stuffDocumentSellList = stuffDocumentSellService.list(sellWrapper);
			for (StuffDocumentSellEntity stuffDocumentSellEntity : stuffDocumentSellList) {
				if (stuffDocumentSellEntity.getSupplierTenantId() == null){
					return CommonResponse.error("中标供应商中存在筑材网报价供应商，请先先联系中标的供应商准入，点击‘供应商信息同步’按钮后再提交单据！");
				}
			}
		}

		//中标供应商同步
		CommonResponse<Boolean> booleanCommonResponse = documentController.synSupplier(stuffPicketageEntity.getDocumentId());
		if(booleanCommonResponse != null ){
			if( booleanCommonResponse.getCode() != 0) {
				return CommonResponse.error("请准入中标供应商后，点击供应商信息同步按钮！");
			}
		}else {
			return CommonResponse.error("同步供应商信息出错！请联系管理员！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StuffBidVO stuffBidVO = stuffBidService.saveBid(billId);
		stuffBidService.publishBid(stuffBidVO);

		//处理参照表,只处理项目线的数据
		//查询出所有定标的数据

		StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(billId);
		StuffInviteEntity stuffInviteEntity = stuffInviteService.selectById(stuffPicketageEntity.getInviteId());

		// 完成采购计划
		QueryParam stuffInviteDetailQueryParam = new QueryParam();
		stuffInviteDetailQueryParam.getParams()
				.put("invite_id", new Parameter(QueryParam.EQ, stuffInviteEntity.getId()));
		List<StuffInviteDetailRecordEntity> stuffInviteDetailEntityList = stuffInviteDetailRecordService
				.queryList(stuffInviteDetailQueryParam);
		// 获取采购计划ID
		if (CollectionUtils.isNotEmpty(stuffInviteDetailEntityList)) {
			List<String> planIdList = stuffInviteDetailEntityList.stream()
					.map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
					.collect(Collectors.toList());
			// 释放采购计划
			//if (stuffInviteEntity.getPurchaseType() == 0 ){
				CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),0);
				if (!response.isSuccess()) {
					throw new BusinessException("修改批次计划状态失败" + response.getMsg());
				}
//			}else {
//				CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState());
//				if (!response.isSuccess()) {
//					throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//				}
//			}
		}

		LambdaQueryWrapper<StuffDocumentSellEntity> sellWrapper = Wrappers.lambdaQuery();
		sellWrapper.eq(StuffDocumentSellEntity::getDocumentId, stuffPicketageEntity.getDocumentId());
		sellWrapper.eq(StuffDocumentSellEntity::getTenderFlag, 1);//是否中标  1是
		List<StuffDocumentSellEntity> stuffDocumentSellList = stuffDocumentSellService.list(sellWrapper);

		//项目招标
		//改造-0905
		Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
		//if (stuffInviteEntity.getPurchaseType().equals(0)){
			List<Long> projectPks = stuffDocumentSellList.stream().map(StuffDocumentSellEntity::getProjectId).collect(Collectors.toList());
			CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(projectPks);

			if (jsonArrayCommonResponse.isSuccess()){
				JSONArray data = jsonArrayCommonResponse.getData();
				List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
				proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
			}
		//}


		Map<String, List<StuffDocumentSellEntity>> dataMap = new HashMap<>();
		// 采购方式(0-项目采购,1-单位采购)
			for (StuffDocumentSellEntity stuffDocumentSellEntity : stuffDocumentSellList) {
				//改造-0905
				//if (stuffInviteEntity.getPurchaseType().equals(0)){
					ProjectPoolSetVO projectPoolSetVO = proMap.get(stuffDocumentSellEntity.getProjectId());
					if (projectPoolSetVO != null){
						stuffDocumentSellEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
						stuffDocumentSellEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
					}
				//}
				String s = null;
				//if (stuffInviteEntity.getPurchaseType().equals(0)){
					s = stuffDocumentSellEntity.getProjectId().toString() + stuffDocumentSellEntity.getSupplierId()
							.toString();
//				}
//				if (stuffInviteEntity.getPurchaseType().equals(1)){
//					s = stuffDocumentSellEntity.getSupplierId().toString() + stuffDocumentSellEntity.getOrgId()
//							.toString();
//				}
				if (dataMap.containsKey(s)) {
					List<StuffDocumentSellEntity> stuffDocumentSellEntityList = dataMap.get(s);
					stuffDocumentSellEntityList.add(stuffDocumentSellEntity);
					dataMap.put(s,stuffDocumentSellEntityList);
				}else {
					List<StuffDocumentSellEntity> stuffDocumentSellEntities = new ArrayList<>();
					stuffDocumentSellEntities.add(stuffDocumentSellEntity);
					dataMap.put(s,stuffDocumentSellEntities);
				}
			}

		List<StuffPicketageRefsupplierEntity> stuffPicketageRefsupplierEntities = new ArrayList<>();
		dataMap.forEach((key,value) -> {
			StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = new StuffPicketageRefsupplierEntity();
			StuffDocumentSellEntity stuffSellEntity = value.stream().findFirst().get();
			stuffPicketageRefsupplierEntity.setSupplierId(stuffSellEntity.getSupplierId());
			stuffPicketageRefsupplierEntity.setSupplierName(stuffSellEntity.getSupplierName());
			stuffPicketageRefsupplierEntity.setProjectId(stuffSellEntity.getProjectId());
			stuffPicketageRefsupplierEntity.setProjectName(stuffSellEntity.getProjectName());
			stuffPicketageRefsupplierEntity.setProjectCode(stuffInviteEntity.getProjectCode());
			stuffPicketageRefsupplierEntity.setPicketageId(billId);
			stuffPicketageRefsupplierEntity.setOccupyFlag(0);
			SupplierDTO supplierVO = shareSupplierApi.queryById(stuffSellEntity.getSupplierId()).getData();
			stuffPicketageRefsupplierEntity.setSupplierTenantId(supplierVO.getTenant());
			stuffPicketageRefsupplierEntity.setPicketageName(stuffPicketageEntity.getPicketageName());
			stuffPicketageRefsupplierEntity.setPicketageDate(new Date());
			//改造-0905
			//if (stuffInviteEntity.getPurchaseType().equals(0)){

			if (stuffSellEntity.getOrgId() != null) {
				stuffPicketageRefsupplierEntity.setOrgId(stuffSellEntity.getOrgId());
				stuffPicketageRefsupplierEntity.setOrgName(stuffSellEntity.getOrgName());
			}else {
				stuffPicketageRefsupplierEntity.setOrgId(stuffInviteEntity.getParentOrgId());
				stuffPicketageRefsupplierEntity.setOrgName(stuffInviteEntity.getParentOrgName());
			}
//			}
//			if (stuffInviteEntity.getPurchaseType().equals(1)){
//				stuffPicketageRefsupplierEntity.setOrgId(stuffSellEntity.getOrgId());
//				stuffPicketageRefsupplierEntity.setOrgName(stuffSellEntity.getOrgName());
//			}

			stuffPicketageRefsupplierEntity.setParentOrgId(stuffInviteEntity.getParentOrgId());
			stuffPicketageRefsupplierEntity.setParentOrgName(stuffInviteEntity.getParentOrgName());
			stuffPicketageRefsupplierEntity.setPicketageFlag(0);
			stuffPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
			stuffPicketageRefsupplierEntity.setPurchaseType(stuffInviteEntity.getPurchaseType());
			stuffPicketageRefsupplierEntity.setFallRate(stuffSellEntity.getFallRate());
			stuffPicketageRefsupplierEntity.setFallMny(stuffSellEntity.getFallMny());

			BigDecimal tenderMoney = BigDecimal.ZERO;
			BigDecimal tenderMoneyTax = BigDecimal.ZERO;
			for (StuffDocumentSellEntity stuffDocumentSellEntity : value){
				tenderMoney = tenderMoney.add(stuffDocumentSellEntity.getTenderMoney());
				tenderMoneyTax = tenderMoneyTax.add(stuffDocumentSellEntity.getTenderMoneyTax());
			}
			stuffPicketageRefsupplierEntity.setMoney(tenderMoney.setScale(2, BigDecimal.ROUND_HALF_UP));
			stuffPicketageRefsupplierEntity.setMoneyTax(tenderMoneyTax.setScale(2, BigDecimal.ROUND_HALF_UP));
			stuffPicketageRefsupplierEntities.add(stuffPicketageRefsupplierEntity);
		});
		stuffPicketageRefsupplierService.saveBatch(stuffPicketageRefsupplierEntities);

		//生成中标通知书类表数据
		List<StuffPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
		List<StuffAdviceEntity> stuffAdviceList = BeanMapper.mapList(picketageSupplierList, StuffAdviceEntity.class);
		for (StuffAdviceEntity stuffAdviceEntity : stuffAdviceList){
			stuffAdviceEntity.setTitleName(stuffInviteEntity.getTenderName());
			stuffAdviceEntity.setUnitId(stuffInviteEntity.getUnitId());
			stuffAdviceEntity.setUnitName(stuffInviteEntity.getUnitName());
			stuffAdviceEntity.setProjectId(stuffInviteEntity.getProjectId());
			stuffAdviceEntity.setProjectName(stuffInviteEntity.getProjectName());
			stuffAdviceEntity.setOrgId(stuffInviteEntity.getOrgId());
			stuffAdviceEntity.setOrgName(stuffInviteEntity.getOrgName());
			stuffAdviceEntity.setParentOrgId(stuffInviteEntity.getParentOrgId());
			stuffAdviceEntity.setParentOrgName(stuffInviteEntity.getParentOrgName());
			stuffAdviceEntity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(stuffInviteEntity.getTenderType()).getDescription());
			stuffAdviceEntity.setLineTypeName(CommonUtils.getTypeName(0));
			stuffAdviceEntity.setPurchaseType(stuffInviteEntity.getPurchaseType());
			stuffAdviceEntity.setScFlag(1);
			stuffAdviceEntity.setSendFlag(1);
			stuffAdviceEntity.setSignFlag(0);
			stuffAdviceEntity.setId(null);
			stuffAdviceEntity.setInviteId(stuffInviteEntity.getId());
		}

		stuffAdviceService.saveBatch(stuffAdviceList);


		stuffDocumentService.zcwPicket(stuffInviteEntity,stuffDocumentSellList);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			StuffPicketageEntity entity = stuffPicketageService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
