package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentTalkMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@Service("equipmentTalkService")
public class EquipmentTalkServiceImpl extends BaseServiceImpl<EquipmentTalkMapper, EquipmentTalkEntity> implements IEquipmentTalkService{
    @Value("${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IEquipmentTalkDetailService equipmentTalkDetailService;
    @Autowired
    private IEquipmentTalkRecordService equipmentTalkRecordService;
    @Autowired
    private IEquipmentTalkRecordDetailService equipmentTalkRecordDetailService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProcessService processService;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000001";
    private org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public EquipmentTalkVO publishTalk(Long id) {
        //更新发布状态
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(id);
        equipmentTalkEntity.setPublishFlag(0);
        super.updateById(equipmentTalkEntity);

        //推送供应商
        EquipmentDocumentSupplierTbVO equipmentDocumentSupplierTbVO = new EquipmentDocumentSupplierTbVO();
        equipmentDocumentSupplierTbVO.setSourceId(equipmentTalkEntity.getInviteId().toString());
        equipmentDocumentSupplierTbVO.setSourceType("郑州一建洽商谈判");
        equipmentDocumentSupplierTbVO.setNoticeType(4);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(equipmentTalkEntity.getTalkStartTime());
        equipmentDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(equipmentTalkEntity.getTalkEndTime());
        equipmentDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        equipmentDocumentSupplierTbVO.setMemo(equipmentTalkEntity.getMemo());
        equipmentDocumentSupplierTbVO.setTalkMoney(equipmentTalkEntity.getTalkMoney());
        equipmentDocumentSupplierTbVO.setTalkNum(equipmentTalkEntity.getTalkNum());
        equipmentDocumentSupplierTbVO.setTenderName(equipmentTalkEntity.getTalkName());
        equipmentDocumentSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString(equipmentDocumentSupplierTbVO);
        logger.info("洽商谈判发布" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(id);
    }

    @Override
    public EquipmentTalkVO extendTalk(EquipmentTalkDetailVO equipmentTalkDetailVO) {
        EquipmentTalkDetailEntity equipmentDocumentRecordEntity = BeanMapper.map(equipmentTalkDetailVO, EquipmentTalkDetailEntity.class);
        equipmentTalkDetailService.save(equipmentDocumentRecordEntity);
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(equipmentTalkDetailVO.getTalkId());
        equipmentTalkEntity.setTalkEndTime(equipmentTalkDetailVO.getNewTime());
        boolean b = super.updateById(equipmentTalkEntity);

        //推送供方
        EquipmentSupplierSellVO supplierSellVO = new EquipmentSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(equipmentTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(equipmentTalkDetailVO.getNewTime());

        String stringFb = JSONObject.toJSONString(supplierSellVO);

        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateTimeUrl, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("洽商谈判同步供方接口报错" + stringCommonResponse.getMsg());
        }

        return queryDetail(equipmentTalkDetailVO.getTalkId());
    }

    @Override
    public EquipmentTalkVO saveTalk(Long documentId) {
        EquipmentTalkEntity entity = new EquipmentTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        EquipmentDocumentEntity documentEntity = equipmentDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        equipmentDocumentService.saveOrUpdate(documentEntity);
        //查询招标立项信息
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(documentId);
        EquipmentInviteEntity equipmentInviteEntity = equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId());
        entity.setProjectCode(equipmentDocumentEntity.getProjectCode());
        entity.setInviteId(equipmentDocumentEntity.getInviteId());
        entity.setProjectId(equipmentDocumentEntity.getProjectId());
        entity.setProjectName(equipmentDocumentEntity.getProjectName());
        entity.setOrgId(equipmentDocumentEntity.getOrgId());
        entity.setOrgName(equipmentDocumentEntity.getOrgName());
        entity.setParentOrgId(equipmentDocumentEntity.getParentOrgId());
        entity.setParentOrgName(equipmentDocumentEntity.getParentOrgName());
        entity.setBrandFlag(equipmentDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(equipmentDocumentEntity.getPurchaseType());
        entity.setTalkName(equipmentInviteEntity.getTenderName());
        super.save(entity);

        //回写招标阶段

        equipmentInviteEntity.setTenderStage(7);
        equipmentInviteService.updateById(equipmentInviteEntity);

        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("洽商谈判");
        processEntity.setTenderId(equipmentDocumentEntity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/talkNegotiate");
        processService.saveOrUpdate(processEntity);

        EquipmentTalkVO vo = BeanMapper.map(entity, EquipmentTalkVO.class);

        EquipmentTalkVO equipmentTalkVO = queryDetail(vo.getId());
        return equipmentTalkVO;
    }

    @Override
    public EquipmentTalkVO queryDetail(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(id);
        EquipmentTalkVO equipmentTalkVO = BeanMapper.map(equipmentTalkEntity, EquipmentTalkVO.class);

        //确认轮数
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        if (equipmentTalkEntity.getPublishFlag() == 1){
            talkNum = talkNum - 1;
        }
        EquipmentDocumentVO equipmentDocumentVO = equipmentDocumentService.queryDocDetail(equipmentTalkEntity.getBillId(), talkNum);

        //查询供应商报价方案数据


        equipmentTalkVO.setEquipmentDocumentDetailSellList(equipmentDocumentVO.getEquipmentDocumentDetailSellList());
        equipmentTalkVO.setEquipmentDocumentSupplierSchemeList(equipmentDocumentVO.getEquipmentDocumentSupplierSchemeList());

        //查询首轮报价的供应商信息
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambda = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambda.eq(EquipmentDocumentSupplierEntity::getDocumentId, equipmentTalkEntity.getBillId());
        lambda.eq(EquipmentDocumentSupplierEntity::getTalkNum, 0);
        List<EquipmentDocumentSupplierEntity> supplierList = equipmentDocumentSupplierService.list(lambda);
        List<EquipmentDocumentSupplierVO> documentSupplierVOList = BeanMapper.mapList(supplierList,EquipmentDocumentSupplierVO.class);
        equipmentTalkVO.setEquipmentDocumentSupplierList(documentSupplierVOList);

        //查询变更历史记录
        LambdaQueryWrapper<EquipmentTalkRecordEntity> lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(EquipmentTalkRecordEntity::getBillId,equipmentTalkEntity.getBillId());
        lambdaRecord.orderByAsc(EquipmentTalkRecordEntity::getTalkNum);
        List<EquipmentTalkRecordEntity> equipmentTalkRecordEntityList = equipmentTalkRecordService.list(lambdaRecord);
        List<EquipmentTalkRecordVO> equipmentTalkRecordList = BeanMapper.mapList(equipmentTalkRecordEntityList, EquipmentTalkRecordVO.class);
        equipmentTalkVO.setTalkRecordEntityList(equipmentTalkRecordList);
        return equipmentTalkVO;
    }
    @Transactional
    @Override
    public EquipmentTalkVO againSaveTalk(Long id) {
        EquipmentTalkEntity entity = new EquipmentTalkEntity();
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询招标立项信息
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(id);
        entity.setProjectCode(equipmentTalkEntity.getProjectCode());
        entity.setProjectId(equipmentTalkEntity.getProjectId());
        entity.setProjectName(equipmentTalkEntity.getProjectName());
        entity.setOrgId(equipmentTalkEntity.getOrgId());
        entity.setOrgName(equipmentTalkEntity.getOrgName());
        entity.setParentOrgId(equipmentTalkEntity.getParentOrgId());
        entity.setParentOrgName(equipmentTalkEntity.getParentOrgName());
        entity.setBrandFlag(equipmentTalkEntity.getBrandFlag());
        entity.setBillId(equipmentTalkEntity.getBillId());
        entity.setInviteId(equipmentTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(equipmentTalkEntity.getTalkNum() + 1);
        String taikNumName = "第" + entity.getTalkNum() + "轮报价";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(equipmentTalkEntity.getPurchaseType());
        super.save(entity);

        //保存历史记录表
        EquipmentTalkRecordEntity equipmentTalkRecordEntity =  BeanMapper.map(equipmentTalkEntity,EquipmentTalkRecordEntity.class);
        equipmentTalkRecordEntity.setTalkId(equipmentTalkEntity.getId());
        equipmentTalkRecordEntity.setId(null);
        equipmentTalkRecordService.save(equipmentTalkRecordEntity);
        //新增历史记录子表
        List<EquipmentTalkDetailEntity> equipmentTalkDetailList = equipmentTalkEntity.getEquipmentTalkDetailList();
        List<EquipmentTalkRecordDetailEntity> equipmentTalkRecordDetailEntityList = BeanMapper.mapList(equipmentTalkDetailList,EquipmentTalkRecordDetailEntity.class);
        for (EquipmentTalkRecordDetailEntity equipmentTalkRecordDetailEntity : equipmentTalkRecordDetailEntityList){
            equipmentTalkRecordDetailEntity.setId(null);
            equipmentTalkRecordDetailEntity.setRecordId(equipmentTalkRecordEntity.getId());
        }
        equipmentTalkRecordDetailService.saveBatch(equipmentTalkRecordDetailEntityList);

        //删除老数据
        super.removeById(id,false);

        //修改进展表信息
        LambdaQueryWrapper<ProcessEntity> lambdaProcess = Wrappers.<ProcessEntity>lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId,id);
        lambdaProcess.eq(ProcessEntity::getTenderId,equipmentTalkEntity.getInviteId());
        ProcessEntity processEntity = processService.getOne(lambdaProcess);
        processEntity.setBillId(entity.getId());
        processService.updateById(processEntity);
        EquipmentTalkVO vo = BeanMapper.map(entity, EquipmentTalkVO.class);
        addLastSell(equipmentTalkEntity.getTalkNum(),equipmentTalkEntity.getBillId());

        return queryDetail(entity.getId());
    }

    @Override
    public EquipmentTalkVO replenishSell(Long id) {
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(id);

        Integer talkNum = equipmentTalkEntity.getTalkNum();
        Long billId = equipmentTalkEntity.getBillId();
        addLastSell(talkNum,billId);

        return new EquipmentTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        //获取最新轮数
        EquipmentTalkEntity equipmentTalkEntity = super.selectById(id);
        Integer talkNum = equipmentTalkEntity.getTalkNum();
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplier = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, equipmentTalkEntity.getBillId());
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, talkNum);
        List<EquipmentDocumentSupplierEntity> supplierList = equipmentDocumentSupplierService.list(lambdaSupplier);
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplierFirst = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierFirst.eq(EquipmentDocumentSupplierEntity::getDocumentId, equipmentTalkEntity.getBillId());
        lambdaSupplierFirst.eq(EquipmentDocumentSupplierEntity::getTalkNum, 0);
        List<EquipmentDocumentSupplierEntity> supplierListFirst = equipmentDocumentSupplierService.list(lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0){
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()){
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        Map<String, Object> stringListMap = new HashMap<>();
        EquipmentTalkEntity equipmentTalkEntity = baseMapper.selectById(talkId);
        List<EquipmentQuotationMaterialVO> materialVOList = new ArrayList<>();
        //查询所有数据
        List<EquipmentDocumentSellEntity> equipmentDocumentSellEntities = equipmentDocumentSellService.selectMaterialType(equipmentTalkEntity.getBillId());
        Integer talkNum = equipmentDocumentSellEntities.get(0).getTalkNum();
        List<EquipmentDocumentSellVO> sellEntityList = BeanMapper.mapList(equipmentDocumentSellEntities, EquipmentDocumentSellVO.class);
        //根据项目分组
        Map<Long, List<EquipmentDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getProjectId));
        for (List<EquipmentDocumentSellVO> sellVOS : collect.values()) {
            //根据材料分类
            Map<Long, List<EquipmentDocumentSellVO>> listMap = sellVOS.stream().filter(map->map.getMaterialId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                EquipmentQuotationMaterialVO materialVO = new EquipmentQuotationMaterialVO();
                //获取供应商
                List<EquipmentDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (EquipmentDocumentSellVO sellVO : materialTypeList) {
                    materialVO  =  BeanMapper.map(sellVO, EquipmentQuotationMaterialVO.class);
                }
                List<EquipmentQuotationSupplierVO> equipmentQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, EquipmentQuotationSupplierVO.class);
                //供应商ID去重
                List<EquipmentQuotationSupplierVO> supplierVOS = equipmentQuotationSupplierVOS.stream()
                        .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EquipmentQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                //根据供应商分类
                Map<Long, List<EquipmentDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map->map.getSupplierId() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSupplierId));

                for (EquipmentQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    //获取方案
                    List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOS) {
                        supplierVO.setSupplierName(equipmentDocumentSellVO.getSupplierName());
                    }
                    List<EquipmentQuotationSchemeVO> equipmentQuotationSchemeVOS = BeanMapper.mapList(equipmentDocumentSellVOS, EquipmentQuotationSchemeVO.class);
                    //根据方案名称去重
                    List<EquipmentQuotationSchemeVO> schemeVOS = equipmentQuotationSchemeVOS.stream()
                            .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<EquipmentDocumentSellVO>> schemeMap = equipmentDocumentSellVOS.stream().filter(map->map.getSchemeName() != null).collect(Collectors.groupingBy(EquipmentDocumentSellVO::getSchemeName));
                    for (EquipmentQuotationSchemeVO equipmentQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<EquipmentDocumentSellVO> priceList = schemeMap.get(equipmentQuotationSchemeVO.getSchemeName());
                        //如果轮数小于最大轮数，添加一个空的对象
                        if (priceList.size()<talkNum+1){
                            EquipmentDocumentSellVO documentSellVO = new EquipmentDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0,documentSellVO);
                        }
                        equipmentQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList",materialVOList);
        stringListMap.put("offerNum",equipmentDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public EquipmentTalkVO saveOrUpdates(EquipmentTalkVO saveorUpdateVO) {
        EquipmentTalkEntity entity = BeanMapper.map(saveorUpdateVO, EquipmentTalkEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        EquipmentTalkVO vo = BeanMapper.map(entity, EquipmentTalkVO.class);
        EquipmentTalkVO equipmentTalkVO = queryDetail(vo.getId());
        return equipmentTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        //补足未报价供应商信息
        //查询上一轮数
        //查询报价信息,判断本轮没有报价的供应商
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplier = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getTalkNum, talkNum);
        List<EquipmentDocumentSupplierEntity> supplierList = equipmentDocumentSupplierService.list(lambdaSupplier);

        //查询
        LambdaQueryWrapper<EquipmentDocumentSupplierEntity> lambdaSupplierLast = Wrappers.<EquipmentDocumentSupplierEntity>lambdaQuery();
        lambdaSupplierLast.eq(EquipmentDocumentSupplierEntity::getDocumentId, docId);
        lambdaSupplierLast.eq(EquipmentDocumentSupplierEntity::getTalkNum, talkNum - 1);
        List<EquipmentDocumentSupplierEntity> supplierListLast = equipmentDocumentSupplierService.list(lambdaSupplierLast);
        List<Long> supplierPk = supplierList.stream().map(EquipmentDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List<EquipmentDocumentSupplierEntity> documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List<EquipmentDocumentSupplierEntity> documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList,EquipmentDocumentSupplierEntity.class);

        if (documentSupplierEntityDataList.size() == 0){
            return;
        }

        //推送供应商数据提示信息
        List<SupplierReplenishVO> replenishVOArrayList = new ArrayList<>();
        EquipmentDocumentEntity equipmentDocumentEntity = equipmentDocumentService.selectById(docId);
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList){
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(equipmentDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            supplierReplenishVO.setTenantId(Long.toString(equipmentDocumentSupplierEntity.getSupplierTenantId()));
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        logger.info("再次洽商推送供方接口数据:" + stringFb);
        //调用第三方报名接口
        CommonResponse<JSONObject> response = null;
        CommonResponse<String> stringCommonResponse = systemDataPushService.exchangeDataWithUniversal(updateSupOffer, RequestMethod.POST, stringFb, appId, appSecret, appHost);
        if(!stringCommonResponse.isSuccess()) {
            throw new BusinessException("再次洽商推送供方接口数据response:" + stringCommonResponse.getMsg());
        }

        List<Long> supplierPkNew = documentSupplierEntityNewList.stream().map(EquipmentDocumentSupplierEntity::getId).collect(Collectors.toList());
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList){
            equipmentDocumentSupplierEntity.setId(IdWorker.getId());
            equipmentDocumentSupplierEntity.setTalkNum(talkNum);
        }
        equipmentDocumentSupplierService.saveBatch(documentSupplierEntityNewList);

        //复制上一轮未报价的供应商的附件信息
        for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList){
            for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierLastEntity : supplierListLast){
                if (equipmentDocumentSupplierEntity.getSupplierId().equals(equipmentDocumentSupplierLastEntity.getSupplierId())){
                    CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
                            equipmentDocumentSupplierLastEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType",
                            equipmentDocumentSupplierEntity.getId().toString(),
                            BILL_SUPPLIER_TYPE,
                            "supplierFileType"
                    );
                if (!responseCopy.isSuccess()) {
                    throw new BusinessException("再次洽商附件复制失败:" + responseCopy.getMsg());
                }
                }

            }
        }


        //查询上一轮未报价供应商的方案
        LambdaQueryWrapper<EquipmentDocumentSchemeEntity> lambdaScheme = Wrappers.<EquipmentDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, docId);
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, talkNum - 1);
        lambdaScheme.in(EquipmentDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List<EquipmentDocumentSchemeEntity> schemeList = equipmentDocumentSchemeService.list(lambdaScheme);
        List<Long> schemePkList = schemeList.stream().map(EquipmentDocumentSchemeEntity::getId).collect(Collectors.toList());
        for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList){
            equipmentDocumentSchemeEntity.setId(IdWorker.getId());
            equipmentDocumentSchemeEntity.setTalkNum(talkNum);
            for (EquipmentDocumentSupplierEntity equipmentDocumentSupplierEntity : documentSupplierEntityNewList){
                if (equipmentDocumentSchemeEntity.getSupplierId().equals(equipmentDocumentSupplierEntity.getSupplierId())){
                    equipmentDocumentSchemeEntity.setDocumentSupplierId(equipmentDocumentSupplierEntity.getId());
                }
            }
        }
        equipmentDocumentSchemeService.saveBatch(schemeList);

        //查询上一轮未报价供应商的方案详情
        LambdaQueryWrapper<EquipmentDocumentSellEntity> lambdaSell = Wrappers.<EquipmentDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, docId);
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, talkNum - 1);
        lambdaSell.in(EquipmentDocumentSellEntity::getSchemeId, schemePkList);
        List<EquipmentDocumentSellEntity> sellList = equipmentDocumentSellService.list(lambdaSell);
        for (EquipmentDocumentSellEntity equipmentDocumentSellEntity : sellList){
            equipmentDocumentSellEntity.setId(null);
            equipmentDocumentSellEntity.setTalkNum(talkNum);
            for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList){
                if (equipmentDocumentSellEntity.getSupplierId().equals(equipmentDocumentSchemeEntity.getSupplierId()) &&
                        equipmentDocumentSellEntity.getSchemeName().equals(equipmentDocumentSchemeEntity.getSchemeName())){
                    equipmentDocumentSellEntity.setSchemeId(equipmentDocumentSchemeEntity.getId());
                }

            }
        }
        equipmentDocumentSellService.saveBatch(sellList);
    }
}
