package com.ejianc.business.tender.rmat.service;

import com.ejianc.business.tender.rmat.vo.RmatDocumentRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IRmatDocumentService extends IBaseService<RmatDocumentEntity> {

    RmatDocumentVO publishDocument(Long id) throws Exception;

    RmatDocumentVO bidDocument(Long id);

    RmatDocumentVO queryDetail(Long id);

    RmatDocumentVO queryDocDetail(Long id,Integer talkNum);


    List<RmatDocumentSellVO> getSchemeDetail(RmatDocumentSellVO rmatDocumentSellVO);

    RmatDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    RmatDocumentVO extendDocument(RmatDocumentRecordVO rmatDocumentRecordVO);

    RmatDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    RmatDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    RmatDocumentVO saveManyDocument(Long id);

    RmatDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    RmatDocumentVO saveDocument(Long noticeId);

    RmatDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId,Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    RmatDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    RmatDocumentVO saveOrUpdates(RmatDocumentVO saveorUpdateVO);

    RmatDocumentVO queryDetail1(Long documentId, Integer num);

    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);

}
