package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffCostDesktopDTO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageRefsupplierVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.stuff.mapper.StuffPicketageRefsupplierMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("stuffPicketageRefsupplierService")
public class StuffPicketageRefsupplierServiceImpl extends BaseServiceImpl<StuffPicketageRefsupplierMapper, StuffPicketageRefsupplierEntity> implements IStuffPicketageRefsupplierService{
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteDetailBidderService stuffInviteDetailBidderService;
    @Autowired
    private IStuffInviteDetailService stuffInviteDetailService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffPicketageService stuffPicketageService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = super.selectById(id);
        stuffPicketageRefsupplierEntity.setOccupyFlag(occupyFlag);
        super.updateById(stuffPicketageRefsupplierEntity);
        return "更新成功!";
    }

    @Override
    public IPage<StuffPicketageRefsupplierVO> picketageRef(QueryParam param) {
        IPage<StuffPicketageRefsupplierVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<StuffPicketageRefsupplierVO> list = baseMapper.queryPicketageRef(changeToQueryWrapper(param), page);
        IPage<StuffPicketageRefsupplierVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO,Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("材料定标占用参数"+stringFb);
        StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标
        Integer picketageFlag = stuffPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            List<TenderPicketageDetailVO> detailList = tenderPicketageVO.getTenderPicketageDetailList();
            for (TenderPicketageDetailVO tenderPicketageDetailVO : detailList){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        StuffPicketageEntity stuffPicketageEntity = stuffPicketageService.selectById(stuffPicketageRefsupplierEntity.getPicketageId());
        StuffInviteEntity stuffInviteEntity = null;
        if(picketageFlag == 0){
            stuffInviteEntity = stuffInviteService.selectById(stuffPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            stuffInviteEntity = stuffInviteService.selectById(stuffPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity(),(k1, k2) -> k2));
        if (picketageFlag == 0) {
            LambdaQueryWrapper<StuffDocumentSellEntity> lambdaSell = Wrappers.<StuffDocumentSellEntity>lambdaQuery();
            lambdaSell.in(StuffDocumentSellEntity::getId, sellIds);
            List<StuffDocumentSellEntity> sellEntityList = stuffDocumentSellService.list(lambdaSell);
            for (StuffDocumentSellEntity stuffDocumentSellEntity : sellEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(stuffDocumentSellEntity.getId());
                BigDecimal num = stuffDocumentSellEntity.getSignNum() == null ? BigDecimal.ZERO : stuffDocumentSellEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                stuffDocumentSellEntity.setSignNum(signNum);
            }
            stuffDocumentSellService.updateBatchById(sellEntityList);
        }
        if (picketageFlag == 1) {
            LambdaQueryWrapper<StuffInviteDetailBidderEntity> lambdaBidder = Wrappers.<StuffInviteDetailBidderEntity>lambdaQuery();
            lambdaBidder.in(StuffInviteDetailBidderEntity::getId, sellIds);
            List<StuffInviteDetailBidderEntity> bidderEntityList = stuffInviteDetailBidderService.list(lambdaBidder);
            for (StuffInviteDetailBidderEntity stuffInviteDetailBidderEntity : bidderEntityList) {
                TenderPicketageDetailVO tenderPicketageDetailVO = detailVOMap.get(stuffInviteDetailBidderEntity.getId());
                BigDecimal num = stuffInviteDetailBidderEntity.getSignNum() == null ? BigDecimal.ZERO : stuffInviteDetailBidderEntity.getSignNum();
                BigDecimal signNum = num.add(tenderPicketageDetailVO.getSignNum());
                stuffInviteDetailBidderEntity.setSignNum(signNum);
            }
            stuffInviteDetailBidderService.updateBatchById(bidderEntityList);
        }
        Boolean allSign = null;
        Boolean wqSign = null;
        if (picketageFlag == 0) {

            LambdaQueryWrapper<StuffDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(StuffDocumentSellEntity::getDocumentId,stuffPicketageEntity.getDocumentId());
            listWrapper.eq(StuffDocumentSellEntity::getSupplierId,stuffPicketageRefsupplierEntity.getSupplierId());
            if (stuffPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(StuffDocumentSellEntity::getProjectId,stuffPicketageRefsupplierEntity.getProjectId());
            }

            listWrapper.eq(StuffDocumentSellEntity::getTenderFlag,1);
            List<StuffDocumentSellEntity> documentSellList = stuffDocumentSellService.list(listWrapper);

            //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
            allSign = documentSellList.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getTenderNum()) > -1);
            wqSign = documentSellList.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);


        }
        if (picketageFlag == 1) {

            LambdaQueryWrapper<StuffInviteDetailBidderEntity> listDetailBidder = Wrappers.lambdaQuery();
            listDetailBidder.eq(StuffInviteDetailBidderEntity::getInviteId,stuffPicketageRefsupplierEntity.getPicketageId());
            listDetailBidder.eq(StuffInviteDetailBidderEntity::getSupplierId,stuffPicketageRefsupplierEntity.getSupplierId());
            List<StuffInviteDetailBidderEntity> detailBidderList = stuffInviteDetailBidderService.list(listDetailBidder);

            List<Long> detailIds = detailBidderList.stream().map(StuffInviteDetailBidderEntity::getInviteDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<StuffInviteDetailEntity> lambdaDetail = Wrappers.<StuffInviteDetailEntity>lambdaQuery();
            lambdaDetail.in(StuffInviteDetailEntity::getId, detailIds);
            List<StuffInviteDetailEntity> detailEntityList = stuffInviteDetailService.list(lambdaDetail);

            Map<Long, StuffInviteDetailEntity> detailEntityMap = detailEntityList.stream().collect(Collectors.toMap(StuffInviteDetailEntity::getId, Function.identity(),(k1, k2) -> k2));
            List<StuffInviteDetailBidderEntity> stuffInviteDetailBidderEntities = new ArrayList<>();
            for (StuffInviteDetailBidderEntity stuffInviteDetailBidderEntity : detailBidderList){
                StuffInviteDetailEntity stuffInviteDetailEntity = detailEntityMap.get(stuffInviteDetailBidderEntity.getInviteDetailId());
                if (stuffPicketageRefsupplierEntity.getPurchaseType() == 0){
                    if (stuffPicketageRefsupplierEntity.getProjectId().equals(stuffInviteDetailEntity.getDetailProjectId())){
                        stuffInviteDetailBidderEntities.add(stuffInviteDetailBidderEntity);
                    }
                }
            }
            if (stuffPicketageRefsupplierEntity.getPurchaseType() == 1){
                stuffInviteDetailBidderEntities = detailBidderList;
            }

            //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
            allSign = stuffInviteDetailBidderEntities.stream().allMatch(e -> (e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(e.getNum()) > -1);
            wqSign = stuffInviteDetailBidderEntities.stream().allMatch(e ->(e.getSignNum() == null ? BigDecimal.ZERO : e.getSignNum()).compareTo(BigDecimal.ZERO) == 0);
        }


        Integer signStatus = null;
        if (allSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (wqSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (!stuffPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode()) && !allSign && !wqSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }
        if (stuffPicketageRefsupplierEntity.getSignStatus().equals(TenderSignStatusEnum.已关闭.getCode())) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }

        stuffPicketageRefsupplierEntity.setSignStatus(signStatus);
        //更新参照表状态
        BigDecimal contractMoney = stuffPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : stuffPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = stuffPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : stuffPicketageRefsupplierEntity.getContractMoneyTax();
        stuffPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        stuffPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        super.updateById(stuffPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<StuffPicketageRefsupplierEntity> lambdaRef = Wrappers.<StuffPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(StuffPicketageRefsupplierEntity::getPicketageId, stuffPicketageRefsupplierEntity.getPicketageId());
        List<StuffPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }

        stuffInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        stuffInviteService.updateById(stuffInviteEntity);

        return "更新成功";
    }

    @Override
    public List<StuffCostDesktopDTO> getCostDesktopMaterialSum(String startTime, String endTime) {
        CommonResponse<List<MaterialCategoryVO>> listCommonResponse = shareMaterialApi.queryCategoryAllListByPid(1506516724499267586L);//钢筋
        CommonResponse<List<MaterialCategoryVO>> listCommonResponse1 = shareMaterialApi.queryCategoryAllListByPid(1506516727087153153L);//商混
        CommonResponse<List<MaterialCategoryVO>> listCommonResponse2 = shareMaterialApi.queryCategoryAllListByPid(1506516726898409473L);//预拌砂浆
        if (listCommonResponse.getCode() == 0 && listCommonResponse1.getCode() == 0 && listCommonResponse2.getCode() == 0 ){
            if (CollectionUtils.isNotEmpty(listCommonResponse.getData()) && CollectionUtils.isNotEmpty(listCommonResponse1.getData()) && CollectionUtils.isNotEmpty(listCommonResponse2.getData())){
                List<StuffCostDesktopDTO> costDesktopMaterialSum = baseMapper.getCostDesktopMaterialSum(startTime, endTime, listCommonResponse.getData(), listCommonResponse1.getData(), listCommonResponse2.getData());
                return costDesktopMaterialSum;
            }
        }
        return null;
    }


}
