package com.ejianc.business.tender.stuff.mapper;

import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSchemeEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.List;

/**
 * 招标文件方案表
 * 
 * @author generator
 * 
 */
@Mapper
public interface StuffDocumentSchemeMapper extends BaseCrudMapper<StuffDocumentSchemeEntity> {

    List<StuffDocumentSchemeEntity> selectSchemeList(@Param("id") Long id, @Param("supplierId") Long supplierId);
    @Select("SELECT * FROM `ejc_tender_stuff_document_scheme` WHERE document_id = #{documentId} and dr =0")
    List<StuffDocumentSchemeEntity> selectSupplier(Long documentId);
    @Update("UPDATE ejc_tender_stuff_document_scheme set score= #{score}  where id= #{id} and supplier_id = #{supplierId} and document_id =#{documentId} ")
    Boolean updateScore(@Param("id") Long id, @Param("supplierId") Long supplierId, @Param("documentId") Long documentId, @Param("score") BigDecimal score);
}
