/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.sub.bean.SubBidDetailEntity;
import com.ejianc.business.tender.sub.bean.SubBidEntity;
import com.ejianc.business.tender.sub.bean.SubBidSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSellEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubNoticeEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageEntity;
import com.ejianc.business.tender.sub.bean.SubPicketageSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubWinnoticeEntity;
import com.ejianc.business.tender.sub.mapper.SubBidMapper;
import com.ejianc.business.tender.sub.service.ISubBidDetailService;
import com.ejianc.business.tender.sub.service.ISubBidService;
import com.ejianc.business.tender.sub.service.ISubBidSupplierService;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubNoticeService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.service.ISubPicketageSupplierService;
import com.ejianc.business.tender.sub.service.ISubWinnoticeService;
import com.ejianc.business.tender.sub.vo.SubBidDetailVO;
import com.ejianc.business.tender.sub.vo.SubBidSupplierVO;
import com.ejianc.business.tender.sub.vo.SubBidVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.business.tender.sub.vo.SubPicketageVO;
import com.ejianc.business.tender.sub.vo.SubWinbidDetailVO;
import com.ejianc.business.tender.sub.vo.SubWinbidVO;
import com.ejianc.business.tender.sub.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="subBidService")
public class SubBidServiceImpl
extends BaseServiceImpl<SubBidMapper, SubBidEntity>
implements ISubBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private ISubNoticeService subNoticeService;
    @Autowired
    private ISubWinnoticeService subWinnoticeService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubBidDetailService subBidDetailService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubBidSupplierService subBidSupplierService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IShareSubleadersApi shareSubleadersApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public SubBidVO saveBid(Long picketageId) {
        SubBidEntity entity = new SubBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        SubPicketageEntity subPicketageEntity = (SubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        SubInviteEntity inviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        boolean b = super.saveOrUpdate((Object)entity, false);
        this.logger.info("bidSave" + b);
        SubBidVO vo = (SubBidVO)BeanMapper.map((Object)((Object)entity), SubBidVO.class);
        subPicketageEntity.setBidId(entity.getId());
        this.subPicketageService.updateById((Object)subPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(SubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSell.eq(SubDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, SubDocumentSellVO.class);
        Map<Long, List<SubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().collect(Collectors.groupingBy(SubDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSupplier.eq(SubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplierEntityMap = supplierList.stream().collect(Collectors.toMap(SubDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList subBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            SubBidSupplierVO subBidSupplierVO = new SubBidSupplierVO();
            subBidSupplierVO.setSupplierId(key);
            subBidSupplierVO.setSupplierName(((SubDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            SubDocumentSupplierEntity subDocumentSupplierEntity = (SubDocumentSupplierEntity)((Object)((Object)supplierEntityMap.get(key)));
            subBidSupplierVO.setLinkName(subDocumentSupplierEntity.getLinkName());
            subBidSupplierVO.setSupplierMobile(subDocumentSupplierEntity.getLinkMobile());
            subBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (SubDocumentSellVO subDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(subDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : subDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(subDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : subDocumentSellVO.getTenderMoney());
                SubBidDetailEntity subBidDetailEntity = (SubBidDetailEntity)((Object)((Object)BeanMapper.map((Object)subDocumentSellVO, SubBidDetailEntity.class)));
                subBidDetailEntity.setMoney(subDocumentSellVO.getTenderMoney());
                subBidDetailEntity.setMoneyTax(subDocumentSellVO.getTenderMoneyTax());
                subBidDetailEntity.setId(null);
                subBidDetailEntity.setBidSupplierId(subBidSupplierVO.getId());
                subBidDetailEntity.setBidId(entity.getId());
                subBidDetailEntityList.add(subBidDetailEntity);
            }
            subBidSupplierVO.setMoneyTax(tenderMoneyTax);
            subBidSupplierVO.setMoney(tenderMoney);
            subBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(subBidSupplierVO);
        });
        List subBidSupplierEntities = BeanMapper.mapList(supplierVOList, SubBidSupplierEntity.class);
        this.subBidSupplierService.saveBatch(subBidSupplierEntities);
        this.subBidDetailService.saveBatch(subBidDetailEntityList);
        String tenderUnitNum = new String();
        List<SubBidDetailEntity> bidDetailEntityList = ((SubBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (SubBidDetailEntity subBidDetailEntity : bidDetailEntityList) {
            SubBidSupplierEntity supplierEntity = (SubBidSupplierEntity)((Object)this.subBidSupplierService.selectById(subBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = subBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplierEntity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.subInviteService.saveOrUpdate((Object)inviteEntity);
        SubBidVO subBidVO = (SubBidVO)BeanMapper.map((Object)((Object)entity), SubBidVO.class);
        return subBidVO;
    }

    @Override
    public SubBidVO queryDetail(Long bidId) {
        SubBidEntity subBidEntity = (SubBidEntity)((Object)super.selectById((Serializable)bidId));
        SubBidVO subBidVO = (SubBidVO)BeanMapper.map((Object)((Object)subBidEntity), SubBidVO.class);
        List subBidDetailList = subBidVO.getSubBidDetailList();
        Map<Long, List<SubBidDetailVO>> detailMap = subBidDetailList.stream().collect(Collectors.groupingBy(SubBidDetailVO::getBidSupplierId));
        List subBidSupplierList = subBidVO.getSubBidSupplierList();
        for (SubBidSupplierVO subBidSupplierVO : subBidSupplierList) {
            subBidSupplierVO.setSubBidDetailList(detailMap.get(subBidSupplierVO.getId()));
        }
        subBidVO.setSubBidSupplierList(subBidSupplierList);
        return subBidVO;
    }

    @Override
    @Transactional
    public SubBidVO publishBid(SubBidVO saveorUpdateVO) {
        SubBidEntity entity = (SubBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        SubBidVO vo = (SubBidVO)BeanMapper.map((Object)((Object)entity), SubBidVO.class);
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(entity.getInviteId()));
        SubWinbidVO subWinbidVO = new SubWinbidVO();
        subWinbidVO.setSourceId(Long.toString(entity.getInviteId()));
        subWinbidVO.setBillCode(subInviteEntity.getBillCode());
        if (subWinbidVO.getPurchaseType() == null || subWinbidVO.getPurchaseType() == 1) {
            subWinbidVO.setSourceProjectId(null);
        } else {
            subWinbidVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
        }
        subWinbidVO.setProjectName(subInviteEntity.getProjectName());
        subWinbidVO.setProjectCode(subInviteEntity.getProjectCode());
        subWinbidVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));
        subWinbidVO.setOrgName(subInviteEntity.getOrgName());
        subWinbidVO.setUnitName(subInviteEntity.getUnitName());
        subWinbidVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        subWinbidVO.setType("MATERIAL");
        subWinbidVO.setTenderName(subInviteEntity.getTenderName());
        subWinbidVO.setTenderType(subInviteEntity.getTenderType());
        subWinbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(SubDocumentEntity::getInviteId, (Object)entity.getInviteId());
        SubDocumentEntity subDocumentEntity = (SubDocumentEntity)((Object)this.subDocumentService.getOne((Wrapper)lambdaDoc));
        subWinbidVO.setNoticeBidTime(subDocumentEntity.getBidTime());
        subWinbidVO.setNoticeWinbidTime(new Date());
        if (subInviteEntity.getTenderType() == 2 || subInviteEntity.getTenderType() == 3 || subInviteEntity.getTenderType() == 4 || subInviteEntity.getTenderType() == 5) {
            subWinbidVO.setSourceEmployeeId(Long.toString(subDocumentEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(subDocumentEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(SubNoticeEntity::getInviteId, (Object)entity.getInviteId());
            SubNoticeEntity noticeEntity = (SubNoticeEntity)((Object)this.subNoticeService.getOne((Wrapper)lambdaNotice));
            subWinbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        SubBidVO subBidVO = this.queryDetail(entity.getId());
        List subBidSupplierList = subBidVO.getSubBidSupplierList();
        ArrayList<SubWinbidVO> subWinbidVOList = new ArrayList<SubWinbidVO>();
        for (SubBidSupplierVO subBidSupplierVO : subBidSupplierList) {
            SubWinbidVO subWinbidVONew = (SubWinbidVO)BeanMapper.map((Object)subWinbidVO, SubWinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(subBidSupplierVO.getSupplierId()).getData();
            if (supplierVO == null) {
                CommonResponse subleadersVOCommonResponse = this.shareSubleadersApi.querySupplierByLeaderId(subBidSupplierVO.getSupplierId());
                if (subleadersVOCommonResponse.getCode() == 0) {
                    subWinbidVONew.setTenantId(((SubleadersVO)subleadersVOCommonResponse.getData()).getEjcTenantId());
                }
            } else {
                subWinbidVONew.setTenantId(supplierVO.getTenant());
            }
            subWinbidVONew.setWinbidMoneyTax(subBidSupplierVO.getMoneyTax());
            subWinbidVONew.setWinbidMoney(subBidSupplierVO.getMoney());
            subWinbidVONew.setContent(subBidVO.getBidContent());
            subWinbidVONew.setWinbidType(Integer.valueOf(0));
            List subBidDetailList = subBidSupplierVO.getSubBidDetailList();
            ArrayList<SubWinbidDetailVO> subWinbidDetailVOList = new ArrayList<SubWinbidDetailVO>();
            for (SubBidDetailVO subBidDetailVO : subBidDetailList) {
                SubWinbidDetailVO subWinbidDetailVO = new SubWinbidDetailVO();
                subWinbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                subWinbidDetailVO.setRule(subBidDetailVO.getRule());
                subWinbidDetailVO.setContent(subBidDetailVO.getContent());
                subWinbidDetailVO.setDetailName(subBidDetailVO.getMaterialName());
                subWinbidDetailVO.setDetailCode(subBidDetailVO.getMaterialCode());
                subWinbidDetailVO.setUnit(subBidDetailVO.getUnit());
                subWinbidDetailVO.setSpec(subBidDetailVO.getSpec());
                subWinbidDetailVO.setBrand(subBidDetailVO.getMaterialBrand());
                subWinbidDetailVO.setSupplierBrand(subBidDetailVO.getBrand());
                subWinbidDetailVO.setPrice(subBidDetailVO.getPrice());
                subWinbidDetailVO.setPriceTax(subBidDetailVO.getPriceTax());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setMoneyTax(subBidDetailVO.getMoneyTax());
                subWinbidDetailVO.setTax(subBidDetailVO.getSellTax());
                subWinbidDetailVO.setCalculateType(subBidDetailVO.getCalculateType());
                subWinbidDetailVO.setMemo(subBidDetailVO.getMaterialMemo());
                subWinbidDetailVO.setSupplierMemo(subBidDetailVO.getMemo());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setRate(subBidDetailVO.getRate());
                subWinbidDetailVO.setTenderNum(subBidDetailVO.getTenderNum());
                subWinbidDetailVO.setNum(subBidDetailVO.getNum());
                subWinbidDetailVOList.add(subWinbidDetailVO);
            }
            subWinbidVONew.setSubWinbidDetailList(subWinbidDetailVOList);
            subWinbidVOList.add(subWinbidVONew);
        }
        String stringFb = JSONObject.toJSONString(subWinbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public SubBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public SubBidVO nextPaper(Long winnoticeId) {
        SubBidEntity entity = new SubBidEntity();
        SubWinnoticeEntity subWinnoticeEntity = (SubWinnoticeEntity)((Object)this.subWinnoticeService.selectById(winnoticeId));
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subWinnoticeEntity.getInviteId()));
        entity.setInviteId(subWinnoticeEntity.getInviteId());
        entity.setBidName(subInviteEntity.getTenderName());
        entity.setPurchaseType(subInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        subWinnoticeEntity.setNextFlag(1);
        this.subWinnoticeService.updateById((Object)subWinnoticeEntity);
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        SubBidVO subBidVO = (SubBidVO)BeanMapper.map((Object)((Object)entity), SubBidVO.class);
        return subBidVO;
    }

    @Override
    public List<SubPicketageSupplierVO> querySupplierList(Long picketageId) {
        SubBidEntity subBidEntity = (SubBidEntity)((Object)super.selectById((Serializable)picketageId));
        SubWinnoticeEntity subWinnoticeEntity = (SubWinnoticeEntity)((Object)this.subWinnoticeService.selectById(subBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(SubPicketageSupplierEntity::getPicketageId, (Object)subWinnoticeEntity.getPicketageId());
        List listSupplier = this.subPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List subPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, SubPicketageSupplierVO.class);
        return subPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public SubPicketageVO insertProcess(Long picketageId) {
        SubPicketageEntity subPicketageEntity = (SubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.subInviteService.updateById((Object)subInviteEntity);
        subPicketageEntity.setBidStatus(1);
        this.subPicketageService.updateById((Object)subPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(subPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(subInviteEntity.getId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        SubPicketageVO subPicketageVO = (SubPicketageVO)BeanMapper.map((Object)((Object)subPicketageEntity), SubPicketageVO.class);
        return subPicketageVO;
    }

    @Override
    public List<SubPicketageSupplierVO> querySupplierDetail(Long id) {
        SubBidEntity subBidEntity = (SubBidEntity)((Object)super.selectById((Serializable)id));
        return this.subPicketageService.querySupplierList(subBidEntity.getPicketageId());
    }
}

