package com.ejianc.business.tender.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.rmat.bean.*;
import com.ejianc.business.tender.rmat.service.*;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSellMapper;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@Service("rmatDocumentSellService")
public class RmatDocumentSellServiceImpl extends BaseServiceImpl<RmatDocumentSellMapper, RmatDocumentSellEntity> implements IRmatDocumentSellService {
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatInviteDetailBidderService bidderService;
    @Autowired
    private IRmatInviteDetailRecordService recordService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatPicketageRefsupplierService rmatPicketageRefsupplierService;


    @Override
    public List<RmatDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<RmatDocumentSellVO> queryListByIds(Long id) {
        RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity = rmatPicketageRefsupplierService.selectById(id);
        List<RmatDocumentSellVO> rmatDocumentSellVOList = new ArrayList<>();
        //流程定标
        if (rmatPicketageRefsupplierEntity.getPicketageFlag()==0){
            RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(rmatPicketageRefsupplierEntity.getPicketageId());
            RmatInviteEntity rmatInviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());
            List<RmatInviteDetailRecordEntity> rmatDetailRecord = rmatInviteEntity.getRmatDetailRecord();
            Map<Long, RmatInviteDetailRecordEntity> rmatInviteDetailEntityMap = rmatDetailRecord.stream().collect(Collectors.toMap(RmatInviteDetailRecordEntity::getMaterialId, Function.identity(),(a,b)->b));
            LambdaQueryWrapper<RmatDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(RmatDocumentSellEntity::getDocumentId,rmatPicketageEntity.getDocumentId());
            listWrapper.eq(RmatDocumentSellEntity::getSupplierId,rmatPicketageRefsupplierEntity.getSupplierId());
            if (rmatPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(RmatDocumentSellEntity::getProjectId,rmatPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(RmatDocumentSellEntity::getTenderFlag,1);
            listWrapper.eq(RmatDocumentSellEntity::getPassFlag,1);
            List<RmatDocumentSellEntity> documentSellList = super.list(listWrapper);
            rmatDocumentSellVOList = BeanMapper.mapList(documentSellList,RmatDocumentSellVO.class);

            for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOList){
                RmatInviteDetailRecordEntity rmatInviteDetailRecordEntity = rmatInviteDetailEntityMap.get(rmatDocumentSellVO.getMaterialId());
                if (rmatInviteDetailRecordEntity != null){
                    rmatDocumentSellVO.setUnitId(rmatInviteDetailRecordEntity.getUnitId());
                }
            }
        }
        //直接定标
        else if (rmatPicketageRefsupplierEntity.getPicketageFlag()==1){
            List<RmatInviteDetailBidderEntity> bidderEntityList = bidderService.list(new QueryWrapper<RmatInviteDetailBidderEntity>().eq("invite_id", rmatPicketageRefsupplierEntity.getPicketageId()).eq("supplier_id",rmatPicketageRefsupplierEntity.getSupplierId()));
            for (RmatInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                RmatDocumentSellVO rmatDocumentSellVO = new RmatDocumentSellVO();
                RmatInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                rmatDocumentSellVO.setId(bidderEntity.getId());
                rmatDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                rmatDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                rmatDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                rmatDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                rmatDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                rmatDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                rmatDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                rmatDocumentSellVO.setUnit(recordEntity.getUnit());
                rmatDocumentSellVO.setUnitId(recordEntity.getUnitId());
                rmatDocumentSellVO.setSpec(recordEntity.getSpec());
                rmatDocumentSellVO.setDetailId(bidderEntity.getId());
                rmatDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                rmatDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                rmatDocumentSellVO.setBrand(bidderEntity.getBrand());
                rmatDocumentSellVO.setPrice(bidderEntity.getPrice());
                rmatDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                rmatDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                rmatDocumentSellVO.setTenderNum(bidderEntity.getNum());
                rmatDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                rmatDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                rmatDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                rmatDocumentSellVO.setPlanEnterDate(recordEntity.getPlanEnterDate());
                rmatDocumentSellVO.setPlanLeaveDate(recordEntity.getPlanLeaveDate());
                rmatDocumentSellVO.setPlanDay(recordEntity.getPlanDay());
                rmatDocumentSellVOList.add(rmatDocumentSellVO);
            }
        }
        return rmatDocumentSellVOList;
    }
}
