package com.ejianc.business.tender.stuff.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkRecordEntity;
import com.ejianc.business.tender.stuff.mapper.StuffTalkRecordMapper;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffTalkRecordService;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.stuff.vo.StuffTalkRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffTalkVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 洽商谈判记录主表
 * 
 * @author generator
 * 
 */
@Service("stuffTalkRecordService")
public class StuffTalkRecordServiceImpl extends BaseServiceImpl<StuffTalkRecordMapper, StuffTalkRecordEntity> implements IStuffTalkRecordService{
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Override
    public StuffTalkRecordVO queryDetail(Long id) {
        StuffTalkRecordEntity stuffTalkRecordEntity = super.selectById(id);
        StuffTalkRecordVO stuffTalkRecordVO = BeanMapper.map(stuffTalkRecordEntity, StuffTalkRecordVO.class);

        //确认轮数
        Integer talkNum = stuffTalkRecordVO.getTalkNum();
        StuffDocumentVO stuffDocumentVO = stuffDocumentService.queryDocDetail(stuffTalkRecordVO.getBillId(), talkNum);
        stuffTalkRecordVO.setStuffDocumentDetailSellList(stuffDocumentVO.getStuffDocumentDetailSellList());
        stuffTalkRecordVO.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getStuffDocumentSupplierSchemeList());

        return stuffTalkRecordVO;
    }
}
