/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.TemplateEntity;
import com.ejianc.business.tender.expert.service.ITemplateService;
import com.ejianc.business.tender.expert.vo.TemplateExportVO;
import com.ejianc.business.tender.expert.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"template"})
public class TemplateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "SCORING_TEMPLATE";
    private static final String TEMPLATE_CODE = "BT211119000000001";
    @Autowired
    private ITemplateService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        TemplateVO vo = this.service.saveUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/startUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> startUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        TemplateEntity entity = (TemplateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TemplateEntity.class));
        CommonResponse res = this.billTypeApi.checkQuote(TEMPLATE_CODE, entity.getId());
        this.logger.info("\u542f\u7528/\u505c\u7528\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "-----" + res.getMsg());
        if (!res.isSuccess()) {
            switch (entity.getState()) {
                case 0: {
                    entity.setState(1);
                    break;
                }
                case 1: {
                    entity.setState(0);
                }
            }
            TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
            return CommonResponse.success((String)"\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff01", (Object)vo);
        }
        this.service.saveOrUpdate((Object)entity, false);
        TemplateVO vo = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemplateVO> queryDetail(Long id) {
        TemplateVO vo = this.service.query(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("templateName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        List list = this.service.queryList(param);
        ArrayList TemplateExportVOS = new ArrayList();
        list.forEach(val -> {
            TemplateExportVO TemplateExportVO2 = (TemplateExportVO)BeanMapper.map((Object)val, TemplateExportVO.class);
            switch (val.getState()) {
                case 0: {
                    TemplateExportVO2.setState("\u505c\u7528");
                    break;
                }
                case 1: {
                    TemplateExportVO2.setState("\u542f\u7528");
                }
            }
            switch (val.getBillState()) {
                case 0: {
                    TemplateExportVO2.setBillState("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    TemplateExportVO2.setBillState("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    TemplateExportVO2.setBillState("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    TemplateExportVO2.setBillState("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    TemplateExportVO2.setBillState("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    TemplateExportVO2.setBillState("\u5ba1\u6279\u4e2d");
                }
            }
            switch (val.getTemplateType()) {
                case 0: {
                    TemplateExportVO2.setTemplateType("\u6750\u6599\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 1: {
                    TemplateExportVO2.setTemplateType("\u52b3\u52a1\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 2: {
                    TemplateExportVO2.setTemplateType("\u4e13\u4e1a\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 3: {
                    TemplateExportVO2.setTemplateType("\u8bbe\u5907\u91c7\u8d2d\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 4: {
                    TemplateExportVO2.setTemplateType("\u8bbe\u5907\u79df\u51ed\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 5: {
                    TemplateExportVO2.setTemplateType("\u5468\u8f6c\u624d\u6750\u79df\u51ed\u8bc4\u6807\u6a21\u677f");
                    break;
                }
                case 6: {
                    TemplateExportVO2.setTemplateType("\u5176\u4ed6\u6a21\u677f");
                }
            }
            TemplateExportVOS.add(TemplateExportVO2);
        });
        HashMap beans = new HashMap();
        beans.put("records", TemplateExportVOS);
        ExcelExport.getInstance().export("template.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTemplateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> refTemplateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("templateName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("templateType") != null) {
            Integer templateType = Integer.valueOf(conditionMap.get("templateType").toString());
            param.getParams().put("templateType", new Parameter("eq", (Object)templateType));
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("state", new Parameter("eq", (Object)1));
        param.getParams().put("billState", new Parameter("in", billStates));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

