/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.ProsubBidDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubBidEntity;
import com.ejianc.business.tender.prosub.bean.ProsubBidSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubNoticeEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageSupplierEntity;
import com.ejianc.business.tender.prosub.bean.ProsubWinnoticeEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubBidMapper;
import com.ejianc.business.tender.prosub.service.IProsubBidDetailService;
import com.ejianc.business.tender.prosub.service.IProsubBidService;
import com.ejianc.business.tender.prosub.service.IProsubBidSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubNoticeService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageSupplierService;
import com.ejianc.business.tender.prosub.service.IProsubWinnoticeService;
import com.ejianc.business.tender.prosub.vo.ProsubBidDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubBidSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubBidVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageSupplierVO;
import com.ejianc.business.tender.prosub.vo.ProsubPicketageVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinbidDetailVO;
import com.ejianc.business.tender.prosub.vo.ProsubWinbidVO;
import com.ejianc.business.tender.sub.vo.SubBidVO;
import com.ejianc.business.tender.sub.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="prosubBidService")
public class ProsubBidServiceImpl
extends BaseServiceImpl<ProsubBidMapper, ProsubBidEntity>
implements IProsubBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubNoticeService subNoticeService;
    @Autowired
    private IProsubWinnoticeService subWinnoticeService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubBidDetailService subBidDetailService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubBidSupplierService subBidSupplierService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public ProsubBidVO saveBid(Long picketageId) {
        ProsubBidEntity entity = new ProsubBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        ProsubInviteEntity inviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        entity.setInviteId(subPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        boolean b = super.saveOrUpdate((Object)entity, false);
        this.logger.info("bidSave" + b);
        ProsubBidVO vo = (ProsubBidVO)BeanMapper.map((Object)((Object)entity), ProsubBidVO.class);
        subPicketageEntity.setBidId(entity.getId());
        this.subPicketageService.updateById((Object)subPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        List subDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, ProsubDocumentSellVO.class);
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().collect(Collectors.groupingBy(ProsubDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplierEntityMap = supplierList.stream().collect(Collectors.toMap(ProsubDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList subBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            ProsubBidSupplierVO subBidSupplierVO = new ProsubBidSupplierVO();
            subBidSupplierVO.setSupplierId(key);
            subBidSupplierVO.setSupplierName(((ProsubDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            ProsubDocumentSupplierEntity subDocumentSupplierEntity = (ProsubDocumentSupplierEntity)((Object)((Object)supplierEntityMap.get(key)));
            subBidSupplierVO.setLinkName(subDocumentSupplierEntity.getLinkName());
            subBidSupplierVO.setSupplierMobile(subDocumentSupplierEntity.getLinkMobile());
            subBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (ProsubDocumentSellVO subDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(subDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : subDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(subDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : subDocumentSellVO.getTenderMoney());
                ProsubBidDetailEntity subBidDetailEntity = (ProsubBidDetailEntity)((Object)((Object)BeanMapper.map((Object)subDocumentSellVO, ProsubBidDetailEntity.class)));
                subBidDetailEntity.setMoney(subDocumentSellVO.getTenderMoney());
                subBidDetailEntity.setMoneyTax(subDocumentSellVO.getTenderMoneyTax());
                subBidDetailEntity.setId(null);
                subBidDetailEntity.setBidSupplierId(subBidSupplierVO.getId());
                subBidDetailEntity.setBidId(entity.getId());
                subBidDetailEntityList.add(subBidDetailEntity);
            }
            subBidSupplierVO.setMoneyTax(tenderMoneyTax);
            subBidSupplierVO.setMoney(tenderMoney);
            subBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(subBidSupplierVO);
        });
        List subBidSupplierEntities = BeanMapper.mapList(supplierVOList, ProsubBidSupplierEntity.class);
        this.subBidSupplierService.saveBatch(subBidSupplierEntities);
        this.subBidDetailService.saveBatch(subBidDetailEntityList);
        String tenderUnitNum = new String();
        List<ProsubBidDetailEntity> bidDetailEntityList = ((ProsubBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (ProsubBidDetailEntity subBidDetailEntity : bidDetailEntityList) {
            ProsubBidSupplierEntity supplierEntity = (ProsubBidSupplierEntity)((Object)this.subBidSupplierService.selectById(subBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = subBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplierEntity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.subInviteService.saveOrUpdate((Object)inviteEntity);
        ProsubBidVO subBidVO = (ProsubBidVO)BeanMapper.map((Object)((Object)entity), ProsubBidVO.class);
        return subBidVO;
    }

    @Override
    public ProsubBidVO queryDetail(Long bidId) {
        ProsubBidEntity subBidEntity = (ProsubBidEntity)((Object)super.selectById((Serializable)bidId));
        ProsubBidVO subBidVO = (ProsubBidVO)BeanMapper.map((Object)((Object)subBidEntity), ProsubBidVO.class);
        List subBidDetailList = subBidVO.getSubBidDetailList();
        Map<Long, List<ProsubBidDetailVO>> detailMap = subBidDetailList.stream().collect(Collectors.groupingBy(ProsubBidDetailVO::getBidSupplierId));
        List subBidSupplierList = subBidVO.getSubBidSupplierList();
        for (ProsubBidSupplierVO subBidSupplierVO : subBidSupplierList) {
            subBidSupplierVO.setSubBidDetailList(detailMap.get(subBidSupplierVO.getId()));
        }
        subBidVO.setSubBidSupplierList(subBidSupplierList);
        return subBidVO;
    }

    @Override
    @Transactional
    public ProsubBidVO publishBid(ProsubBidVO saveorUpdateVO) {
        ProsubBidEntity entity = (ProsubBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        SubBidVO vo = (SubBidVO)BeanMapper.map((Object)((Object)entity), SubBidVO.class);
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(entity.getInviteId()));
        ProsubWinbidVO subWinbidVO = new ProsubWinbidVO();
        subWinbidVO.setSourceId(Long.toString(entity.getInviteId()));
        subWinbidVO.setBillCode(subInviteEntity.getBillCode());
        if (subWinbidVO.getPurchaseType() == null || subWinbidVO.getPurchaseType() == 1) {
            subWinbidVO.setSourceProjectId(null);
        } else {
            subWinbidVO.setSourceProjectId(Long.toString(subInviteEntity.getProjectId()));
        }
        subWinbidVO.setProjectName(subInviteEntity.getProjectName());
        subWinbidVO.setProjectCode(subInviteEntity.getProjectCode());
        subWinbidVO.setSourceOrgId(Long.toString(subInviteEntity.getOrgId()));
        subWinbidVO.setOrgName(subInviteEntity.getOrgName());
        subWinbidVO.setUnitName(subInviteEntity.getUnitName());
        subWinbidVO.setSourceUnitId(Long.toString(subInviteEntity.getUnitId()));
        subWinbidVO.setType("MATERIAL");
        subWinbidVO.setTenderName(subInviteEntity.getTenderName());
        subWinbidVO.setTenderType(subInviteEntity.getTenderType());
        subWinbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(ProsubDocumentEntity::getInviteId, (Object)entity.getInviteId());
        ProsubDocumentEntity subDocumentEntity = (ProsubDocumentEntity)((Object)this.subDocumentService.getOne((Wrapper)lambdaDoc));
        subWinbidVO.setNoticeBidTime(subDocumentEntity.getBidTime());
        subWinbidVO.setNoticeWinbidTime(new Date());
        if (subInviteEntity.getTenderType() == 2 || subInviteEntity.getTenderType() == 3 || subInviteEntity.getTenderType() == 4 || subInviteEntity.getTenderType() == 5) {
            subWinbidVO.setSourceEmployeeId(Long.toString(subDocumentEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(subDocumentEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(subDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(ProsubNoticeEntity::getInviteId, (Object)entity.getInviteId());
            ProsubNoticeEntity noticeEntity = (ProsubNoticeEntity)((Object)this.subNoticeService.getOne((Wrapper)lambdaNotice));
            subWinbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            subWinbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            subWinbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            subWinbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        ProsubBidVO subBidVO = this.queryDetail(entity.getId());
        List subBidSupplierList = subBidVO.getSubBidSupplierList();
        ArrayList<ProsubWinbidVO> subWinbidVOList = new ArrayList<ProsubWinbidVO>();
        for (ProsubBidSupplierVO subBidSupplierVO : subBidSupplierList) {
            ProsubWinbidVO subWinbidVONew = (ProsubWinbidVO)BeanMapper.map((Object)subWinbidVO, ProsubWinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(subBidSupplierVO.getSupplierId()).getData();
            subWinbidVONew.setTenantId(supplierVO.getTenant());
            subWinbidVONew.setWinbidMoneyTax(subBidSupplierVO.getMoneyTax());
            subWinbidVONew.setWinbidMoney(subBidSupplierVO.getMoney());
            subWinbidVONew.setContent(subBidVO.getBidContent());
            subWinbidVONew.setWinbidType(Integer.valueOf(0));
            List subBidDetailList = subBidSupplierVO.getSubBidDetailList();
            ArrayList<ProsubWinbidDetailVO> subWinbidDetailVOList = new ArrayList<ProsubWinbidDetailVO>();
            for (ProsubBidDetailVO subBidDetailVO : subBidDetailList) {
                ProsubWinbidDetailVO subWinbidDetailVO = new ProsubWinbidDetailVO();
                subWinbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                subWinbidDetailVO.setRule(subBidDetailVO.getRule());
                subWinbidDetailVO.setContent(subBidDetailVO.getContent());
                subWinbidDetailVO.setDetailName(subBidDetailVO.getMaterialName());
                subWinbidDetailVO.setDetailCode(subBidDetailVO.getMaterialCode());
                subWinbidDetailVO.setUnit(subBidDetailVO.getUnit());
                subWinbidDetailVO.setSpec(subBidDetailVO.getSpec());
                subWinbidDetailVO.setBrand(subBidDetailVO.getMaterialBrand());
                subWinbidDetailVO.setSupplierBrand(subBidDetailVO.getBrand());
                subWinbidDetailVO.setPrice(subBidDetailVO.getPrice());
                subWinbidDetailVO.setPriceTax(subBidDetailVO.getPriceTax());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setMoneyTax(subBidDetailVO.getMoneyTax());
                subWinbidDetailVO.setTax(subBidDetailVO.getSellTax());
                subWinbidDetailVO.setCalculateType(subBidDetailVO.getCalculateType());
                subWinbidDetailVO.setMemo(subBidDetailVO.getMaterialMemo());
                subWinbidDetailVO.setSupplierMemo(subBidDetailVO.getMemo());
                subWinbidDetailVO.setMoney(subBidDetailVO.getMoney());
                subWinbidDetailVO.setRate(subBidDetailVO.getRate());
                subWinbidDetailVO.setTenderNum(subBidDetailVO.getTenderNum());
                subWinbidDetailVO.setNum(subBidDetailVO.getNum());
                subWinbidDetailVOList.add(subWinbidDetailVO);
            }
            subWinbidVONew.setSubWinbidDetailList(subWinbidDetailVOList);
            subWinbidVOList.add(subWinbidVONew);
        }
        String stringFb = JSONObject.toJSONString(subWinbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public ProsubBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public ProsubBidVO nextPaper(Long winnoticeId) {
        ProsubBidEntity entity = new ProsubBidEntity();
        ProsubWinnoticeEntity subWinnoticeEntity = (ProsubWinnoticeEntity)((Object)this.subWinnoticeService.selectById(winnoticeId));
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subWinnoticeEntity.getInviteId()));
        entity.setInviteId(subWinnoticeEntity.getInviteId());
        entity.setBidName(subInviteEntity.getTenderName());
        entity.setPurchaseType(subInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        subWinnoticeEntity.setNextFlag(1);
        this.subWinnoticeService.updateById((Object)subWinnoticeEntity);
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubBidVO subBidVO = (ProsubBidVO)BeanMapper.map((Object)((Object)entity), ProsubBidVO.class);
        return subBidVO;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierList(Long picketageId) {
        ProsubBidEntity subBidEntity = (ProsubBidEntity)((Object)super.selectById((Serializable)picketageId));
        ProsubWinnoticeEntity subWinnoticeEntity = (ProsubWinnoticeEntity)((Object)this.subWinnoticeService.selectById(subBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(ProsubPicketageSupplierEntity::getPicketageId, (Object)subWinnoticeEntity.getPicketageId());
        List listSupplier = this.subPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List subPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, ProsubPicketageSupplierVO.class);
        return subPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public ProsubPicketageVO insertProcess(Long picketageId) {
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
        subInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.subInviteService.updateById((Object)subInviteEntity);
        subPicketageEntity.setBidStatus(1);
        this.subPicketageService.updateById((Object)subPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(subPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(subInviteEntity.getId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        ProsubPicketageVO subPicketageVO = (ProsubPicketageVO)BeanMapper.map((Object)((Object)subPicketageEntity), ProsubPicketageVO.class);
        return subPicketageVO;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierDetail(Long id) {
        ProsubBidEntity subBidEntity = (ProsubBidEntity)((Object)super.selectById((Serializable)id));
        return this.subPicketageService.querySupplierList(subBidEntity.getPicketageId());
    }
}

