/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubDocumentSellEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailBidderEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailRecordEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageEntity;
import com.ejianc.business.tender.prosub.bean.ProsubPicketageRefsupplierEntity;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSellMapper;
import com.ejianc.business.tender.prosub.service.IProsubDocumentDetailService;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.service.IProsubInviteDetailBidderService;
import com.ejianc.business.tender.prosub.service.IProsubInviteService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageRefsupplierService;
import com.ejianc.business.tender.prosub.service.IProsubPicketageService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailBidderVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierDataVO;
import com.ejianc.business.tender.util.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="prosubDocumentSellService")
public class ProsubDocumentSellServiceImpl
extends BaseServiceImpl<ProsubDocumentSellMapper, ProsubDocumentSellEntity>
implements IProsubDocumentSellService {
    @Autowired
    private IProsubPicketageService subPicketageService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentDetailService subDocumentDetailService;
    @Autowired
    private IProsubInviteDetailBidderService bidderService;
    @Autowired
    private IProsubPicketageRefsupplierService subPicketageRefsupplierService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    List<ProsubDocumentSellVO> sellList = new ArrayList<ProsubDocumentSellVO>();

    @Override
    public List<ProsubDocumentSellEntity> selectMaterialType(Long documentId) {
        return ((ProsubDocumentSellMapper)this.baseMapper).selectMaterialType(documentId);
    }

    @Override
    public List<ProsubDocumentSellVO> queryListByIds(Long projectId, Long supplierId, Long picketageId) {
        ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(picketageId));
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
        listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, (Object)supplierId);
        listWrapper.eq(ProsubDocumentSellEntity::getProjectId, (Object)projectId);
        listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, (Object)1);
        listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, (Object)1);
        List documentSellList = super.list((Wrapper)listWrapper);
        List subDocumentSellVOList = BeanMapper.mapList((Iterable)documentSellList, ProsubDocumentSellVO.class);
        return subDocumentSellVOList;
    }

    @Override
    public List<ProsubDocumentSellVO> queryTreeByIds(Long id) {
        ProsubPicketageRefsupplierEntity subPicketageRefsupplierEntity = (ProsubPicketageRefsupplierEntity)((Object)this.subPicketageRefsupplierService.selectById(id));
        List<ProsubDocumentSellVO> subDocumentSellVOS = new ArrayList();
        if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
            ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId()));
            LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
            listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, (Object)subPicketageRefsupplierEntity.getSupplierId());
            if (subPicketageRefsupplierEntity.getPurchaseType() == 0) {
                listWrapper.eq(ProsubDocumentSellEntity::getProjectId, (Object)subPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, (Object)1);
            listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, (Object)1);
            List documentSellList = super.list((Wrapper)listWrapper);
            List listSell = documentSellList.stream().filter(map -> (map.getSignNum() == null ? BigDecimal.ZERO : map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(listSell)) {
                return null;
            }
            ProsubInviteEntity subInviteEntity = (ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageEntity.getInviteId()));
            List<ProsubInviteDetailRecordEntity> subDetailRecord = subInviteEntity.getSubDetailRecord();
            Integer valueType = subInviteEntity.getValueType();
            List subDocumentSellVOList = BeanMapper.mapList(listSell, ProsubDocumentSellVO.class);
            for (Object subDocumentSellVO : subDocumentSellVOList) {
                subDocumentSellVO.setSurplusNum(subDocumentSellVO.getTenderNum().subtract(subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum()));
            }
            List<ProsubDocumentSellVO> listAll = new ArrayList();
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                ProsubDocumentDetailEntity subDocumentDetailEntity = (ProsubDocumentDetailEntity)((Object)this.subDocumentDetailService.selectById(subDocumentSellVO.getDetailId()));
                Long parentId = subDocumentDetailEntity.getParentId();
                List<ProsubDocumentSellVO> detailByPid = this.getDetailByPid(parentId, subDetailRecord);
                listAll.addAll(detailByPid);
                this.sellList.clear();
                subDocumentSellVO.setSellId(subDocumentSellVO.getId());
                subDocumentSellVO.setParentId(subDocumentDetailEntity.getParentId());
                subDocumentSellVO.setId(subDocumentSellVO.getDetailId());
                listAll.add(subDocumentSellVO);
            }
            listAll = listAll.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProsubDocumentSellVO>(Comparator.comparing(BaseVO::getId))), ArrayList::new));
            if (valueType == 3) {
                for (ProsubDocumentSellVO prosubDocumentSellVO : listAll) {
                    BigDecimal priceTax = prosubDocumentSellVO.getPriceTax();
                    prosubDocumentSellVO.setPriceTax(new BigDecimal(1));
                    if (prosubDocumentSellVO.getPrice() != null) {
                        prosubDocumentSellVO.setPrice(prosubDocumentSellVO.getPrice().divide(priceTax, 8, 4));
                    }
                    if (prosubDocumentSellVO.getMoney() != null) {
                        prosubDocumentSellVO.setMoney(prosubDocumentSellVO.getMoney());
                    }
                    if (prosubDocumentSellVO.getSellTax() != null) {
                        prosubDocumentSellVO.setSellTax(prosubDocumentSellVO.getSellTax());
                    }
                    if (prosubDocumentSellVO.getMoneyTax() != null) {
                        prosubDocumentSellVO.setMoneyTax(prosubDocumentSellVO.getMoneyTax());
                    }
                    if (prosubDocumentSellVO.getTenderNum() != null) {
                        prosubDocumentSellVO.setTenderNum(priceTax);
                    }
                    if (prosubDocumentSellVO.getTenderMoney() != null) {
                        prosubDocumentSellVO.setTenderMoney(prosubDocumentSellVO.getTenderMoney());
                    }
                    if (prosubDocumentSellVO.getTenderMoneyTax() != null) {
                        prosubDocumentSellVO.setTenderMoneyTax(prosubDocumentSellVO.getTenderMoneyTax());
                    }
                    if (prosubDocumentSellVO.getInvitePrice() != null) {
                        prosubDocumentSellVO.setInvitePrice(prosubDocumentSellVO.getInvitePrice().divide(priceTax, 8, 4));
                    }
                    if (prosubDocumentSellVO.getInvitePriceTax() != null) {
                        prosubDocumentSellVO.setInvitePriceTax(prosubDocumentSellVO.getInvitePriceTax().divide(priceTax, 8, 4));
                    }
                    if (prosubDocumentSellVO.getPriceTax() == null) continue;
                    prosubDocumentSellVO.setSurplusNum(priceTax.subtract(prosubDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : prosubDocumentSellVO.getSignNum()));
                }
            }
            List sellList = listAll.stream().collect(Collectors.toList());
            subDocumentSellVOS = TreeNodeBUtil.buildTree(sellList);
        } else {
            List<ProsubInviteDetailBidderEntity> bidderEntityList1 = ((ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()))).getSubDetailBidder();
            List bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum() != null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (ProsubInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                if (bidderEntity.getNum() != null) continue;
                bidderEntityList.add(bidderEntity);
            }
            List subDetailBidder = BeanMapper.mapList(bidderEntityList, ProsubInviteDetailBidderVO.class);
            for (ProsubInviteDetailBidderVO bidderVO : subDetailBidder) {
                ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
                subDocumentSellVO.setId(bidderVO.getId());
                subDocumentSellVO.setSellId(bidderVO.getId());
                subDocumentSellVO.setTreeIndex(bidderVO.getTreeIndex());
                subDocumentSellVO.setParentId(bidderVO.getParentId());
                subDocumentSellVO.setChildren(bidderVO.getChildren());
                subDocumentSellVO.setContent(bidderVO.getContent());
                subDocumentSellVO.setRule(bidderVO.getRule());
                subDocumentSellVO.setMaterialId(bidderVO.getDocId());
                subDocumentSellVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                subDocumentSellVO.setMaterialCode(bidderVO.getDetailCode());
                subDocumentSellVO.setMaterialName(bidderVO.getDetailName());
                subDocumentSellVO.setUnit(bidderVO.getUnit());
                subDocumentSellVO.setTenderNum(bidderVO.getNum());
                subDocumentSellVO.setRate(bidderVO.getTaxRate());
                subDocumentSellVO.setMemo(bidderVO.getMemo());
                subDocumentSellVO.setPrice(bidderVO.getPrice());
                subDocumentSellVO.setPriceTax(bidderVO.getTaxPrice());
                subDocumentSellVO.setTenderMoney(bidderVO.getMny());
                subDocumentSellVO.setTenderMoneyTax(bidderVO.getTaxMny());
                subDocumentSellVO.setSellTax(bidderVO.getTax());
                if (bidderVO.getNum() != null) {
                    subDocumentSellVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                    subDocumentSellVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                }
                subDocumentSellVOS.add(subDocumentSellVO);
            }
            subDocumentSellVOS = TreeNodeBUtil.buildTree(subDocumentSellVOS);
        }
        return subDocumentSellVOS;
    }

    @Override
    public List<ProsubSupplierDataVO> queryTreeList(Long id) {
        ProsubPicketageRefsupplierEntity subPicketageRefsupplierEntity = (ProsubPicketageRefsupplierEntity)((Object)this.subPicketageRefsupplierService.selectById(id));
        List<Object> subSupplierDataVOS = new ArrayList<ProsubSupplierDataVO>();
        if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
            ProsubPicketageEntity subPicketageEntity = (ProsubPicketageEntity)((Object)this.subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId()));
            LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(ProsubDocumentSellEntity::getDocumentId, (Object)subPicketageEntity.getDocumentId());
            listWrapper.eq(ProsubDocumentSellEntity::getSupplierId, (Object)subPicketageRefsupplierEntity.getSupplierId());
            if (subPicketageRefsupplierEntity.getPurchaseType() == 0) {
                listWrapper.eq(ProsubDocumentSellEntity::getProjectId, (Object)subPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(ProsubDocumentSellEntity::getTenderFlag, (Object)1);
            listWrapper.eq(ProsubDocumentSellEntity::getPassFlag, (Object)1);
            List documentSellList = super.list((Wrapper)listWrapper);
            this.logger.info("\u6d41\u7a0b\u5b9a\u6807\u6570\u636e{}", (Object)JSONObject.toJSONString((Object)documentSellList));
            List listSell = documentSellList.stream().filter(map -> (map.getSignNum() == null ? BigDecimal.ZERO : map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(listSell)) {
                return null;
            }
            subSupplierDataVOS = BeanMapper.mapList(listSell, ProsubSupplierDataVO.class);
            for (ProsubSupplierDataVO prosubSupplierDataVO : subSupplierDataVOS) {
                prosubSupplierDataVO.setSellId(prosubSupplierDataVO.getId());
                prosubSupplierDataVO.setSurplusNum(prosubSupplierDataVO.getTenderNum().subtract(prosubSupplierDataVO.getSignNum() == null ? BigDecimal.ZERO : prosubSupplierDataVO.getSignNum()));
            }
        } else {
            List<ProsubInviteDetailBidderEntity> bidderEntityList1 = ((ProsubInviteEntity)((Object)this.subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()))).getSubDetailBidder();
            List bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum() != null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            List subDetailBidder = BeanMapper.mapList(bidderEntityList, ProsubInviteDetailBidderVO.class);
            for (ProsubInviteDetailBidderVO bidderVO : subDetailBidder) {
                ProsubSupplierDataVO prosubSupplierDataVO = new ProsubSupplierDataVO();
                prosubSupplierDataVO.setId(bidderVO.getId());
                prosubSupplierDataVO.setSellId(bidderVO.getId());
                prosubSupplierDataVO.setTreeIndex(bidderVO.getTreeIndex());
                prosubSupplierDataVO.setParentId(bidderVO.getParentId());
                prosubSupplierDataVO.setContent(bidderVO.getContent());
                prosubSupplierDataVO.setRule(bidderVO.getRule());
                prosubSupplierDataVO.setMaterialId(bidderVO.getDocId());
                prosubSupplierDataVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                prosubSupplierDataVO.setMaterialCode(bidderVO.getDetailCode());
                prosubSupplierDataVO.setMaterialName(bidderVO.getDetailName());
                prosubSupplierDataVO.setUnit(bidderVO.getUnit());
                prosubSupplierDataVO.setTenderNum(bidderVO.getNum());
                prosubSupplierDataVO.setRate(bidderVO.getTaxRate());
                prosubSupplierDataVO.setMemo(bidderVO.getMemo());
                prosubSupplierDataVO.setPrice(bidderVO.getPrice());
                prosubSupplierDataVO.setPriceTax(bidderVO.getTaxPrice());
                prosubSupplierDataVO.setTenderMoney(bidderVO.getMny());
                prosubSupplierDataVO.setTenderMoneyTax(bidderVO.getTaxMny());
                prosubSupplierDataVO.setSellTax(bidderVO.getTax());
                if (bidderVO.getNum() != null) {
                    prosubSupplierDataVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                    prosubSupplierDataVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                }
                subSupplierDataVOS.add(prosubSupplierDataVO);
            }
        }
        return subSupplierDataVOS;
    }

    private List<ProsubDocumentSellVO> getDetailByPid(Long id, List<ProsubInviteDetailRecordEntity> list) {
        for (ProsubInviteDetailRecordEntity recordEntity : list) {
            if (id == null || !id.equals(recordEntity.getId())) continue;
            id = recordEntity.getParentId();
            this.getDetailByPid(id, list);
            ProsubDocumentSellVO subDocumentSellVO = new ProsubDocumentSellVO();
            subDocumentSellVO.setMaterialCode(recordEntity.getDetailCode());
            subDocumentSellVO.setMaterialName(recordEntity.getDetailName());
            subDocumentSellVO.setRule(recordEntity.getRule());
            subDocumentSellVO.setContent(recordEntity.getContent());
            subDocumentSellVO.setUnit(recordEntity.getUnit());
            subDocumentSellVO.setParentId(recordEntity.getParentId());
            subDocumentSellVO.setId(recordEntity.getId());
            subDocumentSellVO.setTreeIndex(recordEntity.getTreeIndex());
            subDocumentSellVO.setMemo(recordEntity.getMemo());
            subDocumentSellVO.setMaterialId(recordEntity.getDocId());
            subDocumentSellVO.setMaterialTypeId(recordEntity.getDocCategoryId());
            this.sellList.add(subDocumentSellVO);
        }
        return this.sellList;
    }
}

