/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatDocumentDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentExpertEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSchemeEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSellEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeEntity;
import com.ejianc.business.tender.rmat.bean.RmatNoticeSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkEntity;
import com.ejianc.business.tender.rmat.bean.RmatTalkRecordEntity;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSellMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSupplierDetailMapper;
import com.ejianc.business.tender.rmat.mapper.RmatDocumentSupplierMapper;
import com.ejianc.business.tender.rmat.service.IRmatDocumentDetailService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentExpertService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentRecordService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSchemeService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSellService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierDetailService;
import com.ejianc.business.tender.rmat.service.IRmatDocumentSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeService;
import com.ejianc.business.tender.rmat.service.IRmatNoticeSupplierService;
import com.ejianc.business.tender.rmat.service.IRmatTalkRecordService;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.business.tender.rmat.vo.RmatDocumentDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSchemeVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierSellVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierTbVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatDocumentVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeDetailTbVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierTbVO;
import com.ejianc.business.tender.rmat.vo.RmatNoticeSupplierVO;
import com.ejianc.business.tender.rmat.vo.RmatSupplierSellSchemeDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatSupplierSellSchemeVO;
import com.ejianc.business.tender.rmat.vo.RmatSupplierSellVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkVO;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Service(value="rmatDocumentService")
public class RmatDocumentServiceImpl
extends BaseServiceImpl<RmatDocumentMapper, RmatDocumentEntity>
implements IRmatDocumentService {
    @Autowired
    private IRmatDocumentSupplierService rmatDocumentSupplierService;
    @Autowired
    private RmatDocumentSupplierDetailMapper supplierDetailMapper;
    @Autowired
    private RmatDocumentSupplierMapper supplierMapper;
    @Autowired
    private IRmatDocumentSchemeService rmatDocumentSchemeService;
    @Autowired
    private IRmatDocumentSellService rmatDocumentSellService;
    @Autowired
    private RmatDocumentSellMapper rmatDocumentSellMapper;
    @Autowired
    private IRmatDocumentRecordService rmatDocumentRecordService;
    @Autowired
    private IRmatDocumentDetailService rmatDocumentDetailService;
    @Autowired
    private IRmatTalkService rmatTalkService;
    @Autowired
    private IRmatTalkRecordService rmatTalkRecordService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    @Autowired
    private IRmatDocumentExpertService documentExpertService;
    @Autowired
    private IRmatDocumentSupplierDetailService supplierDetailService;
    @Autowired
    private IRmatDocumentSupplierDetailService documentSupplierDetailService;
    @Autowired
    private IRmatDocumentService service;
    @Autowired
    private IProcessService processService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRmatNoticeService rmatNoticeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Value(value="${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000005";
    private static final String BILL_TYPE = "BT211119000000003";
    private static final String SOURCE_TYPE = "documentBill02";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRmatNoticeSupplierService rmatNoticeSupplierService;

    @Override
    @Transactional
    public RmatDocumentVO publishDocument(Long id) {
        CommonResponse stringCommonResponses;
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)id));
        rmatDocumentEntity.setPublishFlag(0);
        super.updateById((Object)rmatDocumentEntity);
        RmatDocumentSupplierTbVO rmatDocumentSupplierTbVO = new RmatDocumentSupplierTbVO();
        rmatDocumentSupplierTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
        rmatDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        rmatDocumentSupplierTbVO.setNoticeType(Integer.valueOf(1));
        rmatDocumentSupplierTbVO.setProjectLinkName(rmatDocumentEntity.getProjectLinkName());
        rmatDocumentSupplierTbVO.setProjectLinkPhone(rmatDocumentEntity.getProjectLinkPhone());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(rmatDocumentEntity.getOfferStartTime());
        rmatDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(rmatDocumentEntity.getOfferEndTime());
        rmatDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        rmatDocumentSupplierTbVO.setContent(rmatDocumentEntity.getDocumentContent());
        rmatDocumentSupplierTbVO.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        rmatDocumentSupplierTbVO.setMemo(rmatDocumentEntity.getMemo());
        rmatDocumentSupplierTbVO.setTenderName(rmatDocumentEntity.getDocumentName());
        CommonResponse stringCommonResponse = this.proSupplierApi.getEjcCloudSystemCode();
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u83b7\u53d6systemId\u5931\u8d25" + stringCommonResponse.getMsg());
        }
        rmatDocumentSupplierTbVO.setSystemId((String)stringCommonResponse.getData());
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        rmatDocumentSupplierTbVO.setRentType(rmatInviteEntity.getRentType());
        CommonResponse zbwjFile = this.attachmentApi.queryListBySourceId(rmatDocumentEntity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        String zbwjIds = null;
        List<Object> zbwjAttachIdList = new ArrayList();
        if (zbwjFile.isSuccess()) {
            List data = (List)zbwjFile.getData();
            zbwjAttachIdList = data.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            zbwjIds = zbwjAttachIdList.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(","));
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", zbwjIds);
        String zbwjFileByte = null;
        try {
            zbwjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonZbwj = JSON.parseObject(zbwjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonZbwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String dataZbwj = (String)zbwjParam.get("data");
        JSONObject zbwListJson = JSON.parseObject((String)dataZbwj);
        Map zbwjMap = (Map)JSONObject.parseObject((String)zbwListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        zbwjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        String stringFb = JSONObject.toJSONString((Object)rmatDocumentSupplierTbVO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("noticeEntity", stringFb);
        HashMap files = null;
        if (!streamMap.isEmpty()) {
            files = new HashMap();
            files.put("file", streamMap);
        }
        if (!(stringCommonResponses = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.saveWjUrl, params, files, this.appId, this.appSecret, this.appHost)).isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponses.getMsg());
        }
        RmatDocumentVO rmatDocumentVO = this.queryDetail(id);
        return rmatDocumentVO;
    }

    @Override
    public RmatDocumentVO bidDocument(Long id) {
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)id));
        rmatDocumentEntity.setBidFlag(0);
        rmatDocumentEntity.setBidTime(new Date());
        super.updateById((Object)rmatDocumentEntity);
        RmatDocumentVO rmatDocumentVO = this.queryDetail(id);
        List entityList = this.documentExpertService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)rmatDocumentVO.getId())).eq((Object)"dr", (Object)0));
        for (RmatDocumentExpertEntity entity : entityList) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(entity.getExpertId() + "");
            String name = rmatDocumentVO.getPurchaseType() == 0 ? rmatDocumentVO.getProjectName() : rmatDocumentVO.getOrgName();
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
            String subject = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            String content = entity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u5df2\u5f00\u6807\uff0c\u540e\u7eed\u7684\u8bc4\u6807\u5f00\u59cb\u65f6\u95f4\u6211\u4eec\u4f1a\u4ee5\u77ed\u4fe1+\u6d88\u606f\u7684\u5f62\u5f0f\u901a\u77e5\u60a8\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff0c\u907f\u514d\u9057\u5fd8";
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        }
        return rmatDocumentVO;
    }

    @Override
    public RmatDocumentVO queryDetail(Long id) {
        return this.queryDocDetail(id, 0);
    }

    @Override
    public RmatDocumentVO queryDetail1(Long id, Integer num) {
        return this.queryDocDetail(id, num);
    }

    @Override
    public RmatDocumentVO queryDetailNum(Long id) {
        RmatDocumentSchemeEntity rmatDocumentSchemeEntity = (RmatDocumentSchemeEntity)((Object)this.rmatDocumentSchemeService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)id)).orderByDesc((Object)"talk_num")).get(0));
        return this.queryDocDetail(id, rmatDocumentSchemeEntity.getTalkNum());
    }

    @Override
    @Transactional
    public Boolean supplierPushSell(HttpServletRequest request, MultipartFile file) {
        this.logger.info("\u8fdb\u5165\u62a5\u4ef7\u63a5\u53e3request-{},file-{}", (Object)request, (Object)file);
        String notice = request.getParameter("bjNoticeVO");
        this.logger.info("\u5b9e\u4f53\u4fe1\u606f-{}", (Object)notice);
        RmatSupplierSellVO pushVO = (RmatSupplierSellVO)JSON.parseObject((String)notice, (TypeReference)new TypeReference<RmatSupplierSellVO>(){}, (Feature[])new Feature[0]);
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(Long.valueOf(Long.parseLong(pushVO.getSourceId()))));
        Integer tenderStage = rmatInviteEntity.getTenderStage();
        Integer talkNum = null;
        if (tenderStage == 3 || tenderStage == 6 || tenderStage == 8 || tenderStage == 9 || tenderStage == 10) {
            talkNum = 0;
        }
        if (tenderStage == 7) {
            LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
            lambdaTalk.eq(RmatTalkEntity::getInviteId, (Object)Long.parseLong(pushVO.getSourceId()));
            RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)this.rmatTalkService.getOne((Wrapper)lambdaTalk));
            talkNum = rmatTalkEntity.getTalkNum();
        }
        long sourceSupplierId = Long.parseLong(pushVO.getSourceSupplierId());
        SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(Long.valueOf(sourceSupplierId)).getData();
        Long inviteId = Long.parseLong(pushVO.getSourceId());
        LambdaQueryWrapper lambdaDocument = Wrappers.lambdaQuery();
        lambdaDocument.eq(RmatDocumentEntity::getInviteId, (Object)inviteId);
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)((RmatDocumentMapper)this.baseMapper).selectOne((Wrapper)lambdaDocument));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)rmatDocumentEntity.getId());
        lambdaSupplier.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)this.rmatDocumentSupplierService.getOne((Wrapper)lambdaSupplier));
        Long documentSupplierId = null;
        if (rmatDocumentSupplierEntity != null) {
            rmatDocumentSupplierEntity.setOfferTime(new Date());
            rmatDocumentSupplierEntity.setLinkName(pushVO.getEmployeeName());
            rmatDocumentSupplierEntity.setLinkMobile(pushVO.getEmployeeMobile());
            rmatDocumentSupplierEntity.setTaxMemo(pushVO.getInvoiceNote());
            this.rmatDocumentSupplierService.updateById((Object)rmatDocumentSupplierEntity);
            documentSupplierId = rmatDocumentSupplierEntity.getId();
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId, (Object)rmatDocumentSupplierEntity.getId());
            this.rmatDocumentSchemeService.remove((Wrapper)lambdaScheme);
        }
        if (rmatDocumentSupplierEntity == null) {
            RmatDocumentSupplierEntity rmatDocumentSupplierEntityAdd = new RmatDocumentSupplierEntity();
            rmatDocumentSupplierEntityAdd.setSupplierName(supplierVO.getName());
            rmatDocumentSupplierEntityAdd.setSupplierId(sourceSupplierId);
            rmatDocumentSupplierEntityAdd.setSupplierTenantId(supplierVO.getTenant());
            rmatDocumentSupplierEntityAdd.setLinkName(pushVO.getEmployeeName());
            rmatDocumentSupplierEntityAdd.setLinkMobile(pushVO.getEmployeeMobile());
            rmatDocumentSupplierEntityAdd.setTaxMemo(pushVO.getInvoiceNote());
            rmatDocumentSupplierEntityAdd.setOfferTime(new Date());
            rmatDocumentSupplierEntityAdd.setDocumentId(rmatDocumentEntity.getId());
            rmatDocumentSupplierEntityAdd.setTalkNum(talkNum);
            this.rmatDocumentSupplierService.save((Object)rmatDocumentSupplierEntityAdd);
            documentSupplierId = rmatDocumentSupplierEntityAdd.getId();
        }
        List schemeList = pushVO.getRmatSchemeList();
        ArrayList<RmatDocumentSchemeEntity> rmatDocumentSchemeEntityArrayList = new ArrayList<RmatDocumentSchemeEntity>();
        ArrayList<RmatDocumentSellVO> rmatDocumentSellVOList = new ArrayList<RmatDocumentSellVO>();
        for (RmatSupplierSellSchemeVO supplierSellSchemeVO : schemeList) {
            RmatDocumentSchemeEntity rmatDocumentSchemeEntity = new RmatDocumentSchemeEntity();
            rmatDocumentSchemeEntity.setDocumentSupplierId(documentSupplierId);
            rmatDocumentSchemeEntity.setDocumentId(rmatDocumentEntity.getId());
            rmatDocumentSchemeEntity.setSupplierId(sourceSupplierId);
            rmatDocumentSchemeEntity.setSupplierTenantId(supplierVO.getTenant());
            rmatDocumentSchemeEntity.setSupplierName(supplierVO.getName());
            rmatDocumentSchemeEntity.setSchemeName(supplierSellSchemeVO.getSchemeName());
            rmatDocumentSchemeEntity.setMoney(supplierSellSchemeVO.getMoney());
            rmatDocumentSchemeEntity.setMoneyTax(supplierSellSchemeVO.getMoneyTax());
            rmatDocumentSchemeEntity.setTalkNum(talkNum);
            rmatDocumentSchemeEntity.setId(IdWorker.getId());
            rmatDocumentSchemeEntity.setPassFlag(1);
            rmatDocumentSchemeEntityArrayList.add(rmatDocumentSchemeEntity);
            List schemeDetailList = supplierSellSchemeVO.getRmatSchemeDetailList();
            for (RmatSupplierSellSchemeDetailVO supplierSellSchemeDetailVO : schemeDetailList) {
                RmatDocumentSellVO rmatDocumentSellVO = new RmatDocumentSellVO();
                rmatDocumentSellVO.setSchemeId(rmatDocumentSchemeEntity.getId());
                rmatDocumentSellVO.setDocumentId(rmatDocumentEntity.getId());
                rmatDocumentSellVO.setSupplierId(Long.valueOf(sourceSupplierId));
                rmatDocumentSellVO.setSupplierTenantId(supplierVO.getTenant());
                rmatDocumentSellVO.setSupplierName(supplierVO.getName());
                rmatDocumentSellVO.setMaterialId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialId())));
                rmatDocumentSellVO.setMaterialName(supplierSellSchemeDetailVO.getMaterialName());
                rmatDocumentSellVO.setMaterialCode(supplierSellSchemeDetailVO.getMaterialCode());
                rmatDocumentSellVO.setMaterialTypeId(Long.valueOf(Long.parseLong(supplierSellSchemeDetailVO.getSourceMaterialTypeId())));
                rmatDocumentSellVO.setMaterialTypeName(supplierSellSchemeDetailVO.getMaterialTypeName());
                rmatDocumentSellVO.setUnit(supplierSellSchemeDetailVO.getUnit());
                rmatDocumentSellVO.setSpec(supplierSellSchemeDetailVO.getSpec());
                rmatDocumentSellVO.setRate(supplierSellSchemeDetailVO.getRate());
                rmatDocumentSellVO.setDetailRate(supplierSellSchemeDetailVO.getDetailRate());
                rmatDocumentSellVO.setPrice(supplierSellSchemeDetailVO.getPrice());
                rmatDocumentSellVO.setPriceTax(supplierSellSchemeDetailVO.getPriceTax());
                rmatDocumentSellVO.setSchemeName(supplierSellSchemeVO.getSchemeName());
                rmatDocumentSellVO.setMaterialBrand(supplierSellSchemeDetailVO.getBrand());
                rmatDocumentSellVO.setBrand(supplierSellSchemeDetailVO.getSupplierBrand());
                rmatDocumentSellVO.setMemo(supplierSellSchemeDetailVO.getSupplierMemo());
                rmatDocumentSellVO.setMaterialMemo(supplierSellSchemeDetailVO.getMemo());
                rmatDocumentSellVO.setCalculateType(supplierSellSchemeDetailVO.getCalculateType());
                rmatDocumentSellVO.setPlanDay(supplierSellSchemeDetailVO.getPlanDay());
                rmatDocumentSellVO.setPlanEnterDate(supplierSellSchemeDetailVO.getPlanEnterDate());
                rmatDocumentSellVO.setPlanLeaveDate(supplierSellSchemeDetailVO.getPlanLeaveDate());
                rmatDocumentSellVO.setReferFlag(Integer.valueOf(2));
                rmatDocumentSellVO.setPassFlag(Integer.valueOf(1));
                rmatDocumentSellVO.setTalkNum(talkNum);
                rmatDocumentSellVOList.add(rmatDocumentSellVO);
            }
        }
        this.rmatDocumentSchemeService.saveBatch(rmatDocumentSchemeEntityArrayList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getSupplierId, (Object)sourceSupplierId);
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, (Object)talkNum);
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatDocumentEntity.getId());
        this.rmatDocumentSellService.remove((Wrapper)lambdaSell);
        LambdaQueryWrapper lambdaDetail = Wrappers.lambdaQuery();
        lambdaDetail.eq(RmatDocumentDetailEntity::getDocumentId, (Object)rmatDocumentEntity.getId());
        List rmatDocumentDetailList = this.rmatDocumentDetailService.list((Wrapper)lambdaDetail);
        ArrayList<RmatDocumentSellEntity> rmatDocumentSellEntityArrayList = new ArrayList<RmatDocumentSellEntity>();
        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList) {
            for (RmatDocumentSellVO rmatDocumentSellVO : rmatDocumentSellVOList) {
                RmatDocumentSellEntity rmatDocumentSellEntity;
                if (rmatDocumentDetailEntity.getMaterialId() != null && rmatDocumentDetailEntity.getMaterialTypeId().equals(rmatDocumentSellVO.getMaterialTypeId()) && rmatDocumentDetailEntity.getMaterialId().equals(rmatDocumentSellVO.getMaterialId()) && rmatDocumentDetailEntity.getRate().equals(rmatDocumentSellVO.getDetailRate()) && (rmatDocumentDetailEntity.getPlanEnterDate() == null ? "1" : rmatDocumentDetailEntity.getPlanEnterDate()).equals(rmatDocumentSellVO.getPlanEnterDate() == null ? "1" : rmatDocumentSellVO.getPlanEnterDate()) && (rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rmatDocumentDetailEntity.getPlanLeaveDate()).equals(rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rmatDocumentDetailEntity.getPlanLeaveDate())) {
                    rmatDocumentSellEntity = (RmatDocumentSellEntity)((Object)BeanMapper.map((Object)rmatDocumentSellVO, RmatDocumentSellEntity.class));
                    rmatDocumentSellEntity.setDetailId(rmatDocumentDetailEntity.getId());
                    rmatDocumentSellEntity.setProjectId(rmatDocumentDetailEntity.getDetailProjectId());
                    rmatDocumentSellEntity.setProjectName(rmatDocumentDetailEntity.getDetailProjectName());
                    rmatDocumentSellEntity.setNum(rmatDocumentDetailEntity.getNum());
                    rmatDocumentSellEntity.setMoney(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPrice()));
                    rmatDocumentSellEntity.setMoneyTax(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPriceTax()));
                    rmatDocumentSellEntity.setSellTax(rmatDocumentSellEntity.getMoneyTax().subtract(rmatDocumentSellEntity.getMoney()));
                    rmatDocumentSellEntityArrayList.add(rmatDocumentSellEntity);
                }
                if (rmatDocumentDetailEntity.getMaterialId() != null || !rmatDocumentDetailEntity.getMaterialTypeId().equals(rmatDocumentSellVO.getMaterialTypeId()) || !rmatDocumentDetailEntity.getRate().equals(rmatDocumentSellVO.getDetailRate()) || !(rmatDocumentDetailEntity.getPlanEnterDate() == null ? "1" : rmatDocumentDetailEntity.getPlanEnterDate()).equals(rmatDocumentSellVO.getPlanEnterDate() == null ? "1" : rmatDocumentSellVO.getPlanEnterDate()) || !(rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rmatDocumentDetailEntity.getPlanLeaveDate()).equals(rmatDocumentDetailEntity.getPlanLeaveDate() == null ? "1" : rmatDocumentDetailEntity.getPlanLeaveDate())) continue;
                rmatDocumentSellEntity = (RmatDocumentSellEntity)((Object)BeanMapper.map((Object)rmatDocumentSellVO, RmatDocumentSellEntity.class));
                rmatDocumentSellEntity.setDetailId(rmatDocumentDetailEntity.getId());
                rmatDocumentSellEntity.setProjectId(rmatDocumentDetailEntity.getDetailProjectId());
                rmatDocumentSellEntity.setProjectName(rmatDocumentDetailEntity.getDetailProjectName());
                rmatDocumentSellEntity.setNum(rmatDocumentDetailEntity.getNum());
                rmatDocumentSellEntity.setMoney(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPrice()));
                rmatDocumentSellEntity.setMoneyTax(rmatDocumentDetailEntity.getNum().multiply(rmatDocumentSellEntity.getPriceTax()));
                rmatDocumentSellEntity.setSellTax(rmatDocumentSellEntity.getMoneyTax().subtract(rmatDocumentSellEntity.getMoney()));
                rmatDocumentSellEntityArrayList.add(rmatDocumentSellEntity);
            }
        }
        this.rmatDocumentSellService.saveBatch(rmatDocumentSellEntityArrayList);
        if (documentSupplierId != null) {
            this.logger.info("\u5220\u9664\u4f9b\u5e94\u5546[{}]\u9644\u4ef6\u4fe1\u606f\uff0cbillType[{}]\uff0csourceType[supplierFileType]", (Object)documentSupplierId, (Object)BILL_SUPPLIER_TYPE);
            CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(documentSupplierId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
            List attachmentVOList = (List)attachmentResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                this.logger.info("\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u4fe1\u606f-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse deleteResponse = this.attachmentApi.delete(ids);
                this.logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", deleteResponse.getData());
            }
        }
        List pzList = pushVO.getSupplyFileList();
        this.logger.info("\u62a5\u540d\u6587\u4ef6:{}", (Object)JSONObject.toJSONString((Object)pzList));
        if (CollectionUtils.isNotEmpty((Collection)pzList)) {
            ArrayList<AttachmentVO> list = new ArrayList<AttachmentVO>();
            for (SupplyFileVo e : pzList) {
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType(BILL_SUPPLIER_TYPE);
                attachmentVO.setSourceId(documentSupplierId);
                attachmentVO.setSourceType("supplierFileType");
                attachmentVO.setFilePath(e.getFilePath());
                attachmentVO.setOnlinePath(e.getFilePath());
                attachmentVO.setFileName(e.getFileName());
                attachmentVO.setId(e.getFileId());
                list.add(attachmentVO);
                this.logger.info("\u4fdd\u5b58\u6587\u4ef6\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            }
            CommonResponse stringCommonResponse = this.attachmentApi.insertBatch(list);
            this.logger.info(request + "\u62a5\u540d\u6587\u4ef6\u4e0a\u4f20\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
        }
        return true;
    }

    @Override
    public String uploadById(Long attachId, Long inviteId) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("fileIds", Long.toString(attachId));
        String wjFileByte = null;
        try {
            wjFileByte = ReferHttpClientUtils.getAndHeader((String)(this.BASE_HOST + "ejc-file-web/attachment/batchdownflow"), fileMap);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject jsonwj = JSON.parseObject(wjFileByte);
        Map zbwjParam = (Map)JSONObject.parseObject((String)jsonwj.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String datawj = (String)zbwjParam.get("data");
        JSONObject wListJson = JSON.parseObject((String)datawj);
        Map wjMap = (Map)JSONObject.parseObject((String)wListJson.toJSONString(), (TypeReference)new TypeReference<Map<String, byte[]>>(){}, (Feature[])new Feature[0]);
        HashMap streamMap = new HashMap();
        wjMap.forEach((key, value) -> streamMap.put(key, new ByteArrayInputStream((byte[])value)));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourceId", Long.toString(inviteId));
        HashMap headers = new HashMap();
        HashMap files = new HashMap();
        files.put("file", streamMap);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.addFileUrl, params, files, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u4ef6\u6279\u91cf\u4fee\u6539\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return null;
    }

    @Override
    public String deleteFileById(Long sourceId, List<String> fileNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceId", sourceId);
        map.put("fileNames", fileNames);
        String stringInfo = JSONObject.toJSONString(map);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.delFileUrl, RequestMethod.POST, stringInfo, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u9644\u52a0\u6279\u91cf\u5220\u9664\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return "\u540c\u6b65\u6210\u529f";
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId) {
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)documentId));
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSchemeEntity rmatDocumentSchemeEntity = (RmatDocumentSchemeEntity)((Object)this.rmatDocumentSchemeService.selectById(schemeId));
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)this.rmatDocumentSupplierService.selectById(rmatDocumentSchemeEntity.getDocumentSupplierId()));
        Long supplierDetailId = rmatDocumentSupplierEntity.getId();
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rmatDocumentSchemeEntityList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rmatDocumentSchemeVOList = BeanMapper.mapList((Iterable)rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatDocumentSupplierEntity.getDocumentId());
        List rmatDocumentSellEntityList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOList = BeanMapper.mapList((Iterable)rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList) {
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rmatDocumentSupplierSellVO;
    }

    @Override
    public RmatDocumentVO saveOrUpdates(RmatDocumentVO saveorUpdateVO) {
        RmatDocumentEntity entity = (RmatDocumentEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RmatDocumentEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        RmatDocumentVO vo = (RmatDocumentVO)BeanMapper.map((Object)((Object)entity), RmatDocumentVO.class);
        RmatInviteEntity subInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(entity.getInviteId()));
        List subInviteDetailRecordVOS = BeanMapper.mapList(subInviteEntity.getRmatDetailRecord(), RmatInviteDetailRecordVO.class);
        vo.setRmatDetailRecord(subInviteDetailRecordVOS);
        return vo;
    }

    @Override
    public RmatDocumentVO queryDocDetail(Long id, Integer talkNum) {
        RmatDocumentEntity entity = (RmatDocumentEntity)((Object)super.selectById((Serializable)id));
        RmatDocumentVO rmatDocumentVO = (RmatDocumentVO)BeanMapper.map((Object)((Object)entity), RmatDocumentVO.class);
        rmatDocumentVO.setRmatDocumentSchemeList(null);
        rmatDocumentVO.setRmatDocumentSellList(null);
        if (rmatDocumentVO.getNoticeId() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(RmatNoticeSupplierEntity::getNoticeId, (Object)entity.getNoticeId());
            wrapper.ne(RmatNoticeSupplierEntity::getState, (Object)1);
            List list = this.rmatNoticeSupplierService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List noticeSupplierVOS = BeanMapper.mapList((Iterable)list, RmatNoticeSupplierVO.class);
                Map<Object, Object> documentSupplierVOMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)rmatDocumentVO.getRmatDocumentSupplierList())) {
                    documentSupplierVOMap = rmatDocumentVO.getRmatDocumentSupplierList().stream().filter(t -> t.getSupplierId() != null).collect(Collectors.toMap(RmatDocumentSupplierVO::getSupplierId, item -> item, (v1, v2) -> v2));
                }
                for (RmatNoticeSupplierVO noticeSupplier : noticeSupplierVOS) {
                    if (documentSupplierVOMap.containsKey(noticeSupplier.getSupplierId())) {
                        noticeSupplier.setDocumentType(Integer.valueOf(0));
                        continue;
                    }
                    noticeSupplier.setDocumentType(Integer.valueOf(1));
                }
                rmatDocumentVO.setRmatDocumentSupplierDetail(noticeSupplierVOS);
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(RmatDocumentSupplierEntity::getDocumentId, (Object)id);
        lambda.eq(RmatDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.rmatDocumentSupplierService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)supplierList)) {
            List rmatDocumentSupplierVOS = BeanMapper.mapList((Iterable)supplierList, RmatDocumentSupplierVO.class);
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, (Object)id);
            lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, (Object)talkNum);
            lambdaScheme.orderByAsc(RmatDocumentSchemeEntity::getSchemeName);
            List schemeList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
            Map<Long, List<RmatDocumentSchemeEntity>> schemeMap = schemeList.stream().collect(Collectors.groupingBy(RmatDocumentSchemeEntity::getDocumentSupplierId));
            if (entity.getBidFlag() == 0) {
                for (RmatDocumentSupplierVO rmatDocumentSupplierEntity : rmatDocumentSupplierVOS) {
                    List<RmatDocumentSchemeEntity> rmatDocumentSchemeEntities = schemeMap.get(rmatDocumentSupplierEntity.getId());
                    String schemeMoney = "";
                    for (RmatDocumentSchemeEntity rmatDocumentSchemeEntity : rmatDocumentSchemeEntities) {
                        schemeMoney = schemeMoney + rmatDocumentSchemeEntity.getSchemeName() + ":" + rmatDocumentSchemeEntity.getMoneyTax().setScale(2, 5) + "\u5143;";
                    }
                    int length = schemeMoney.length();
                    String schemeMoneyNew = schemeMoney.substring(0, length - 1);
                    rmatDocumentSupplierEntity.setSchemeMoney(schemeMoneyNew);
                }
                if (CollectionUtils.isNotEmpty((Collection)rmatDocumentSupplierVOS)) {
                    List data;
                    List attachIds = rmatDocumentSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
                    HashMap map = new HashMap();
                    map.put("sourceIds", attachIds);
                    JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
                    CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                        Map attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                        for (RmatDocumentSupplierVO rmatDocumentSupplierVO : rmatDocumentSupplierVOS) {
                            AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(rmatDocumentSupplierVO.getId());
                            if (attachmentVO == null) continue;
                            rmatDocumentSupplierVO.setAttachId(attachmentVO.getId());
                            rmatDocumentSupplierVO.setFileName(attachmentVO.getFileName());
                        }
                    }
                }
            }
            rmatDocumentVO.setRmatDocumentSupplierList(rmatDocumentSupplierVOS);
            rmatDocumentVO.setRmatDocumentSupplierSchemeList(rmatDocumentSupplierVOS);
            List rmatDocumentDetailList = rmatDocumentVO.getRmatDocumentDetailList();
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)id);
            lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, (Object)talkNum);
            lambdaSell.orderByAsc(RmatDocumentSellEntity::getSupplierId);
            lambdaSell.orderByAsc(RmatDocumentSellEntity::getSchemeName);
            List sellList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
            if (CollectionUtils.isNotEmpty((Collection)sellList)) {
                List rmatDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RmatDocumentSellVO.class);
                for (Object rmatDocumentSellVO : rmatDocumentSellVOS) {
                    if (entity.getBidFlag() == 1) {
                        rmatDocumentSellVO.setPrice(null);
                        rmatDocumentSellVO.setPriceTax(null);
                        rmatDocumentSellVO.setMoney(null);
                        rmatDocumentSellVO.setMoneyTax(null);
                        rmatDocumentSellVO.setSellTax(null);
                        rmatDocumentSellVO.setTenderNum(null);
                        rmatDocumentSellVO.setTenderMoney(null);
                        rmatDocumentSellVO.setTenderFlag(null);
                    }
                    if (entity.getBidFlag() != 0) continue;
                    rmatDocumentSellVO.setTenderNum(null);
                    rmatDocumentSellVO.setTenderMoney(null);
                    rmatDocumentSellVO.setTenderFlag(null);
                }
                Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOS.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getDetailId));
                for (RmatDocumentDetailVO rmatDocumentDetailVO : rmatDocumentDetailList) {
                    ArrayList documentSupplierVOS = new ArrayList();
                    List<RmatDocumentSellVO> rmatDocumentSellEntities = sellMap.get(rmatDocumentDetailVO.getId());
                    Map<Long, List<RmatDocumentSellVO>> sellDetailMap = rmatDocumentSellEntities.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSupplierId));
                    sellDetailMap.forEach((key, value) -> {
                        RmatDocumentSupplierVO rmatDocumentSupplierVO = new RmatDocumentSupplierVO();
                        rmatDocumentSupplierVO.setSupplierId(key);
                        RmatDocumentSellVO rmatDocumentSellVO = (RmatDocumentSellVO)value.stream().findFirst().get();
                        rmatDocumentSupplierVO.setSupplierName(rmatDocumentSellVO.getSupplierName());
                        rmatDocumentSupplierVO.setRmatDocumentSellVOList(value);
                        documentSupplierVOS.add(rmatDocumentSupplierVO);
                    });
                    rmatDocumentDetailVO.setRmatDocumentSupplierVOList(documentSupplierVOS);
                }
                List rmatDocumentDetailSellList = rmatDocumentVO.getRmatDocumentDetailList();
                rmatDocumentVO.setRmatDocumentDetailSellList(rmatDocumentDetailSellList);
            }
        }
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentVO.getInviteId()));
        rmatDocumentVO.setRmatDetailRecord(BeanMapper.mapList(rmatInviteEntity.getRmatDetailRecord(), RmatInviteDetailRecordVO.class));
        return rmatDocumentVO;
    }

    @Override
    public List<RmatDocumentSellVO> getSchemeDetail(RmatDocumentSellVO rmatDocumentSellVO) {
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getSupplierId, (Object)rmatDocumentSellVO.getSupplierId());
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatDocumentSellVO.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getSchemeId, (Object)rmatDocumentSellVO.getSchemeId());
        List list = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOList = BeanMapper.mapList((Iterable)list, RmatDocumentSellVO.class);
        return rmatDocumentSellVOList;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)documentId));
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)this.rmatDocumentSupplierService.selectById(supplierDetailId));
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setSupplierId(rmatDocumentSupplierEntity.getSupplierId());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setPurchaseType(rmatDocumentEntity.getPurchaseType());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rmatDocumentSchemeEntityList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rmatDocumentSchemeVOList = BeanMapper.mapList((Iterable)rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatDocumentSupplierEntity.getDocumentId());
        List rmatDocumentSellEntityList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOList = BeanMapper.mapList((Iterable)rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList) {
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rmatDocumentSupplierSellVO;
    }

    @Override
    @Transactional
    public RmatDocumentVO extendDocument(RmatDocumentRecordVO rmatDocumentRecordVO) {
        RmatDocumentRecordEntity rmatDocumentRecordEntity = (RmatDocumentRecordEntity)((Object)BeanMapper.map((Object)rmatDocumentRecordVO, RmatDocumentRecordEntity.class));
        this.rmatDocumentRecordService.save((Object)rmatDocumentRecordEntity);
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)rmatDocumentRecordVO.getDocumentId()));
        rmatDocumentEntity.setOfferEndTime(rmatDocumentRecordVO.getNewTime());
        boolean b = super.updateById((Object)rmatDocumentEntity);
        RmatSupplierSellVO supplierSellVO = new RmatSupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(rmatDocumentEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(rmatDocumentRecordVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        RmatDocumentVO rmatDocumentVO = this.queryDetail(rmatDocumentRecordVO.getDocumentId());
        return rmatDocumentVO;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        RmatTalkEntity rmatTalkEntity = (RmatTalkEntity)((Object)this.rmatTalkService.selectById(talkId));
        Integer talkNum = rmatTalkEntity.getTalkNum();
        if (rmatTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        ArrayList<RmatTalkVO> talkVOArrayList = new ArrayList<RmatTalkVO>();
        String name = null;
        for (int a = 0; a <= talkNum; ++a) {
            RmatTalkVO rmatTalkVO = new RmatTalkVO();
            rmatTalkVO.setTalkNum(Integer.valueOf(a));
            name = a == 0 ? "\u9996\u6b21\u62a5\u4ef7" : "\u7b2c" + a + "\u8f6e\u62a5\u4ef7";
            rmatTalkVO.setTalkNumName(name);
            talkVOArrayList.add(rmatTalkVO);
        }
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)this.rmatDocumentSupplierService.selectById(supplierDetailId));
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        rmatDocumentSupplierSellVO.setSupplierName(rmatDocumentSupplierEntity.getSupplierName());
        for (RmatTalkVO rmatTalkVO : talkVOArrayList) {
            LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
            lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentId, (Object)rmatDocumentSupplierEntity.getDocumentId());
            lambdaScheme.eq(RmatDocumentSchemeEntity::getSupplierId, (Object)rmatDocumentSupplierEntity.getSupplierId());
            lambdaScheme.eq(RmatDocumentSchemeEntity::getTalkNum, (Object)rmatTalkVO.getTalkNum());
            List rmatDocumentSchemeEntityList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
            if (CollectionUtils.isEmpty((Collection)rmatDocumentSchemeEntityList)) continue;
            List rmatDocumentSchemeVOList = BeanMapper.mapList((Iterable)rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);
            List schemePkList = rmatDocumentSchemeVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
            lambdaSell.in(RmatDocumentSellEntity::getSchemeId, schemePkList);
            List rmatDocumentSellEntityList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
            List rmatDocumentSellVOList = BeanMapper.mapList((Iterable)rmatDocumentSellEntityList, RmatDocumentSellVO.class);
            Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
            for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList) {
                List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
                rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
            }
            rmatTalkVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);
        }
        rmatDocumentSupplierSellVO.setRmatTalkVOList(talkVOArrayList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rmatDocumentSupplierSellVO;
    }

    private Map<String, Object> getFileInfo(Long sourceId) {
        AttachmentVO attachmentVO;
        List data;
        HashMap<String, Object> map = new HashMap<String, Object>();
        CommonResponse attachResponse = this.attachmentApi.queryListBySourceId(sourceId, BILL_SUPPLIER_TYPE, "supplierFileType", null);
        if (attachResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)attachResponse.getData())) && (attachmentVO = (AttachmentVO)data.stream().findFirst().get()) != null) {
            map.put("fileName", attachmentVO.getFileName());
            map.put("attachId", attachmentVO.getId());
        }
        return map;
    }

    @Override
    public RmatDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException {
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)super.selectById((Serializable)id));
        rmatDocumentEntity.setPublishFlag(0);
        super.updateById((Object)rmatDocumentEntity);
        RmatNoticeSupplierTbVO rmatNoticeSupplierTbVO = new RmatNoticeSupplierTbVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rmatNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u6587\u4ef6");
        rmatNoticeSupplierTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatDocumentEntity.getInviteId()));
        if (rmatDocumentEntity.getTenderType() == 2) {
            rmatNoticeSupplierTbVO.setNoticeType(Integer.valueOf(2));
        } else {
            rmatNoticeSupplierTbVO.setNoticeType(Integer.valueOf(3));
        }
        if (rmatDocumentEntity.getPurchaseType() == 1) {
            rmatNoticeSupplierTbVO.setSourceProjectId(null);
            rmatNoticeSupplierTbVO.setProjectName(null);
            rmatNoticeSupplierTbVO.setProjectCode(null);
        } else {
            rmatNoticeSupplierTbVO.setSourceProjectId(rmatDocumentEntity.getProjectId().toString());
            rmatNoticeSupplierTbVO.setProjectName(rmatDocumentEntity.getProjectName());
            rmatNoticeSupplierTbVO.setProjectCode(rmatDocumentEntity.getProjectCode());
        }
        rmatNoticeSupplierTbVO.setSourceOrgId(rmatDocumentEntity.getOrgId().toString());
        rmatNoticeSupplierTbVO.setOrgName(rmatDocumentEntity.getOrgName());
        rmatNoticeSupplierTbVO.setSourceUnitId(rmatDocumentEntity.getUnitId().toString());
        rmatNoticeSupplierTbVO.setUnitName(rmatDocumentEntity.getUnitName());
        rmatNoticeSupplierTbVO.setMemo(rmatDocumentEntity.getMemo());
        rmatNoticeSupplierTbVO.setType("RMAT");
        rmatNoticeSupplierTbVO.setTenderName(rmatDocumentEntity.getDocumentName());
        rmatNoticeSupplierTbVO.setTenderType(rmatDocumentEntity.getTenderType());
        rmatNoticeSupplierTbVO.setPurchaseType(rmatDocumentEntity.getPurchaseType().toString());
        rmatNoticeSupplierTbVO.setPurchaseName(rmatDocumentEntity.getPurchaseName());
        rmatNoticeSupplierTbVO.setSourceEmployeeId(rmatDocumentEntity.getEmployeeId().toString());
        rmatNoticeSupplierTbVO.setEmployeeName(rmatDocumentEntity.getEmployeeName());
        rmatNoticeSupplierTbVO.setEmployeeMobile(rmatDocumentEntity.getEmployeeMobile());
        rmatNoticeSupplierTbVO.setValueType(rmatDocumentEntity.getValueType());
        rmatNoticeSupplierTbVO.setContent(rmatDocumentEntity.getDocumentContent());
        rmatNoticeSupplierTbVO.setOfferStartTime(sdf.format(rmatDocumentEntity.getOfferStartTime()));
        rmatNoticeSupplierTbVO.setOfferEndTime(sdf.format(rmatDocumentEntity.getOfferEndTime()));
        rmatNoticeSupplierTbVO.setBrandFlag(rmatDocumentEntity.getBrandFlag());
        rmatNoticeSupplierTbVO.setProjectLinkName(rmatDocumentEntity.getProjectLinkName());
        rmatNoticeSupplierTbVO.setProjectLinkPhone(rmatDocumentEntity.getProjectLinkPhone());
        rmatNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        rmatNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rmatNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rmatNoticeSupplierTbVO.setRentType(inviteEntity.getRentType());
        rmatNoticeSupplierTbVO.setSettlementClause(inviteEntity.getSettlementClause());
        ArrayList<Object> rmatNoticeDetailVOS = new ArrayList<Object>();
        List<RmatDocumentDetailVO> documentDetailEntityList = ((RmatDocumentMapper)this.baseMapper).selectSumDetail(rmatDocumentEntity.getId());
        for (RmatDocumentDetailVO rmatDocumentDetailEntity : documentDetailEntityList) {
            RmatNoticeDetailTbVO rmatNoticeDetailTbVO = new RmatNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)rmatNoticeDetailTbVO, (Object)rmatDocumentDetailEntity);
            rmatNoticeDetailTbVO.setNum(rmatDocumentDetailEntity.getSumNum());
            rmatNoticeDetailTbVO.setMoney(rmatDocumentDetailEntity.getSumMoney());
            rmatNoticeDetailTbVO.setMoneyTax(rmatDocumentDetailEntity.getSumMoneyTax());
            rmatNoticeDetailTbVO.setSourceId(rmatDocumentEntity.getInviteId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialId(rmatDocumentDetailEntity.getMaterialId() == null ? null : rmatDocumentDetailEntity.getMaterialId().toString());
            rmatNoticeDetailTbVO.setSourceMaterialTypeId(rmatDocumentDetailEntity.getMaterialTypeId().toString());
            rmatNoticeDetailVOS.add(rmatNoticeDetailTbVO);
        }
        rmatNoticeSupplierTbVO.setRmatDetailList(rmatNoticeDetailVOS);
        if (rmatDocumentEntity.getTenderType() != 2) {
            List detailEntityList = this.supplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmatDocumentSupplierDetailEntity::getInviteId, (Object)rmatDocumentEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<RmatNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<RmatNoticeSupplierDetailTbVO>();
            for (RmatDocumentSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
                rmatNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rmatNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                rmatNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(rmatNoticeSupplierDetailTbVO);
            }
            rmatNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        String stringFb = JSONObject.toJSONString((Object)rmatNoticeSupplierTbVO);
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + response.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public CommonResponse delSupplier(Long id) {
        RmatDocumentEntity rmatDocumentEntity = (RmatDocumentEntity)((Object)((RmatDocumentMapper)this.baseMapper).selectById(id));
        List rmatDocumentSupplierList = this.supplierMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_id", (Object)rmatDocumentEntity.getId())).eq((Object)"dr", (Object)0));
        List supplierDetailList = this.supplierDetailMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"invite_id", (Object)rmatDocumentEntity.getInviteId())).eq((Object)"dr", (Object)0));
        ArrayList oldIds = new ArrayList();
        ArrayList newIds = new ArrayList();
        rmatDocumentSupplierList.stream().forEach(it -> oldIds.add(it.getSupplierId()));
        supplierDetailList.stream().forEach(it -> newIds.add(it.getSupplierId()));
        List newId = newIds.stream().filter(it -> !oldIds.contains(it)).collect(Collectors.toList());
        List newRequestList = supplierDetailList.stream().filter(it -> newId.contains(it.getSupplierId())).collect(Collectors.toList());
        ArrayList<RmatNoticeSupplierDetailTbVO> signVOList = new ArrayList<RmatNoticeSupplierDetailTbVO>();
        for (RmatDocumentSupplierDetailEntity supplierDetailEntity : newRequestList) {
            RmatNoticeSupplierDetailTbVO rmatNoticeSupplierDetailTbVO = new RmatNoticeSupplierDetailTbVO();
            rmatNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
            rmatNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            rmatNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
            rmatNoticeSupplierDetailTbVO.setOutReason("\u8d85\u65f6\u672a\u62a5\u4ef7");
            signVOList.add(rmatNoticeSupplierDetailTbVO);
        }
        this.logger.info("\u5254\u9664\u7684\u4f9b\u5e94\u5546" + JSON.toJSONString(signVOList));
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(signVOList), this.appId, this.appSecret, this.appHost);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5254\u9664\u4f9b\u5e94\u5546\u6210\u529f");
    }

    @Override
    public RmatDocumentVO saveManyDocument(Long id) {
        RmatDocumentEntity rmatDocumentEntity = new RmatDocumentEntity();
        RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(id));
        rmatDocumentEntity.setInviteId(inviteEntity.getId());
        rmatDocumentEntity.setDocumentName(inviteEntity.getTenderName());
        if (inviteEntity.getPurchaseType() == 0) {
            rmatDocumentEntity.setProjectId(inviteEntity.getProjectId());
            rmatDocumentEntity.setProjectName(inviteEntity.getProjectName());
            rmatDocumentEntity.setProjectCode(inviteEntity.getProjectCode());
        }
        rmatDocumentEntity.setPurchaseId(inviteEntity.getPurchaseId());
        rmatDocumentEntity.setPurchaseName(inviteEntity.getPurchaseName());
        rmatDocumentEntity.setPurchaseType(inviteEntity.getPurchaseType());
        rmatDocumentEntity.setOrgId(inviteEntity.getOrgId());
        rmatDocumentEntity.setOrgName(inviteEntity.getOrgName());
        rmatDocumentEntity.setParentOrgId(inviteEntity.getParentOrgId());
        rmatDocumentEntity.setParentOrgName(inviteEntity.getParentOrgName());
        rmatDocumentEntity.setValueType(inviteEntity.getValueType());
        rmatDocumentEntity.setUnitId(inviteEntity.getUnitId());
        rmatDocumentEntity.setUnitName(inviteEntity.getUnitName());
        rmatDocumentEntity.setTenderType(inviteEntity.getTenderType());
        rmatDocumentEntity.setSettlementClause(inviteEntity.getSettlementClause());
        rmatDocumentEntity.setBidFlag(1);
        rmatDocumentEntity.setPublishFlag(1);
        rmatDocumentEntity.setNextFlag(1);
        List<RmatInviteDetailEntity> rmatNoticeDetailList = inviteEntity.getRmatDetail();
        List rmatDocumentDetailList = BeanMapper.mapList(rmatNoticeDetailList, RmatDocumentDetailEntity.class);
        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList) {
            rmatDocumentDetailEntity.setId(null);
        }
        rmatDocumentEntity.setRmatDocumentDetailList(rmatDocumentDetailList);
        List<RmatInviteSupplierEntity> supplierDetailList = inviteEntity.getSupplierDetail();
        List rmatDocumentSupplierDetailVOS = BeanMapper.mapList(supplierDetailList, RmatDocumentSupplierDetailEntity.class);
        for (RmatDocumentSupplierDetailEntity rmatDocumentSupplierDetailVO : rmatDocumentSupplierDetailVOS) {
            rmatDocumentSupplierDetailVO.setId(null);
            this.documentSupplierDetailService.saveOrUpdate((Object)rmatDocumentSupplierDetailVO);
        }
        this.service.saveOrUpdate((Object)rmatDocumentEntity, false);
        ProcessEntity processEntity = new ProcessEntity();
        switch (inviteEntity.getTenderType()) {
            case 3: {
                inviteEntity.setTenderStage(6);
                processEntity.setBillName("\u7ade\u4e89\u6027\u8c08\u5224");
                break;
            }
            case 4: {
                inviteEntity.setTenderStage(8);
                processEntity.setBillName("\u5355\u4e00\u6765\u6e90");
                break;
            }
            case 5: {
                inviteEntity.setTenderStage(9);
                processEntity.setBillName("\u7d27\u6025\u62db\u6807");
                break;
            }
            case 2: {
                inviteEntity.setTenderStage(10);
                processEntity.setBillName("\u8be2\u4ef7\u516c\u544a");
            }
        }
        this.rmatInviteService.updateById((Object)inviteEntity);
        processEntity.setBillId(rmatDocumentEntity.getId());
        processEntity.setTenderId(id);
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/fourJzDyJjXj");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatDocumentVO vo = (RmatDocumentVO)BeanMapper.map((Object)((Object)rmatDocumentEntity), RmatDocumentVO.class);
        return vo;
    }

    @Override
    public RmatDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        RmatTalkRecordEntity rmatTalkRecordEntity = (RmatTalkRecordEntity)((Object)this.rmatTalkRecordService.selectById(talkId));
        Integer talkNum = rmatTalkRecordEntity.getTalkNum();
        if (rmatTalkRecordEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        RmatDocumentSupplierSellVO rmatDocumentSupplierSellVO = new RmatDocumentSupplierSellVO();
        RmatDocumentSupplierEntity rmatDocumentSupplierEntity = (RmatDocumentSupplierEntity)((Object)this.rmatDocumentSupplierService.selectById(supplierDetailId));
        rmatDocumentSupplierSellVO.setLinkName(rmatDocumentSupplierEntity.getLinkName());
        rmatDocumentSupplierSellVO.setLinkMobile(rmatDocumentSupplierEntity.getLinkMobile());
        rmatDocumentSupplierSellVO.setOfferTime(rmatDocumentSupplierEntity.getOfferTime());
        rmatDocumentSupplierSellVO.setTaxMemo(rmatDocumentSupplierEntity.getTaxMemo());
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(RmatDocumentSchemeEntity::getDocumentSupplierId, (Object)supplierDetailId);
        List rmatDocumentSchemeEntityList = this.rmatDocumentSchemeService.list((Wrapper)lambdaScheme);
        List rmatDocumentSchemeVOList = BeanMapper.mapList((Iterable)rmatDocumentSchemeEntityList, RmatDocumentSchemeVO.class);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RmatDocumentSellEntity::getDocumentId, (Object)rmatDocumentSupplierEntity.getDocumentId());
        lambdaSell.eq(RmatDocumentSellEntity::getTalkNum, (Object)talkNum);
        List rmatDocumentSellEntityList = this.rmatDocumentSellService.list((Wrapper)lambdaSell);
        List rmatDocumentSellVOList = BeanMapper.mapList((Iterable)rmatDocumentSellEntityList, RmatDocumentSellVO.class);
        Map<Long, List<RmatDocumentSellVO>> sellMap = rmatDocumentSellVOList.stream().collect(Collectors.groupingBy(RmatDocumentSellVO::getSchemeId));
        for (RmatDocumentSchemeVO rmatDocumentSchemeVO : rmatDocumentSchemeVOList) {
            List<RmatDocumentSellVO> rmatDocumentSellVOS = sellMap.get(rmatDocumentSchemeVO.getId());
            rmatDocumentSchemeVO.setRmatDocumentSellList(rmatDocumentSellVOS);
        }
        rmatDocumentSupplierSellVO.setRmatDocumentSchemeList(rmatDocumentSchemeVOList);
        Map<String, Object> fileInfo = this.getFileInfo(supplierDetailId);
        if (fileInfo != null) {
            if (fileInfo.containsKey("attachId")) {
                Long attachId = Long.valueOf(String.valueOf(fileInfo.get("attachId")));
                rmatDocumentSupplierSellVO.setAttachId(attachId);
            }
            if (fileInfo.containsKey("fileName")) {
                rmatDocumentSupplierSellVO.setFileName(fileInfo.get("fileName").toString());
            }
        }
        return rmatDocumentSupplierSellVO;
    }

    @Override
    public RmatDocumentVO saveDocument(Long noticeId) {
        RmatDocumentEntity entity = new RmatDocumentEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RmatNoticeEntity rmatNoticeEntity = (RmatNoticeEntity)((Object)this.rmatNoticeService.selectById(noticeId));
        RmatInviteEntity rmatInvite = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatNoticeEntity.getInviteId()));
        List<RmatInviteDetailEntity> rmatInviteDetailList = rmatInvite.getRmatDetail();
        List rmatDocumentDetailList = BeanMapper.mapList(rmatInviteDetailList, RmatDocumentDetailEntity.class);
        for (RmatDocumentDetailEntity rmatDocumentDetailEntity : rmatDocumentDetailList) {
            rmatDocumentDetailEntity.setId(null);
        }
        entity.setRmatDocumentDetailList(rmatDocumentDetailList);
        entity.setProjectId(rmatNoticeEntity.getProjectId());
        entity.setNoticeId(noticeId);
        entity.setProjectName(rmatNoticeEntity.getProjectName());
        entity.setOrgId(rmatNoticeEntity.getOrgId());
        entity.setOrgName(rmatNoticeEntity.getOrgName());
        entity.setParentOrgId(rmatNoticeEntity.getParentOrgId());
        entity.setParentOrgName(rmatNoticeEntity.getParentOrgName());
        entity.setProjectCode(rmatNoticeEntity.getProjectCode());
        entity.setDocumentName(rmatNoticeEntity.getNoticeName());
        entity.setEmployeeId(rmatNoticeEntity.getEmployeeId());
        entity.setEmployeeName(rmatNoticeEntity.getEmployeeName());
        entity.setEmployeeMobile(rmatNoticeEntity.getEmployeeMobile());
        entity.setInviteId(rmatNoticeEntity.getInviteId());
        entity.setPurchaseId(rmatNoticeEntity.getPurchaseId());
        entity.setPurchaseName(rmatNoticeEntity.getPurchaseName());
        entity.setPurchaseType(rmatNoticeEntity.getPurchaseType());
        entity.setTenderType(rmatNoticeEntity.getTenderType());
        RmatInviteEntity rmatInviteEntity = (RmatInviteEntity)((Object)this.rmatInviteService.selectById(rmatNoticeEntity.getInviteId()));
        entity.setValueType(rmatInviteEntity.getValueType());
        entity.setBidFlag(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        this.service.saveOrUpdate((Object)entity, false);
        rmatInviteEntity.setTenderStage(3);
        this.rmatInviteService.updateById((Object)rmatInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u62db\u6807\u6587\u4ef6");
        processEntity.setTenderId(rmatNoticeEntity.getInviteId());
        processEntity.setType(4);
        processEntity.setFrontendUrl("rmat/document");
        this.processService.saveOrUpdate((Object)processEntity);
        RmatDocumentVO vo = (RmatDocumentVO)BeanMapper.map((Object)((Object)entity), RmatDocumentVO.class);
        return vo;
    }

    @Override
    public CommonResponse<Boolean> checkExpertNum(Long documentId) {
        List expertEntityList = this.documentExpertService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(RmatDocumentExpertEntity::getDocumentId, (Object)documentId)).eq(BaseEntity::getDr, (Object)0));
        int totalNum = expertEntityList.size();
        if (totalNum < 3) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u81f3\u5c11\u4e3a3\u4eba\uff01", (Object)false);
        }
        if (totalNum % 2 == 0) {
            return CommonResponse.error((String)"\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u5fc5\u987b\u4e3a\u5355\u6570\uff01", (Object)false);
        }
        int departmentExpertNum = (int)expertEntityList.stream().filter(entity -> "\u96c6\u56e2".equals(entity.getExpertFromName())).count();
        int projectExpertNum = (int)expertEntityList.stream().filter(entity -> "\u9879\u76ee".equals(entity.getExpertFromName())).count();
        int trueDepartmentExpertNum = (int)Math.ceil((double)totalNum * 1.0 / 3.0);
        int trueProjectExpertNum = totalNum - trueDepartmentExpertNum;
        if (departmentExpertNum != trueDepartmentExpertNum || projectExpertNum != trueProjectExpertNum) {
            return CommonResponse.error((String)("\u6240\u9009\u4e13\u5bb6\u6570\u91cf\u4e0d\u7b26\u5408\u8981\u6c42\uff01\u96c6\u56e2\u4e13\u5bb6" + trueDepartmentExpertNum + "\u4e2a,\u9879\u76ee\u4e13\u5bb6" + trueProjectExpertNum + "\u4e2a\uff01"), (Object)false);
        }
        return CommonResponse.success((String)"\u4e13\u5bb6\u9009\u53d6\u6210\u529f\uff01", (Object)true);
    }
}

