/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.sub.bean.SubAdviceEntity;
import com.ejianc.business.tender.sub.bean.SubBidEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.mapper.SubAdviceMapper;
import com.ejianc.business.tender.sub.service.ISubAdviceService;
import com.ejianc.business.tender.sub.service.ISubBidService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.vo.SubAdviceSupplierPushVO;
import com.ejianc.business.tender.sub.vo.SubAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="subAdviceService")
public class SubAdviceServiceImpl
extends BaseServiceImpl<SubAdviceMapper, SubAdviceEntity>
implements ISubAdviceService {
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000006";
    @Autowired
    private ISubBidService subBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        SubAdviceEntity subAdviceEntity = (SubAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            subAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            subAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            subAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(subAdviceEntity.getId());
            cv.setContractName(subAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)subAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        SubAdviceEntity subAdviceEntity = (SubAdviceEntity)((Object)super.selectById((Serializable)id));
        subAdviceEntity.setSendFlag(0);
        super.updateById((Object)subAdviceEntity);
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subAdviceEntity.getInviteId()));
        SubAdviceSupplierPushVO subAdviceSupplierPushVO = (SubAdviceSupplierPushVO)BeanMapper.map((Object)((Object)subAdviceEntity), SubAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        subAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        subAdviceSupplierPushVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u5206\u5305\u4e2d\u6807\u901a\u77e5\u4e66");
        subAdviceSupplierPushVO.setSourceId(subAdviceEntity.getId().toString());
        subAdviceSupplierPushVO.setBidTitle(subAdviceEntity.getTitleName());
        subAdviceSupplierPushVO.setSourceProjectId(subAdviceEntity.getProjectId() != null ? subAdviceEntity.getProjectId().toString() : null);
        subAdviceSupplierPushVO.setSourceOrgId(subAdviceEntity.getOrgId().toString());
        subAdviceSupplierPushVO.setSourceUnitId(subAdviceEntity.getUnitId().toString());
        subAdviceSupplierPushVO.setType(CommonUtils.getGysType(1));
        subAdviceSupplierPushVO.setTenderType(subInviteEntity.getTenderType());
        subAdviceSupplierPushVO.setBidDate(subAdviceEntity.getNoticeDate());
        subAdviceSupplierPushVO.setMoney(subAdviceEntity.getMoney());
        subAdviceSupplierPushVO.setMoneyTax(subAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)subAdviceSupplierPushVO);
        boolean b = this.stuffAdviceService.pushBillToSupCenter(dataInfo, subAdviceEntity.getSupplierId(), subAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", subAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    @Override
    public List<SubAdviceVO> queryAdviceList(Long id) {
        SubBidEntity subBidEntity = (SubBidEntity)((Object)this.subBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(SubAdviceEntity::getInviteId, (Object)subBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List subAdviceVOS = BeanMapper.mapList((Iterable)list, SubAdviceVO.class);
        if (CollectionUtils.isNotEmpty((Collection)subAdviceVOS)) {
            List data;
            List attachIds = subAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (SubAdviceVO subAdviceVO : subAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(subAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    subAdviceVO.setAttachId(attachmentVO.getId());
                    subAdviceVO.setFileName(attachmentVO.getFileName());
                    subAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return subAdviceVOS;
    }
}

