package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.other.bean.*;
import com.ejianc.business.tender.other.mapper.OtherDocumentSellMapper;
import com.ejianc.business.tender.other.service.*;
import com.ejianc.business.tender.other.vo.OtherDocumentSellVO;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailBidderEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@Service("otherDocumentSellService")
public class OtherDocumentSellServiceImpl extends BaseServiceImpl<OtherDocumentSellMapper, OtherDocumentSellEntity> implements IOtherDocumentSellService {
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherInviteDetailBidderService bidderService;
    @Autowired
    private IOtherInviteDetailRecordService recordService;
    @Autowired
    private IOtherPicketageRefsupplierService otherPicketageRefsupplierService;

    @Override
    public List<OtherDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<OtherDocumentSellVO> queryListByIds(Long id) {
        OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = otherPicketageRefsupplierService.selectById(id);
        List<OtherDocumentSellVO> otherDocumentSellVOList = new ArrayList<>();
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(otherPicketageRefsupplierEntity.getPicketageId());
        if (otherPicketageRefsupplierEntity.getPicketageFlag()==0){
            LambdaQueryWrapper<OtherDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(OtherDocumentSellEntity::getDocumentId,otherPicketageEntity.getDocumentId());
            listWrapper.eq(OtherDocumentSellEntity::getSupplierId,otherPicketageRefsupplierEntity.getSupplierId());
            if (otherPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(OtherDocumentSellEntity::getProjectId,otherPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(OtherDocumentSellEntity::getTenderFlag,1);
            listWrapper.eq(OtherDocumentSellEntity::getPassFlag,1);
            List<OtherDocumentSellEntity> documentSellList = super.list(listWrapper);
            otherDocumentSellVOList = BeanMapper.mapList(documentSellList,OtherDocumentSellVO.class);
        }
        //直接定标
        else if (otherPicketageRefsupplierEntity.getPicketageFlag()==1){
            List<OtherInviteDetailBidderEntity> bidderEntityList = bidderService.list(new QueryWrapper<OtherInviteDetailBidderEntity>().eq("invite_id", otherPicketageRefsupplierEntity.getPicketageId()).eq("supplier_id",otherPicketageRefsupplierEntity.getSupplierId()));
            for (OtherInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                OtherDocumentSellVO otherDocumentSellVO = new OtherDocumentSellVO();
                OtherInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                otherDocumentSellVO.setId(bidderEntity.getId());
                otherDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                otherDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                otherDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                otherDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                otherDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                otherDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                otherDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                otherDocumentSellVO.setUnit(recordEntity.getUnit());
                otherDocumentSellVO.setSpec(recordEntity.getSpec());
                otherDocumentSellVO.setDetailId(bidderEntity.getId());
                otherDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                otherDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                otherDocumentSellVO.setBrand(bidderEntity.getBrand());
                otherDocumentSellVO.setPrice(bidderEntity.getPrice());
                otherDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                otherDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                otherDocumentSellVO.setTenderNum(bidderEntity.getNum());
                otherDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                otherDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                otherDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                otherDocumentSellVOList.add(otherDocumentSellVO);
            }
        }
        return otherDocumentSellVOList;
    }
}
