package com.ejianc.business.tender.sub.controller;

import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.service.impl.SubPicketageBpmServiceImpl;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.business.tender.sub.vo.SubPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sub/subPicketage")
@Api(value = "定标主表", tags = {"定标主表"})
public class SubPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private ISubPicketageService service;
    @Autowired
    private SubPicketageBpmServiceImpl subPicketageBpmService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubPicketageVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubPicketageVO saveorUpdateVO) {
        SubPicketageVO SubPicketageVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("初始化基础数据成功！",SubPicketageVO);
    }
    @ApiOperation("新增或者修改子表供应商")
    @RequestMapping(value = "/saveSupplierBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubPicketageVO> saveSupplierBatch(@RequestBody SubPicketageVO saveorUpdateVO) {
        SubPicketageVO subPicketageVO = service.saveSupplierBatch(saveorUpdateVO);
        return CommonResponse.success("更新成功！",subPicketageVO);
    }
    @ApiOperation("专家评标下一步接口")
    @RequestMapping(value = "/savePicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageVO> savePicketage(@RequestParam Long evaluationId) {
        SubPicketageVO SubPicketageVO = service.savePicketage(evaluationId);
        return CommonResponse.success("初始化基础数据成功！",SubPicketageVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageVO> queryDetail(@RequestParam Long id) {
        SubPicketageVO SubPicketageVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",SubPicketageVO);
    }

    @ApiOperation("紧急招标询价等下一步接口")
    @RequestMapping(value = "/saveManyPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageVO> saveManyPicketage(@RequestParam Long documentId) {
        SubPicketageVO SubPicketageVO = service.saveManyPicketage(documentId);
        return CommonResponse.success("初始化基础数据成功！",SubPicketageVO);
    }

    @ApiOperation("查询供应商列表详情")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
        List<SubPicketageSupplierVO> list = service.querySupplierList(picketageId);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    @ApiOperation("test")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubPicketageSupplierVO> test() {

        subPicketageBpmService.afterApprovalProcessor(538375801402298439L,0,"11");
        return  null;
    }


}
