/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.cost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.cost.bean.PlanControlRuleDetailEntity;
import com.ejianc.business.tender.cost.bean.PlanControlRuleDetailTypeEntity;
import com.ejianc.business.tender.cost.bean.PlanControlRuleEntity;
import com.ejianc.business.tender.cost.service.IPlanControlRuleDetailTypeService;
import com.ejianc.business.tender.cost.service.IPlanControlRuleService;
import com.ejianc.business.tender.cost.vo.PlanControlRuleDetailVO;
import com.ejianc.business.tender.cost.vo.PlanControlRuleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planControlRule"})
public class PlanControlRuleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPlanControlRuleService service;
    @Autowired
    private IPlanControlRuleDetailTypeService detailTypeService;
    @Autowired
    private SessionManager sessionManager;

    public List<PlanControlRuleDetailVO> transformData(List<PlanControlRuleDetailVO> treeNodeList, Long parentId) {
        LinkedList<PlanControlRuleDetailVO> list = new LinkedList<PlanControlRuleDetailVO>();
        for (PlanControlRuleDetailVO node : treeNodeList) {
            if (!node.getParentId().equals(parentId)) continue;
            node.setChildren(this.transformData(treeNodeList, node.getDocId()));
            list.add(node);
        }
        return list;
    }

    public List<PlanControlRuleDetailVO> transformData1(List<PlanControlRuleDetailVO> treeNodeList) {
        LinkedList<PlanControlRuleDetailVO> list = new LinkedList<PlanControlRuleDetailVO>();
        for (PlanControlRuleDetailVO node : treeNodeList) {
            if (node.getChildren() != null && node.getChildren().size() > 0) {
                List<PlanControlRuleDetailVO> planControlRuleDetailVOS = this.transformData1(node.getChildren());
                list.addAll(planControlRuleDetailVOS);
            }
            list.add(node);
        }
        list = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PlanControlRuleDetailVO>(Comparator.comparing(o -> o.getDocId() + ";" + o.getRowState()))), ArrayList::new));
        return list;
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanControlRuleVO> saveOrUpdate(@RequestBody PlanControlRuleVO saveOrUpdateVO) {
        List<PlanControlRuleDetailVO> planControlRuleDetailVOS = this.transformData1(saveOrUpdateVO.getPlanControlRuleDetailList());
        saveOrUpdateVO.setPlanControlRuleDetailList(planControlRuleDetailVOS);
        PlanControlRuleEntity entity = (PlanControlRuleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanControlRuleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanControlRuleEntity planControlRuleEntity = (PlanControlRuleEntity)((Object)this.service.selectById(entity.getId()));
        List<PlanControlRuleDetailEntity> planControlRuleDetailList = planControlRuleEntity.getPlanControlRuleDetailList();
        List<PlanControlRuleDetailTypeEntity> planControlRuleDetailTypeList = planControlRuleEntity.getPlanControlRuleDetailTypeList();
        for (PlanControlRuleDetailEntity planControlRuleDetailEntity : planControlRuleDetailList) {
            for (PlanControlRuleDetailTypeEntity planControlRuleDetailTypeEntity : planControlRuleDetailTypeList) {
                if (!planControlRuleDetailEntity.getFlagId().equals(planControlRuleDetailTypeEntity.getFlagId())) continue;
                planControlRuleDetailTypeEntity.setParentId(planControlRuleDetailEntity.getId());
            }
        }
        this.detailTypeService.saveOrUpdateBatch(planControlRuleDetailTypeList);
        PlanControlRuleEntity planControlRuleEntity1 = (PlanControlRuleEntity)((Object)this.service.selectById(entity.getId()));
        PlanControlRuleVO vo = (PlanControlRuleVO)BeanMapper.map((Object)((Object)planControlRuleEntity1), PlanControlRuleVO.class);
        vo.setPlanControlRuleDetailList(this.transformData(vo.getPlanControlRuleDetailList(), 0L));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanControlRuleVO> queryDetail(Long id) {
        PlanControlRuleEntity entity = (PlanControlRuleEntity)((Object)this.service.selectById(id));
        PlanControlRuleVO vo = (PlanControlRuleVO)BeanMapper.map((Object)((Object)entity), PlanControlRuleVO.class);
        vo.setPlanControlRuleDetailList(this.transformData(vo.getPlanControlRuleDetailList(), 0L));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanControlRuleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanControlRuleVO planControlRuleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanControlRuleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanControlRuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PlanControlRule-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanControlRuleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanControlRuleVO>> refPlanControlRuleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanControlRuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

