/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.vo.UndertakeApiVO;
import com.ejianc.business.tender.cost.vo.SupbidNoticeVO;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.util.MyDateUtil;
import com.ejianc.business.tender.util.TenderTypeUrlEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"report"})
public class ReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReportService service;
    @Autowired
    private ReportMapper reportMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("isBid")) {
            String isBid = (String)((Parameter)param.getParams().get("isBid")).getValue();
            if ("1".equals(isBid)) {
                param.getParams().put("tax_money", new Parameter("sql", (Object)"taxMoney is not null"));
            }
            param.getParams().remove("isBid");
        }
        Map<String, Object> map = this.service.queryData(param);
        IPage page = (IPage)map.get("page");
        BigDecimal sumTaxMoney = (BigDecimal)map.get("sumTaxMoney");
        for (ReportVO record : page.getRecords()) {
            if (record.getTenderTypeName() != null) {
                switch (record.getTenderTypeName()) {
                    case "0": {
                        record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                        break;
                    }
                    case "1": {
                        record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                        break;
                    }
                    case "2": {
                        record.setTenderTypeName("\u8be2\u4ef7");
                        break;
                    }
                    case "3": {
                        record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                        break;
                    }
                    case "4": {
                        record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                        break;
                    }
                    case "5": {
                        record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null != tenderUnit) {
                record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() == 1) {
                record.setPicketageTime(record.getCreateDate());
                if (record.getLineTypeName().equals("\u4e13\u4e1a\u5206\u5305") || record.getLineTypeName().equals("\u52b3\u52a1\u5206\u5305")) {
                    record.setTaxMoney(record.getTaxMoney());
                } else {
                    record.setTaxMoney(record.getTaxMoney());
                }
            }
            if (record.getInviteId() == null) continue;
            QueryParam param1 = new QueryParam();
            param1.getParams().put("invite_id", new Parameter("eq", (Object)record.getInviteId()));
            BigDecimal bigDecimal = this.service.queryReduceCostRate(param1);
            record.setReduceCostRate(bigDecimal);
        }
        JSONObject pageData = new JSONObject();
        pageData.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        pageData.put("total", (Object)page.getTotal());
        pageData.put("current", (Object)page.getCurrent());
        pageData.put("size", (Object)page.getSize());
        pageData.put("pages", (Object)page.getPages());
        pageData.put("sumTaxMoney", (Object)sumTaxMoney);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("isBid")) {
            String isBid = (String)((Parameter)param.getParams().get("isBid")).getValue();
            if ("1".equals(isBid)) {
                param.getParams().put("tax_money", new Parameter("sql", (Object)"taxMoney is not null"));
            }
            param.getParams().remove("isBid");
        }
        Map<String, Object> map = this.service.queryData(param);
        IPage page = (IPage)map.get("page");
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        for (ReportVO record : pageData.getRecords()) {
            if (record.getTenderTypeName() != null) {
                switch (record.getTenderTypeName()) {
                    case "0": {
                        record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                        break;
                    }
                    case "1": {
                        record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                        break;
                    }
                    case "2": {
                        record.setTenderTypeName("\u8be2\u4ef7");
                        break;
                    }
                    case "3": {
                        record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                        break;
                    }
                    case "4": {
                        record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                        break;
                    }
                    case "5": {
                        record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                    }
                }
            } else {
                record.setTenderTypeName("\u5b9a\u6807\u7acb\u9879");
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null != tenderUnit) {
                record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() != 1) continue;
            record.setPicketageTime(record.getCreateDate());
            if (record.getLineTypeName().equals("\u5206\u5305\u62db\u6807")) {
                record.setTaxMoney(record.getTaxMoney());
                continue;
            }
            record.setTaxMoney(record.getTaxMoney());
        }
        this.logger.info("\u62db\u6807\u7edf\u8ba1\u5bfc\u51fa\u524d:{}", (Object)JSONObject.toJSONString((Object)pageData.getRecords()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    @RequestMapping(value={"/querySupplierReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierReportVO>> querySupplierReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        IPage<SupplierReportVO> page = new IPage<SupplierReportVO>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = (Parameter)param.getParams().get("supplierId");
            Long supplierId = (long)Long.valueOf(String.valueOf(obj.getValue()));
            param.getParams().remove("supplierId");
            page = this.service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0": {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case "1": {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case "2": {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case "3": {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case "4": {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case "5": {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
                record.setClickable(Boolean.valueOf(false));
            } else {
                record.setClickable(Boolean.valueOf(true));
            }
            if (!"".equals(record.getLineTypeName()) && record.getLineTypeName() != null) {
                if (record.getEstablishType() == 1) {
                    record.setUrl(TenderTypeUrlEnum.getUrl((String)record.getLineTypeName()) + "/dbcard?id=" + record.getInviteId());
                } else {
                    record.setUrl(TenderTypeUrlEnum.getUrl((String)record.getLineTypeName()) + "/card?id=" + record.getInviteId());
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (!"".equals(tenderUnit) && tenderUnit != null && tenderUnit.indexOf("(") != -1 && tenderUnit.indexOf(")") != -1) {
                record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
            }
            if (record.getEstablishType() != 1) continue;
            record.setPicketageTime(record.getCreateDate());
            if (record.getLineTypeName().equals("\u5206\u5305\u62db\u6807")) {
                record.setTaxMoney(record.getTenderMoney());
                continue;
            }
            record.setTaxMoney(record.getTaxMoney());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6295\u6807\u7edf\u8ba1\u5217\u8868\u5bfc\u51fa")
    @RequestMapping(value={"/supplierReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void supplierReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        IPage<SupplierReportVO> page = new IPage<SupplierReportVO>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = (Parameter)param.getParams().get("supplierId");
            Long supplierId = (long)Long.valueOf(String.valueOf(obj));
            param.getParams().remove("supplierId");
            page = this.service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            if (record.getTenderTypeName() != null) {
                switch (record.getTenderTypeName()) {
                    case "0": {
                        record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                        break;
                    }
                    case "1": {
                        record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                        break;
                    }
                    case "2": {
                        record.setTenderTypeName("\u8be2\u4ef7");
                        break;
                    }
                    case "3": {
                        record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                        break;
                    }
                    case "4": {
                        record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                        break;
                    }
                    case "5": {
                        record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                    }
                }
            } else {
                record.setTenderTypeName("\u5b9a\u6807\u7acb\u9879");
            }
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if ("".equals(tenderUnit) || tenderUnit == null || tenderUnit.indexOf("(") == -1 || tenderUnit.indexOf(")") == -1) continue;
            record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    private static String ClearBracket(String context) {
        int head = (context = context.replaceAll(",", "")).indexOf(40);
        if (head == -1) {
            return context;
        }
        int next = head + 1;
        int count = 1;
        do {
            if (context.charAt(next) == '(') {
                ++count;
            } else if (context.charAt(next) == ')') {
                --count;
            }
            ++next;
            if (count != 0) continue;
            String temp = context.substring(head, next);
            context = context.replace(temp, ",");
            head = context.indexOf(40);
            next = head + 1;
            count = 1;
        } while (head != -1);
        return context.substring(0, context.lastIndexOf(","));
    }

    @RequestMapping(value={"/queryBidData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryBidData(Long orgId) throws ParseException {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId != null) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map map = this.service.queryBidData(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u62db\u6807\u7edf\u8ba1\u6210\u529f", (Object)map);
    }

    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {
        return this.service.queryMoney(tenderType, tenderTypeName, firstDayOfMonth, lastDayOfMonth);
    }

    @RequestMapping(value={"/queryTenderMaterialAmountProportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryTenderMaterialAmountProportion(Integer year) {
        if (year == null) {
            Calendar cal = Calendar.getInstance();
            year = cal.get(1);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = this.service.queryTenderMaterialAmountProportion(year);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOS);
    }

    @RequestMapping(value={"/queryTenderResultTrend"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTenderResultTrend(Integer year) {
        if (year == null) {
            Calendar cal = Calendar.getInstance();
            year = cal.get(1);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = this.service.queryTenderResultTrend(year);
        List money = supbidNoticeVOS.stream().map(SupbidNoticeVO::getMoney).collect(Collectors.toList());
        List num = supbidNoticeVOS.stream().map(SupbidNoticeVO::getNum).collect(Collectors.toList());
        List type = supbidNoticeVOS.stream().map(SupbidNoticeVO::getType).collect(Collectors.toList());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("money", money);
        jsonObject.put("num", num);
        jsonObject.put("date", type);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/queryWinbidMoneyTop6"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryWinbidMoneyTop6(Integer year) {
        if (year == null) {
            Calendar cal = Calendar.getInstance();
            year = cal.get(1);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = this.service.queryWinbidMoneyTop6(year);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOS);
    }

    @RequestMapping(value={"/queryPicketageMoneyProportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryPicketageMoneyProportion(Integer year) {
        if (year == null) {
            Calendar cal = Calendar.getInstance();
            year = cal.get(1);
        }
        List<SupbidNoticeVO> supbidNoticeVOS = this.service.queryPicketageMoneyProportion(year);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOS);
    }

    @RequestMapping(value={"/queryTenderPieChart"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UndertakeApiVO>> queryTenderPieChart(Integer time, @RequestParam(required=false) String type) {
        QueryParam param = new QueryParam();
        param.setPageSize(100);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("tax_money", new Parameter("sql", (Object)"taxMoney is not null"));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time != null && time == 0) {
            param.getParams().put("createDate", new Parameter("between", (Object)(MyDateUtil.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + MyDateUtil.getFromThisYearEndTime(nowDate, dateTimeFormatter))));
        }
        if (type != null && type.equals("material")) {
            param.getParams().put("lineTypeName", new Parameter("in", Arrays.asList("\u6750\u6599\u62db\u6807", "\u5468\u8f6c\u6750\u79df\u8d41")));
        }
        Map<String, Object> map = this.service.queryData(param);
        IPage page = (IPage)map.get("page");
        List records = page.getRecords();
        ArrayList<UndertakeApiVO> undertakeApiVOS = new ArrayList<UndertakeApiVO>();
        UndertakeApiVO vo1 = new UndertakeApiVO(Long.valueOf(1L), "\u516c\u5f00\u62db\u6807", new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo2 = new UndertakeApiVO(Long.valueOf(2L), "\u76f4\u63a5\u5b9a\u6807", new BigDecimal(0.0), Integer.valueOf(0));
        UndertakeApiVO vo3 = new UndertakeApiVO(Long.valueOf(3L), "\u5176\u4ed6\u7c7b\u578b", new BigDecimal(0.0), Integer.valueOf(0));
        for (ReportVO vo : records) {
            if (vo.getEstablishType() == 0) {
                if ("0".equals(vo.getTenderTypeName()) || "2".equals(vo.getTenderTypeName())) {
                    vo1.setSum(Integer.valueOf(vo1.getSum() + 1));
                    vo1.setValue(vo.getTaxMoney().add(vo1.getValue()));
                    continue;
                }
                vo3.setSum(Integer.valueOf(vo3.getSum() + 1));
                vo3.setValue(vo.getTaxMoney().add(vo3.getValue()));
                continue;
            }
            vo2.setSum(Integer.valueOf(vo2.getSum() + 1));
            vo2.setValue(vo.getTaxMoney().add(vo2.getValue()));
        }
        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", undertakeApiVOS);
    }

    @RequestMapping(value={"/queryTenderAvgTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTenderAvgTime() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        BigDecimal yearAvgTime = this.reportMapper.queryTenderAvgTime(MyDateUtil.getFromThisYearStartTime(nowDate, dateTimeFormatter), MyDateUtil.getFromThisYearEndTime(nowDate, dateTimeFormatter), InvocationInfoProxy.getOrgId());
        BigDecimal avgTime = this.reportMapper.queryTenderAvgTime("2022-01-01", MyDateUtil.getFromThisYearEndTime(nowDate, dateTimeFormatter), InvocationInfoProxy.getOrgId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("avgTime", (Object)avgTime);
        jsonObject.put("yearAvgTime", (Object)yearAvgTime);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/tenderSupplierRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupbidNoticeVO>> tenderSupplierRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<SupbidNoticeVO> supbidNoticeVOIPage = this.service.tenderSupplierRank(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOIPage);
    }

    @RequestMapping(value={"/tenderSupplierRankProsub"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupbidNoticeVO>> tenderSupplierRankProsub(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<SupbidNoticeVO> supbidNoticeVOIPage = this.service.tenderSupplierRankProsub(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOIPage);
    }

    @RequestMapping(value={"/queryPicketageMoneyProportionNew"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SupbidNoticeVO>> queryPicketageMoneyProportionNew(@RequestParam(value="time") String time) {
        List<SupbidNoticeVO> supbidNoticeVOS = this.service.queryPicketageMoneyProportionNew(time);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", supbidNoticeVOS);
    }

    @RequestMapping(value={"/queryReduceCostRate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryReduceCostRate(@RequestParam(required=false) Long projectId) {
        QueryParam param = new QueryParam();
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        param.getParams().put("tender_type", new Parameter("eq", (Object)0));
        param.getParams().put("project_id", new Parameter("ne", (Object)587386843419512890L));
        BigDecimal bigDecimal = this.service.queryReduceCostRate(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)bigDecimal);
    }

    @RequestMapping(value={"/queryNotSignContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> queryNotSignContract(@RequestParam Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.reportMapper.queryNotSignContract(projectId));
    }
}

