/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeEntity;
import com.ejianc.business.tender.stuff.bean.StuffNoticeSupplierDetailEntity;
import com.ejianc.business.tender.stuff.mapper.StuffNoticeDetailMapper;
import com.ejianc.business.tender.stuff.mapper.StuffNoticeMapper;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffInviteSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeSupplierDetailService;
import com.ejianc.business.tender.stuff.service.IStuffNoticeSupplierService;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailTbVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeSupplierTbVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeVO;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="stuffNoticeService")
public class StuffNoticeServiceImpl
extends BaseServiceImpl<StuffNoticeMapper, StuffNoticeEntity>
implements IStuffNoticeService {
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IStuffNoticeSupplierDetailService noticeSupplierDetailService;
    @Autowired
    private StuffNoticeDetailMapper stuffNoticeDetailMapper;
    @Autowired
    private IStuffNoticeSupplierService supplierService;
    @Autowired
    private IStuffInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IStuffInviteSupplierService inviteSupplierService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        ((StuffNoticeMapper)this.baseMapper).updateEndTime(noticeId, newTime);
    }

    @Override
    @Transactional
    public CommonResponse publish(StuffNoticeVO stuffNoticeVO) throws InvocationTargetException, IllegalAccessException {
        StuffNoticeEntity stuffNoticeEntity = (StuffNoticeEntity)((Object)((StuffNoticeMapper)this.baseMapper).selectById(stuffNoticeVO.getId()));
        StuffInviteEntity inviteEntity = (StuffInviteEntity)((Object)this.inviteService.selectById(stuffNoticeEntity.getInviteId()));
        stuffNoticeEntity.setPublishFlag(0);
        ((StuffNoticeMapper)this.baseMapper).updateById((Object)stuffNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StuffNoticeSupplierTbVO stuffNoticeSupplierTbVO = new StuffNoticeSupplierTbVO();
        BeanUtils.copyProperties((Object)stuffNoticeSupplierTbVO, (Object)((Object)stuffNoticeEntity));
        stuffNoticeSupplierTbVO.setNoticeStartTime(sdf.format(stuffNoticeEntity.getNoticeStartTime()));
        stuffNoticeSupplierTbVO.setNoticeEndTime(sdf.format(stuffNoticeEntity.getNoticeEndTime()));
        stuffNoticeSupplierTbVO.setNoticeType(Integer.valueOf(0));
        if (stuffNoticeEntity.getPurchaseType() == 1) {
            stuffNoticeSupplierTbVO.setSourceProjectId(null);
        } else {
            stuffNoticeSupplierTbVO.setSourceProjectId(stuffNoticeEntity.getProjectId().toString());
        }
        stuffNoticeSupplierTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
        stuffNoticeSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u62db\u6807\u516c\u544a");
        stuffNoticeSupplierTbVO.setSourceOrgId(stuffNoticeEntity.getOrgId().toString());
        stuffNoticeSupplierTbVO.setSourceUnitId(stuffNoticeEntity.getUnitId().toString());
        stuffNoticeSupplierTbVO.setType("MATERIAL");
        stuffNoticeSupplierTbVO.setTenderName(stuffNoticeEntity.getNoticeName());
        stuffNoticeSupplierTbVO.setSourceEmployeeId(stuffNoticeEntity.getEmployeeId().toString());
        stuffNoticeSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        stuffNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        stuffNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        stuffNoticeSupplierTbVO.setId(null);
        stuffNoticeSupplierTbVO.setCreateTime(null);
        stuffNoticeSupplierTbVO.setUpdateTime(null);
        stuffNoticeSupplierTbVO.setCreateUserCode(null);
        stuffNoticeSupplierTbVO.setUpdateUserCode(null);
        stuffNoticeSupplierTbVO.setSyncEsFlag(null);
        stuffNoticeSupplierTbVO.setVersion(null);
        stuffNoticeSupplierTbVO.setTenantId(null);
        stuffNoticeSupplierTbVO.setDr(null);
        List<StuffNoticeDetailVO> noticeDetailEntityList = this.stuffNoticeDetailMapper.selectSumDetail(stuffNoticeVO.getId());
        ArrayList<Object> stuffNoticeDetailVOS = new ArrayList<Object>();
        for (StuffNoticeDetailVO stuffNoticeDetailEntity : noticeDetailEntityList) {
            StuffNoticeDetailTbVO stuffNoticeDetailTbVO = new StuffNoticeDetailTbVO();
            BeanUtils.copyProperties((Object)stuffNoticeDetailTbVO, (Object)stuffNoticeDetailEntity);
            stuffNoticeDetailTbVO.setMemo(stuffNoticeDetailEntity.getSumMemo());
            stuffNoticeDetailTbVO.setNum(stuffNoticeDetailEntity.getSumNum());
            stuffNoticeDetailTbVO.setMoney(stuffNoticeDetailEntity.getSumMoney());
            stuffNoticeDetailTbVO.setMoneyTax(stuffNoticeDetailEntity.getSumMoneyTax());
            stuffNoticeDetailTbVO.setSourceId(stuffNoticeEntity.getInviteId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialId(stuffNoticeDetailEntity.getMaterialId() == null ? null : stuffNoticeDetailEntity.getMaterialId().toString());
            stuffNoticeDetailTbVO.setSourceMaterialTypeId(stuffNoticeDetailEntity.getMaterialTypeId() == null ? null : stuffNoticeDetailEntity.getMaterialTypeId().toString());
            stuffNoticeDetailTbVO.setInfoPrice(stuffNoticeDetailEntity.getInfoPrice());
            stuffNoticeDetailVOS.add(stuffNoticeDetailTbVO);
        }
        stuffNoticeSupplierTbVO.setDetailList(stuffNoticeDetailVOS);
        if (stuffNoticeVO.getTenderType() == 1) {
            List detailEntityList = this.noticeSupplierDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StuffNoticeSupplierDetailEntity::getInviteId, (Object)stuffNoticeEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
            ArrayList<StuffNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<StuffNoticeSupplierDetailTbVO>();
            for (StuffNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                StuffNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new StuffNoticeSupplierDetailTbVO();
                stuffNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                stuffNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
            }
            stuffNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        CommonResponse response = null;
        try {
            response = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString((Object)stuffNoticeSupplierTbVO), this.appId, this.appSecret, this.appHost);
            if (stuffNoticeEntity.getTenderType() == 1) {
                List detailEntityList = this.inviteSupplierService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StuffInviteSupplierEntity::getInviteId, (Object)stuffNoticeEntity.getInviteId())).eq(BaseEntity::getDr, (Object)0));
                ArrayList supplierDetailTbVOList = new ArrayList();
                for (StuffInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                    String mobile = supplierDetailEntity.getMobile();
                    String url = "https://xt.zzyjjt.com/sso/login?service=https%3A%2F%2Fxt.zzyjjt.com%2Fportal%2Fsso%2Flogin";
                    String context = "\u9080\u8bf7\u60a8\u53c2\u52a0[" + stuffNoticeEntity.getProjectName() + "]\u4e3e\u884c\u7684\u6295\u6807\u62a5\u540d,";
                    context = context + "\u62a5\u540d\u622a\u6b62\u65e5\u671f\uff1a" + DateUtils.format((Date)stuffNoticeEntity.getNoticeEndTime(), (String)"yyyy-MM-dd hh:mm:ss") + ";";
                    context = context + "\u62db\u6807\u8054\u7cfb\u4eba\uff1a" + stuffNoticeEntity.getEmployeeName() + ";";
                    context = context + "\u8054\u7cfb\u65b9\u5f0f\uff1a" + stuffNoticeEntity.getEmployeeMobile() + ";";
                    context = context + "\u8be6\u60c5\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u67e5\u770b" + url;
                    String end = " \u3010\u90d1\u5dde\u4e00\u5efa\u3011";
                    context = context + end;
                    if (mobile == null) continue;
                    SMS.setSendSms((String)mobile, (String)context);
                }
            }
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u8c03\u7528\u5e73\u53f0\u62a5\u540d\u63a5\u53e3\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u516c\u544a\u4fe1\u606f\u63a8\u9001\u6210\u529f");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return ((StuffNoticeEntity)((Object)((StuffNoticeMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(StuffNoticeEntity::getInviteId, (Object)sourceId)))).getId();
    }

    @Override
    public boolean selectFile(StuffNoticeVO vo) {
        List noticeSupplierEntityList = this.supplierService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"notice_id", (Object)vo.getId())).eq((Object)"dr", (Object)0));
        List stuffNoticeSupplierVOS = BeanMapper.mapList((Iterable)noticeSupplierEntityList, StuffNoticeSupplierVO.class);
        if (CollectionUtils.isNotEmpty((Collection)stuffNoticeSupplierVOS)) {
            List data;
            List attachIds = stuffNoticeSupplierVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                for (StuffNoticeSupplierVO stuffNoticeSupplierVO : stuffNoticeSupplierVOS) {
                    List<AttachmentVO> attachmentVOList = attacMap.get(stuffNoticeSupplierVO.getId());
                    this.logger.info("\u67e5\u8be2\u6587\u4ef6\u8be6\u60c5" + JSONObject.toJSONString(attachmentVOList));
                    if (attachmentVOList != null) {
                        ArrayList list = new ArrayList();
                        for (AttachmentVO attachmentVO : attachmentVOList) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("attachId", attachmentVO.getId());
                            hashMap.put("name", attachmentVO.getFileName());
                            list.add(hashMap);
                        }
                        stuffNoticeSupplierVO.setFile(list);
                        continue;
                    }
                    stuffNoticeSupplierVO.setAttachId(null);
                    stuffNoticeSupplierVO.setFileName(null);
                }
            }
            vo.setNoticeSupplierDetail(stuffNoticeSupplierVOS);
        }
        return true;
    }
}

