package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherBatPlanService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.bean.OtherInviteDetailEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailRecordEntity;
import com.ejianc.business.tender.prosub.service.IProSubBatPlanService;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("otherInvite")
public class OtherInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IOtherInviteService service;

	@Autowired
	private IOtherInviteDetailService detailService;

	@Autowired
	private IOtherPicketageRefsupplierService picketageRefsupplierService;

	@Autowired
	private IProjectPoolApi projectPoolApi;
	@Autowired
	private IMessageService messageService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	@Autowired
	private IOtherBatPlanService otherBatPlanService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			OtherInviteEntity inviteEntity = service.selectById(billId);

			//采购计划修改
			if (inviteEntity.getEstablishType() == 1) {
				// 获取采购计划ID
				if (org.apache.commons.collections.CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
					List<String> planIdList = inviteEntity.getOtherDetailRecord().stream()
							.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
							.collect(Collectors.toList());
					// 释放采购计划
					otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),1);
				}
			}
//			List<OtherInviteDetailVO> detailVOList = new ArrayList<>();
//			if (inviteEntity.getPurchaseType()==0){
//				 detailVOList = service.selectSumDetail(billId);
//			}else {
//				 detailVOList  =  service.selectOrgSumDetail(billId);
//			}
//			for (OtherInviteDetailVO otherInviteDetailVO : detailVOList) {
//				otherInviteDetailVO.setNum(otherInviteDetailVO.getSumNum());
//				otherInviteDetailVO.setMoney(otherInviteDetailVO.getSumMoney());
//				otherInviteDetailVO.setMoneyTax(otherInviteDetailVO.getSumMoneyTax());
//				detailService.saveOrUpdate(BeanMapper.map(otherInviteDetailVO, OtherInviteDetailEntity.class));
//			}
			List<OtherInviteDetailRecordEntity> otherDetailRecord = inviteEntity.getOtherDetailRecord();
			for (OtherInviteDetailRecordEntity detailRecordEntity : otherDetailRecord) {
				detailService.saveOrUpdate(BeanMapper.map(detailRecordEntity, OtherInviteDetailEntity.class));
			}
			List<OtherInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
			String tenderUnitNum = "";
			for (OtherInviteDetailBidderVO detailBidderVO : detailBidderList) {
				OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = new OtherPicketageRefsupplierEntity();
				otherPicketageRefsupplierEntity.setPicketageId(billId);
				otherPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
				otherPicketageRefsupplierEntity.setPicketageDate(new Date());
				otherPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
				otherPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
				otherPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
				otherPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
//				otherPicketageRefsupplierEntity.setProjectId(detailBidderVO.getProjectId());
//				otherPicketageRefsupplierEntity.setProjectName(detailBidderVO.getProjectName());
//				otherPicketageRefsupplierEntity.setOrgId(detailBidderVO.getOrgId());
//				otherPicketageRefsupplierEntity.setOrgName(detailBidderVO.getOrgName());
				//暂时使用主表
				otherPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
				otherPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
				otherPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
				otherPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
				otherPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
				otherPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
				otherPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
				otherPicketageRefsupplierEntity.setOccupyFlag(0);
				otherPicketageRefsupplierEntity.setPicketageFlag(1);
				otherPicketageRefsupplierEntity.setSignStatus(0);
				otherPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
				picketageRefsupplierService.saveOrUpdate(otherPicketageRefsupplierEntity);
				BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
				tenderUnitNum+=detailBidderVO.getSupplierName()+"("+sumNum+"),";
			}
			if (tenderUnitNum.length() > 1) {
				tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
			}
			inviteEntity.setTenderUnitNum(tenderUnitNum);
			service.saveOrUpdate(inviteEntity);
			if(inviteEntity.getEstablishType() == 0){
				//招标立项
				//发送首席消息
				CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(inviteEntity.getProjectId());
				if(commonResponse.isSuccess()){
					JSONArray array = commonResponse.getData();
					List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);
					ProjectPoolSetVO vo = vos.get(0);
					Long costAdapter = vo.getCostAdapter();
					messageService.sendSys(
							"其他招标："+inviteEntity.getTenderName()+"已完成立项!",
							inviteEntity.getId(),
							costAdapter+"",
							"other%2finvite%2fcard"
					);
				}

			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<OtherPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<OtherPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (OtherPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<OtherInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInviteEntity inviteEntity = service.selectById(billId);

		//采购计划修改
		if (inviteEntity.getEstablishType() == 1) {
			// 获取采购计划ID
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
				List<String> planIdList = inviteEntity.getOtherDetailRecord().stream()
						.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
						.collect(Collectors.toList());
				// 释放采购计划
				otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),1);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			OtherInviteEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}

}
