package com.ejianc.business.tender.prosub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubDocumentSchemeMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubPicketageMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.mapper.SubDocumentSchemeMapper;
import com.ejianc.business.tender.sub.mapper.SubPicketageMapper;
import com.ejianc.business.tender.sub.vo.*;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 定标主表
 * 
 * @author generator
 * 
 */
@Service("prosubPicketageService")
public class ProsubPicketageServiceImpl extends BaseServiceImpl<ProsubPicketageMapper, ProsubPicketageEntity> implements IProsubPicketageService {
    private static final String BILL_CODE = "PROSUB_PICKETAGE_CODE";//此处需要根据实际修改

    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IProsubInviteService subInviteService;
    @Autowired
    private IProsubDocumentService subDocumentService;
    @Autowired
    private IProsubDocumentSellService subDocumentSellService;
    @Autowired
    private IProsubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private IProsubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ProsubDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IProsubTalkService subTalkService;
    @Autowired
    private IProsubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public ProsubPicketageVO savePicketage(Long evaluationId) {

        ProsubPicketageEntity entity = new ProsubPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //转换数据
        ExpertEvaluatingEntity subEvaluationEntity = IExpertEvaluatingService.selectById(evaluationId);
        ProsubInviteEntity inviteEntity = subInviteService.selectById(subEvaluationEntity.getInviteId());
        ProsubDocumentEntity subDocumentEntity = subDocumentService.selectById(subEvaluationEntity.getDocumentId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setDocumentId(subEvaluationEntity.getDocumentId());
        entity.setEvaluationId(subEvaluationEntity.getId());
        entity.setInviteId(subEvaluationEntity.getInviteId());
        entity.setGatherReason(subEvaluationEntity.getGatherReason());//汇总原因
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
//材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(6));

        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());

        super.saveOrUpdate(entity, false);
        ProsubPicketageVO vo = BeanMapper.map(entity, ProsubPicketageVO.class);

        //回写招标阶段
        subInviteEntity.setTenderStage(5);
        subInviteService.updateById(subInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/picketage");
        processService.saveOrUpdate(processEntity);

        //回写方案得分
        List<ProsubDocumentSchemeEntity> schemeList = schemeMapper.selectSupplier(subDocumentEntity.getId());
        for (ProsubDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score  = recordMapper.selectScore(schemeEntity.getId(),schemeEntity.getSupplierId(),subDocumentEntity.getId());
            Boolean scoreBoolean = schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), subDocumentEntity.getId(), score);
            if (!scoreBoolean){
                throw new BusinessException("回写方案得分失败!");
            }
        }
        return vo;
    }
    @Transactional
    @Override
    public ProsubPicketageVO queryDetail(Long id) {
        ProsubPicketageEntity subPicketageEntity = super.selectById(id);
        //查询最大轮数
        LambdaQueryWrapper<ProsubDocumentSupplierEntity> lambdaSupplier = Wrappers.<ProsubDocumentSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubDocumentSupplierEntity::getDocumentId, subPicketageEntity.getDocumentId());
        List<ProsubDocumentSupplierEntity> supplierEntityList = subDocumentSupplierService.list(lambdaSupplier);
        List<Integer> talkNumList = supplierEntityList.stream().map(ProsubDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = talkNumList.stream().max(Integer::compareTo).get();


        ProsubDocumentEntity entity = subDocumentService.selectById(subPicketageEntity.getDocumentId());
        ProsubDocumentVO subDocumentVO = BeanMapper.map(entity, ProsubDocumentVO.class);
        //按材料查看报价
        List<ProsubDocumentDetailVO> subDocumentDetailList = subDocumentVO.getSubDocumentDetailList();
        //获取材料明细报价
        LambdaQueryWrapper<ProsubDocumentSellEntity> lambdaSell = Wrappers.<ProsubDocumentSellEntity>lambdaQuery();
        lambdaSell.eq(ProsubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaSell.eq(ProsubDocumentSellEntity::getTalkNum, talkNumMax);
        lambdaSell.eq(ProsubDocumentSellEntity::getPassFlag, 1);
        lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(ProsubDocumentSellEntity::getSchemeName);
        List<ProsubDocumentSellEntity> sellList = subDocumentSellService.list(lambdaSell);
        List<ProsubDocumentSellVO> subDocumentSellVOS = BeanMapper.mapList(sellList, ProsubDocumentSellVO.class);
        //查询所有方案
        LambdaQueryWrapper<ProsubDocumentSchemeEntity> lambdaScheme = Wrappers.<ProsubDocumentSchemeEntity>lambdaQuery();
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getDocumentId, subPicketageEntity.getDocumentId());
        lambdaScheme.eq(ProsubDocumentSchemeEntity::getTalkNum, talkNumMax);
        lambdaScheme.orderByAsc(ProsubDocumentSchemeEntity::getSchemeName);
        List<ProsubDocumentSchemeEntity> schemeList = subDocumentSchemeService.list(lambdaScheme);
        for (ProsubDocumentSchemeEntity subDocumentSchemeEntity : schemeList){
            for (ProsubDocumentSellVO subDocumentSellVO : subDocumentSellVOS){
                if (subDocumentSellVO.getSchemeId().equals(subDocumentSchemeEntity.getId())){
                    subDocumentSellVO.setScore(subDocumentSchemeEntity.getScore());
                }

            }

        }

        //排序
        ProsubDocumentSellVO subDocumentSellFirst = subDocumentSellVOS.stream().findFirst().get();
        if (subDocumentSellFirst.getScore() == null){
            subDocumentSellVOS.sort(Comparator.comparing(ProsubDocumentSellVO::getCreateTime).reversed());
        }
        if (subDocumentSellFirst.getScore() != null){
            subDocumentSellVOS.sort(Comparator.comparing(ProsubDocumentSellVO::getScore).reversed());
        }
        //根据物料详情主键分组
        Map<Long, List<ProsubDocumentSellVO>> sellMap = subDocumentSellVOS.stream().
                collect(Collectors.groupingBy(ProsubDocumentSellVO::getDetailId));
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            List<ProsubDocumentSellVO> subDocumentSellEntities = sellMap.get(subDocumentDetailVO.getId());
            subDocumentDetailVO.setProsubDocumentSellVOList(subDocumentSellEntities);
        }

        ProsubPicketageVO subPicketageVO = BeanMapper.map(subPicketageEntity, ProsubPicketageVO.class);
        subPicketageVO.setSubDocumentDetailList(subDocumentDetailList);
        if (subDocumentSellFirst.getScore() == null) {
            subPicketageVO.setScoreStatus(1);
        }
        if (subDocumentSellFirst.getScore() != null) {
            subPicketageVO.setScoreStatus(0);
        }
        
        return subPicketageVO;

    }

    @Override
    public ProsubPicketageVO saveOrUpdates(ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageEntity entity = BeanMapper.map(saveorUpdateVO, ProsubPicketageEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List<ProsubPicketageSupplierVO> picketageSupplierListMoney = saveorUpdateVO.getPicketageSupplierList();
        for(ProsubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierListMoney){
            money = money.add(subPicketageSupplierVO.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierVO.getMoneyTax());
        }
        entity.setMoneyTax(moneyTax);
        entity.setMoney(money);
        super.saveOrUpdate(entity,false);

        //先删后增供应商定标数据
        LambdaQueryWrapper<ProsubPicketageSupplierEntity> lambdaSupplier = Wrappers.<ProsubPicketageSupplierEntity>lambdaQuery();
        lambdaSupplier.eq(ProsubPicketageSupplierEntity::getPicketageId,entity.getId());
        subPicketageSupplierService.remove(lambdaSupplier);
        List<ProsubPicketageSupplierVO> picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();

        for(ProsubPicketageSupplierVO subPicketageSupplierVO : picketageSupplierList){
            subPicketageSupplierVO.setTenderFlag(0);
        }

        List<ProsubPicketageSupplierEntity> subPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, ProsubPicketageSupplierEntity.class);
        subPicketageSupplierService.saveBatch(subPicketageSupplierList);

        //更新中标信息
        List<ProsubDocumentDetailVO> subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList<ProsubDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            documentSellVOArrayList.addAll(subDocumentDetailVO.getProsubDocumentSellVOList());
        }
        List<ProsubDocumentSellEntity> subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, ProsubDocumentSellEntity.class);
        subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        ProsubPicketageVO subPicketageVO = queryDetail(saveorUpdateVO.getId());
        return subPicketageVO;
    }

    @Override
    public ProsubPicketageVO saveManyPicketage(Long documentId) {
        ProsubPicketageEntity entity = new ProsubPicketageEntity();

        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //更新状态
        ProsubDocumentEntity documentEntity = subDocumentService.selectById(documentId);
        documentEntity.setNextFlag(0);
        subDocumentService.saveOrUpdate(documentEntity);

        //更新洽商谈判状态
        LambdaQueryWrapper<ProsubTalkEntity> lambdaTalk = Wrappers.<ProsubTalkEntity>lambdaQuery();
        lambdaTalk.eq(ProsubTalkEntity::getBillId, documentId);
        ProsubTalkEntity subTalkEntity = subTalkService.getOne(lambdaTalk);
        if (subTalkEntity != null){
            subTalkEntity.setNextFlag(0);
            subTalkService.updateById(subTalkEntity);
        }

        //转换数据
        ProsubDocumentEntity subDocumentEntity = subDocumentService.selectById(documentId);
        ProsubInviteEntity inviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setPicketageName(inviteEntity.getTenderName()+"定标");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(subDocumentEntity.getEmployeeId());
        entity.setEmployeeName(subDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(subDocumentEntity.getEmployeeMobile());
        entity.setValueType(subDocumentEntity.getValueType());
        ProsubInviteEntity subInviteEntity = subInviteService.selectById(subDocumentEntity.getInviteId());
        entity.setDocumentId(documentId);
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(sessionManager.getUserContext().getEmployeeName());
        //材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode(inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate(entity, false);
        ProsubPicketageVO vo = BeanMapper.map(entity, ProsubPicketageVO.class);

        //回写招标阶段
        subInviteEntity.setTenderStage(5);
        subInviteService.updateById(subInviteEntity);
        //回写进展表
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("定标");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(6);
        processEntity.setFrontendUrl("prosub/picketage");
        processService.saveOrUpdate(processEntity);
        return vo;
    }

    @Override
    public List<ProsubPicketageSupplierVO> querySupplierList(Long picketageId) {
        ProsubPicketageEntity subPicketageEntity = super.selectById(picketageId);
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        List<ProsubPicketageSupplierVO> list = BeanMapper.mapList(picketageSupplierList, ProsubPicketageSupplierVO.class);

        return list;
    }
    @Override
    public ProsubPicketageVO saveSupplierBatch(ProsubPicketageVO saveorUpdateVO) {
        ProsubPicketageEntity subPicketageEntity = super.selectById(saveorUpdateVO.getId());
        List<ProsubPicketageSupplierEntity> picketageSupplierList = subPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)){
            return queryDetail(saveorUpdateVO.getId());
        }

        BigDecimal money = BigDecimal.ZERO;
        BigDecimal moneyTax = BigDecimal.ZERO;
        List<ProsubPicketageSupplierEntity> subPicketageSupplierEntities = BeanMapper.mapList(saveorUpdateVO.getPicketageSupplierList(), ProsubPicketageSupplierEntity.class);
        for (ProsubPicketageSupplierEntity subPicketageSupplierEntity : subPicketageSupplierEntities){
            subPicketageSupplierEntity.setTenderFlag(0);
            money = money.add(subPicketageSupplierEntity.getMoney());
            moneyTax = moneyTax.add(subPicketageSupplierEntity.getMoneyTax());
        }
        subPicketageSupplierService.saveBatch(subPicketageSupplierEntities);

        //更新主表中标总额字段
        subPicketageEntity.setMoney(money);
        subPicketageEntity.setMoneyTax(moneyTax);
        super.updateById(subPicketageEntity);

        //更新中标信息
        List<ProsubDocumentDetailVO> subDocumentDetailList = saveorUpdateVO.getSubDocumentDetailList();
        ArrayList<ProsubDocumentSellVO> documentSellVOArrayList = new ArrayList<>();
//
        for (ProsubDocumentDetailVO subDocumentDetailVO : subDocumentDetailList){
            documentSellVOArrayList.addAll(subDocumentDetailVO.getProsubDocumentSellVOList());
        }
        List<ProsubDocumentSellEntity> subDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList,ProsubDocumentSellEntity.class);
        subDocumentSellService.saveOrUpdateBatch(subDocumentSellEntityList);
        return  queryDetail(saveorUpdateVO.getId());
    }


}
