package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.material.api.IMaterialBatchPlanApi;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.stuff.bean.*;
import com.ejianc.business.tender.stuff.service.*;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailBidderVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.SubDocumentSellEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("stuffInvite")
public class StuffInviteBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMessageService messageService;

    @Autowired
    private IStuffInviteService service;

    @Autowired
    private IStuffInviteDetailService detailService;

    @Autowired
    private IStuffInviteDetailRecordService recordService;

    @Autowired
    private IStuffPicketageRefsupplierService picketageRefsupplierService;

    @Autowired
    private IBatPlanApi batPlanApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMaterialBatchPlanApi materialBatchPlanApi;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
            StuffInviteEntity inviteEntity = service.selectById(billId);
            List<StuffInviteDetailVO> detailVOList = new ArrayList<>();
            if (inviteEntity.getPurchaseType() == 0) {
                detailVOList = service.selectSumDetail(billId);
            }
            else {
                detailVOList = service.selectOrgSumDetail(billId);
            }
            for (StuffInviteDetailVO stuffInviteDetailVO : detailVOList) {
                stuffInviteDetailVO.setNum(stuffInviteDetailVO.getSumNum());
                stuffInviteDetailVO.setMoney(stuffInviteDetailVO.getSumMoney());
                stuffInviteDetailVO.setMoneyTax(stuffInviteDetailVO.getSumMoneyTax());
                stuffInviteDetailVO.setMemo(stuffInviteDetailVO.getSumMemo());
                stuffInviteDetailVO.setPlanNum(stuffInviteDetailVO.getSumPlanNum());
                detailService.saveOrUpdate(BeanMapper.map(stuffInviteDetailVO, StuffInviteDetailEntity.class));
            }

            if (inviteEntity.getEstablishType() == 1) {
                // 获取采购计划ID
                if (CollectionUtils.isNotEmpty(inviteEntity.getStuffDetailRecord())) {
                    List<String> planIdList = inviteEntity.getStuffDetailRecord().stream()
                            .map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
                            .collect(Collectors.toList());
                    // 释放采购计划
                    //if (inviteEntity.getPurchaseType() == 0 ){
                        CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),1);
                        if (!response.isSuccess()) {
                            throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                        }
//                    }else {
//                        CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState());
//                        if (!response.isSuccess()) {
//                            throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//                        }
//                    }
                }
            }
            String tenderUnitNum = "";
            //如果是招标立项没有数据,定标立项会有数据
            List<StuffInviteDetailBidderVO> detailBidderList = service.selectDetailBidder(billId);
            for (StuffInviteDetailBidderVO detailBidderVO : detailBidderList) {
                StuffPicketageRefsupplierEntity stuffPicketageRefsupplierEntity = new StuffPicketageRefsupplierEntity();
                stuffPicketageRefsupplierEntity.setPicketageId(billId);
                stuffPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName() + "定标");
                stuffPicketageRefsupplierEntity.setPicketageDate(new Date());
                stuffPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
                stuffPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
                stuffPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
                stuffPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
                //暂时使用主表
                stuffPicketageRefsupplierEntity.setProjectId(detailBidderVO.getDetailProjectId());
                stuffPicketageRefsupplierEntity.setProjectName(detailBidderVO.getDetailProjectName());
                //如果是项目招标，子表orgId为项目部id
                if (inviteEntity.getPurchaseType() == 0) {
                    Map<Long, ProjectPoolSetVO> proMap = new HashMap<>();
                    CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectByIds(Collections.singletonList(detailBidderVO.getDetailProjectId()));
                    if (jsonArrayCommonResponse.isSuccess()) {
                        JSONArray data = jsonArrayCommonResponse.getData();
                        List<ProjectPoolSetVO> projectRegisterVOS = data.toJavaList(ProjectPoolSetVO.class);
                        proMap = projectRegisterVOS.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, Function.identity()));
                        ProjectPoolSetVO projectPoolSetVO = proMap.get(detailBidderVO.getDetailProjectId());
                        if (projectPoolSetVO != null) {
                            stuffPicketageRefsupplierEntity.setOrgId(projectPoolSetVO.getProjectDepartmentId());
                            stuffPicketageRefsupplierEntity.setOrgName(projectPoolSetVO.getProjectDepartmentName());
                        }
                    }
                }
                else {
                    stuffPicketageRefsupplierEntity.setOrgId(detailBidderVO.getDetailOrgId());
                    stuffPicketageRefsupplierEntity.setOrgName(detailBidderVO.getDetailOrgName());
                }
                stuffPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
                stuffPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
                stuffPicketageRefsupplierEntity.setOccupyFlag(0);
                stuffPicketageRefsupplierEntity.setPicketageFlag(1);
                stuffPicketageRefsupplierEntity.setSignStatus(0);
                stuffPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
                picketageRefsupplierService.saveOrUpdate(stuffPicketageRefsupplierEntity);
                BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4, BigDecimal.ROUND_HALF_UP);
                tenderUnitNum += detailBidderVO.getSupplierName() + "(" + sumNum + "),";
            }
            if (tenderUnitNum.length() > 1) {
                tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
            }
            inviteEntity.setTenderUnitNum(tenderUnitNum);
            service.saveOrUpdate(inviteEntity);

            if(inviteEntity.getEstablishType() == 0){
                //招标立项
                //发送首席消息
                CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(inviteEntity.getProjectId());
                if(commonResponse.isSuccess()){
                    JSONArray array = commonResponse.getData();
                    List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);
                    ProjectPoolSetVO vo = vos.get(0);
                    Long costAdapter = vo.getCostAdapter();
                    messageService.sendSys(
                            "材料招标："+inviteEntity.getTenderName()+"已完成立项!",
                            inviteEntity.getId(),
                            costAdapter+"",
                            "stuff%2finvite%2fcard"
                    );
                }

            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        StuffInviteEntity inviteEntity = service.selectById(billId);
        if (inviteEntity.getOccupyState() != null && inviteEntity.getOccupyState() == 1) {
            return CommonResponse.error("招标已被占用,不能撤回!");
        }

        if (inviteEntity.getTenderStage() > 1) {
            return CommonResponse.error("招标处于" + TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription() + ",不能撤回!");
        }
        if (inviteEntity.getEstablishType() == 1) {
            QueryWrapper<StuffPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
            refWrapper.eq("picketage_id", inviteEntity.getId());
            List<StuffPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
            for (StuffPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
                if (refsupplierEntity.getSignStatus() != 0) {
                    return CommonResponse.error("存在已签订合同,不能撤回!");
                }
            }
            picketageRefsupplierService.remove(refWrapper);
        }
        detailService.delByInviteId(inviteEntity.getId());
//        QueryWrapper<StuffInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//        detailWrapper.eq("invite_id",inviteEntity.getId());
//        detailService.remove(detailWrapper);
        return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        StuffInviteEntity inviteEntity = service.selectById(billId);
        if (inviteEntity.getEstablishType() == 1) {
            // 获取采购计划ID
            if (CollectionUtils.isNotEmpty(inviteEntity.getStuffDetailRecord())) {
                List<String> planIdList = inviteEntity.getStuffDetailRecord().stream()
                        .map(StuffInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
                        .collect(Collectors.toList());
                // 释放采购计划refStuffsupplierData
                //if (inviteEntity.getPurchaseType() == 0 ){
                    CommonResponse<String> response = batPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState(),1);
                    if (!response.isSuccess()) {
                        throw new BusinessException("修改批次计划状态失败" + response.getMsg());
                    }
//                }else {
//                    CommonResponse<String> response = materialBatchPlanApi.updateBatPlanQuote(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState());
//                    if (!response.isSuccess()) {
//                        throw new BusinessException("修改采购申请状态失败" + response.getMsg());
//                    }
//                }
            }
        }
        return CommonResponse.success();
    }
    /**
     * 审批--获取当前节点的审批人---从服务中选择
     *
     * @param billId 单据id
     * @param billTypeCode 单据类型编码
     * @param sign 节点标志
     * @return
     */
    @Override
    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
        JSONArray arr = new JSONArray();
        logger.info("sign:{}",sign);

        //根据标识判断是否（成本相关人员审批的）节点
        if ("choseCostUser".equals(sign)){
            //获取表单详情数据

            //根据项目id获取项目基本信息中的成本对接人信息
            StuffInviteEntity entity = service.selectById(billId);
            Long projectId = entity.getProjectId();

            JSONObject jsonObject = new JSONObject();
            CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


            if(!commonResponse.isSuccess()){
                throw new BusinessException("查询项目失败!");
            }
            JSONArray array = commonResponse.getData();
            List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

            logger.info("vos:{}",JSONObject.toJSONString(vos));

            ProjectPoolSetVO vo = vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();

            logger.info("userId:{}",costAdapter);
            logger.info("userName:{}",costAdapterName);


            jsonObject.put("userId",costAdapter);
            jsonObject.put("userName",costAdapterName);

            arr.add(jsonObject);

        }
        return CommonResponse.success(arr);
    }




}
