package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.common.service.IMessageService;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("subInvite") 
public class SubInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private ISubInviteService service;

	@Autowired
	private ISubInviteDetailService detailService;

	@Autowired
	private ISubPicketageRefsupplierService picketageRefsupplierService;
	@Autowired
	private IProjectPoolApi projectPoolApi;
	@Autowired
	private IMessageService messageService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Autowired
	private ISubBatPlanService subBatPlanService;
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			SubInviteEntity subInviteEntity = service.selectById(billId);
			List<SubInviteDetailVO> subInviteDetailEntities = new ArrayList<>();
			if (subInviteEntity.getPurchaseType() == 0) {
				subInviteDetailEntities = service.selectSumDetail(billId);
			}
			else {
				subInviteDetailEntities = service.selectOrgSumDetail(billId);
			}

			for (SubInviteDetailVO subInviteDetailEntity : subInviteDetailEntities) {
				subInviteDetailEntity.setNum(subInviteDetailEntity.getSumNum());
				subInviteDetailEntity.setMny(subInviteDetailEntity.getSumMoney());
				subInviteDetailEntity.setTaxMny(subInviteDetailEntity.getSumMoneyTax());
				subInviteDetailEntity.setPlanNum(subInviteDetailEntity.getSumPlanNum());
				subInviteDetailEntity.setTax(subInviteDetailEntity.getSumTax());
				subInviteDetailEntity.setMemo(subInviteDetailEntity.getSumMemo());
				detailService.saveOrUpdate(BeanMapper.map(subInviteDetailEntity, SubInviteDetailEntity.class));
			}
			//原计划数量赋值，采购计划修改
			if (subInviteEntity.getEstablishType() == 1) {
				// 获取采购计划ID
				if (org.apache.commons.collections.CollectionUtils.isNotEmpty(subInviteEntity.getSubDetailBidder())) {
					List<String> planIdList = subInviteEntity.getSubDetailBidder().stream()
							.map(SubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct()
							.collect(Collectors.toList());
					// 释放采购计划
					subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),0);
				}
			}

			//定标立项时直接生成定标结果参照数据
			SubInviteEntity inviteEntity = service.selectById(billId);
			if (CollectionUtils.isNotEmpty(inviteEntity.getSubDetailBidder())){
				List<SubInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
				String tenderUnitNum = "";
				for (SubInviteDetailBidderVO detailBidderVO : detailBidderList) {
					SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = new SubPicketageRefsupplierEntity();
					subPicketageRefsupplierEntity.setPicketageId(billId);
					subPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
					subPicketageRefsupplierEntity.setPicketageDate(new Date());
					subPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
					subPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
					subPicketageRefsupplierEntity.setSupplierId(inviteEntity.getSupplierId());
					subPicketageRefsupplierEntity.setSupplierName(inviteEntity.getSupplierName());
					if (inviteEntity.getTeamId()!= null){
						subPicketageRefsupplierEntity.setTeamId(inviteEntity.getTeamId());
						subPicketageRefsupplierEntity.setTeamCode(inviteEntity.getTeamCode());
						subPicketageRefsupplierEntity.setTeamName(inviteEntity.getTeamName());
					}
					subPicketageRefsupplierEntity.setSubContent(inviteEntity.getSubContent());//分包类别-》合同类别
					subPicketageRefsupplierEntity.setSubContentName(inviteEntity.getSubContentName());//分包类别-》合同类别名称
					//暂时使用主表
					subPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
					subPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
					subPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
					subPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
					subPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
					subPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
					subPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
					subPicketageRefsupplierEntity.setOccupyFlag(0);
					subPicketageRefsupplierEntity.setPicketageFlag(1);
					subPicketageRefsupplierEntity.setSignStatus(0);
					subPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
					picketageRefsupplierService.saveOrUpdate(subPicketageRefsupplierEntity);
					BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
					tenderUnitNum+=inviteEntity.getSupplierName()+"("+sumNum+"),";
				}
				if (tenderUnitNum.length() > 1) {
					tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
				}
				inviteEntity.setTenderUnitNum(tenderUnitNum);
				service.saveOrUpdate(inviteEntity);
				if(inviteEntity.getEstablishType() == 0){
					//招标立项
					//发送首席消息
					CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(inviteEntity.getProjectId());
					if(commonResponse.isSuccess()){
						JSONArray array = commonResponse.getData();
						List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);
						ProjectPoolSetVO vo = vos.get(0);
						Long costAdapter = vo.getCostAdapter();
						messageService.sendSys(
								"劳务招标："+inviteEntity.getTenderName()+"已完成立项!",
								inviteEntity.getId(),
								costAdapter+"",
								"sub%2finvite%2fcard"
						);
					}

				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<SubPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<SubPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (SubPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<SubInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//采购计划修改
		SubInviteEntity subInviteEntity = service.selectById(billId);
		if (subInviteEntity.getEstablishType() == 1) {
			// 获取采购计划ID
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(subInviteEntity.getSubDetailBidder())) {
				List<String> planIdList = subInviteEntity.getSubDetailBidder().stream()
						.map(SubInviteDetailBidderEntity::getPlanId).map(String::valueOf).distinct()
						.collect(Collectors.toList());
				// 释放采购计划
				subBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_EXEC.getPlanState(),1);
			}
		}
		return CommonResponse.success();
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			SubInviteEntity entity = service.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
