/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSchemeEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentPicketageSupplierEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentTalkEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSchemeMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentPicketageMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSchemeService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSellService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentService;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageService;
import com.ejianc.business.tender.equipment.service.IEquipmentPicketageSupplierService;
import com.ejianc.business.tender.equipment.service.IEquipmentTalkService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentDetailVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageSupplierVO;
import com.ejianc.business.tender.equipment.vo.EquipmentPicketageVO;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="equipmentPicketageService")
public class EquipmentPicketageServiceImpl
extends BaseServiceImpl<EquipmentPicketageMapper, EquipmentPicketageEntity>
implements IEquipmentPicketageService {
    private static final String BILL_CODE = "invite-picketage-code";
    @Autowired
    private IExpertEvaluatingService IExpertEvaluatingService;
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentDocumentService equipmentDocumentService;
    @Autowired
    private IEquipmentDocumentSellService equipmentDocumentSellService;
    @Autowired
    private IEquipmentDocumentSchemeService equipmentDocumentSchemeService;
    @Autowired
    private IEquipmentDocumentSupplierService equipmentDocumentSupplierService;
    @Autowired
    private EquipmentDocumentSchemeMapper schemeMapper;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IEquipmentTalkService equipmentTalkService;
    @Autowired
    private IEquipmentPicketageSupplierService equipmentPicketageSupplierService;
    @Autowired
    private ExpertRecordMapper recordMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public EquipmentPicketageVO savePicketage(Long evaluationId) {
        EquipmentPicketageEntity entity = new EquipmentPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ExpertEvaluatingEntity equipmentEvaluationEntity = (ExpertEvaluatingEntity)((Object)this.IExpertEvaluatingService.selectById(evaluationId));
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentEvaluationEntity.getInviteId()));
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(equipmentEvaluationEntity.getDocumentId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setValueType(equipmentDocumentEntity.getValueType());
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId()));
        entity.setPurchaseId(equipmentInviteEntity.getPurchaseId());
        entity.setPurchaseName(equipmentInviteEntity.getPurchaseName());
        entity.setDocumentId(equipmentEvaluationEntity.getDocumentId());
        entity.setEvaluationId(equipmentEvaluationEntity.getId());
        entity.setInviteId(equipmentEvaluationEntity.getInviteId());
        entity.setGatherReason(equipmentEvaluationEntity.getGatherReason());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        entity.setTrusteesPhone(mobilePhone);
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(2));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        EquipmentPicketageVO vo = (EquipmentPicketageVO)BeanMapper.map((Object)((Object)entity), EquipmentPicketageVO.class);
        equipmentInviteEntity.setTenderStage(5);
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        List<EquipmentDocumentSchemeEntity> schemeList = this.schemeMapper.selectSupplier(equipmentDocumentEntity.getId());
        for (EquipmentDocumentSchemeEntity schemeEntity : schemeList) {
            BigDecimal score = this.recordMapper.selectScore(schemeEntity.getId(), schemeEntity.getSupplierId(), equipmentDocumentEntity.getId());
            Boolean scoreBoolean = this.schemeMapper.updateScore(schemeEntity.getId(), schemeEntity.getSupplierId(), equipmentDocumentEntity.getId(), score);
            if (scoreBoolean.booleanValue()) continue;
            throw new BusinessException("\u56de\u5199\u65b9\u6848\u5f97\u5206\u5931\u8d25!");
        }
        return vo;
    }

    @Override
    @Transactional
    public EquipmentPicketageVO queryDetail(Long id) {
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)super.selectById((Serializable)id));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentDocumentSupplierEntity::getDocumentId, (Object)equipmentPicketageEntity.getDocumentId());
        List supplierEntityList = this.equipmentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        List talkNumList = supplierEntityList.stream().map(EquipmentDocumentSupplierEntity::getTalkNum).collect(Collectors.toList());
        Integer talkNumMax = (Integer)talkNumList.stream().max(Integer::compareTo).get();
        EquipmentDocumentEntity entity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(equipmentPicketageEntity.getDocumentId()));
        EquipmentDocumentVO equipmentDocumentVO = (EquipmentDocumentVO)BeanMapper.map((Object)((Object)entity), EquipmentDocumentVO.class);
        List equipmentDocumentDetailList = equipmentDocumentVO.getEquipmentDocumentDetailList();
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(EquipmentDocumentSellEntity::getDocumentId, (Object)equipmentPicketageEntity.getDocumentId());
        lambdaSell.eq(EquipmentDocumentSellEntity::getTalkNum, (Object)talkNumMax);
        lambdaSell.eq(EquipmentDocumentSellEntity::getPassFlag, (Object)1);
        lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSupplierId);
        lambdaSell.orderByAsc(EquipmentDocumentSellEntity::getSchemeName);
        List sellList = this.equipmentDocumentSellService.list((Wrapper)lambdaSell);
        List equipmentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, EquipmentDocumentSellVO.class);
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getDocumentId, (Object)equipmentPicketageEntity.getDocumentId());
        lambdaScheme.eq(EquipmentDocumentSchemeEntity::getTalkNum, (Object)talkNumMax);
        lambdaScheme.orderByAsc(EquipmentDocumentSchemeEntity::getSchemeName);
        List schemeList = this.equipmentDocumentSchemeService.list((Wrapper)lambdaScheme);
        for (EquipmentDocumentSchemeEntity equipmentDocumentSchemeEntity : schemeList) {
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOS) {
                if (!equipmentDocumentSellVO.getSchemeId().equals(equipmentDocumentSchemeEntity.getId())) continue;
                equipmentDocumentSellVO.setScore(equipmentDocumentSchemeEntity.getScore());
            }
        }
        EquipmentDocumentSellVO equipmentDocumentSellFirst = (EquipmentDocumentSellVO)equipmentDocumentSellVOS.stream().findFirst().get();
        if (equipmentDocumentSellFirst.getScore() == null) {
            equipmentDocumentSellVOS.sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        }
        if (equipmentDocumentSellFirst.getScore() != null) {
            equipmentDocumentSellVOS.sort(Comparator.comparing(EquipmentDocumentSellVO::getScore).reversed());
        }
        Map<Long, List<EquipmentDocumentSellVO>> sellMap = equipmentDocumentSellVOS.stream().collect(Collectors.groupingBy(EquipmentDocumentSellVO::getDetailId));
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList) {
            List<EquipmentDocumentSellVO> equipmentDocumentSellEntities = sellMap.get(equipmentDocumentDetailVO.getId());
            equipmentDocumentDetailVO.setEquipmentDocumentSellVOList(equipmentDocumentSellEntities);
        }
        EquipmentPicketageVO equipmentPicketageVO = (EquipmentPicketageVO)BeanMapper.map((Object)((Object)equipmentPicketageEntity), EquipmentPicketageVO.class);
        equipmentPicketageVO.setEquipmentDocumentDetailList(equipmentDocumentDetailList);
        if (equipmentDocumentSellFirst.getScore() == null) {
            equipmentPicketageVO.setScoreStatus(Integer.valueOf(1));
        }
        if (equipmentDocumentSellFirst.getScore() != null) {
            equipmentPicketageVO.setScoreStatus(Integer.valueOf(0));
        }
        return equipmentPicketageVO;
    }

    @Override
    public EquipmentPicketageVO saveOrUpdates(EquipmentPicketageVO saveorUpdateVO) {
        EquipmentPicketageEntity entity = (EquipmentPicketageEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, EquipmentPicketageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(EquipmentPicketageSupplierEntity::getPicketageId, (Object)entity.getId());
        this.equipmentPicketageSupplierService.remove((Wrapper)lambdaSupplier);
        List picketageSupplierList = saveorUpdateVO.getPicketageSupplierList();
        for (EquipmentPicketageSupplierVO equipmentPicketageSupplierVO : picketageSupplierList) {
            equipmentPicketageSupplierVO.setTenderFlag(Integer.valueOf(0));
        }
        List equipmentPicketageSupplierList = BeanMapper.mapList((Iterable)picketageSupplierList, EquipmentPicketageSupplierEntity.class);
        this.equipmentPicketageSupplierService.saveBatch(equipmentPicketageSupplierList);
        List equipmentDocumentDetailList = saveorUpdateVO.getEquipmentDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList) {
            documentSellVOArrayList.addAll(equipmentDocumentDetailVO.getEquipmentDocumentSellVOList());
        }
        List equipmentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, EquipmentDocumentSellEntity.class);
        this.equipmentDocumentSellService.saveOrUpdateBatch(equipmentDocumentSellEntityList);
        EquipmentPicketageVO equipmentPicketageVO = this.queryDetail(saveorUpdateVO.getId());
        return equipmentPicketageVO;
    }

    @Override
    public EquipmentPicketageVO saveManyPicketage(Long documentId) {
        EquipmentPicketageEntity entity = new EquipmentPicketageEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        EquipmentDocumentEntity documentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.equipmentDocumentService.saveOrUpdate((Object)documentEntity);
        LambdaQueryWrapper lambdaTalk = Wrappers.lambdaQuery();
        lambdaTalk.eq(EquipmentTalkEntity::getBillId, (Object)documentId);
        EquipmentTalkEntity equipmentTalkEntity = (EquipmentTalkEntity)((Object)this.equipmentTalkService.getOne((Wrapper)lambdaTalk));
        if (equipmentTalkEntity != null) {
            equipmentTalkEntity.setNextFlag(0);
            this.equipmentTalkService.updateById((Object)equipmentTalkEntity);
        }
        EquipmentDocumentEntity equipmentDocumentEntity = (EquipmentDocumentEntity)((Object)this.equipmentDocumentService.selectById(documentId));
        EquipmentInviteEntity inviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId()));
        entity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
        entity.setEmployeeId(equipmentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(equipmentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(equipmentDocumentEntity.getEmployeeMobile());
        entity.setValueType(equipmentDocumentEntity.getValueType());
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentDocumentEntity.getInviteId()));
        entity.setPurchaseId(equipmentInviteEntity.getPurchaseId());
        entity.setPurchaseName(equipmentInviteEntity.getPurchaseName());
        entity.setPurchaseType(equipmentInviteEntity.getPurchaseType());
        entity.setDocumentId(documentId);
        entity.setInviteId(equipmentDocumentEntity.getInviteId());
        entity.setBidStatus(0);
        entity.setWinnoticeStatus(0);
        entity.setTrusteesId(this.sessionManager.getUserContext().getEmployeeId());
        entity.setTrusteesName(this.sessionManager.getUserContext().getEmployeeName());
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        entity.setLineTypeName(CommonUtils.getTypeName(0));
        entity.setOrgId(inviteEntity.getOrgId());
        entity.setOrgName(inviteEntity.getOrgName());
        entity.setParentOrgId(inviteEntity.getParentOrgId());
        entity.setParentOrgName(inviteEntity.getParentOrgName());
        entity.setProjectId(inviteEntity.getProjectId());
        entity.setProjectName(inviteEntity.getProjectName());
        entity.setPurchaseId(inviteEntity.getPurchaseId());
        entity.setPurchaseName(inviteEntity.getPurchaseName());
        entity.setUnitName(inviteEntity.getUnitName());
        super.saveOrUpdate((Object)entity, false);
        EquipmentPicketageVO vo = (EquipmentPicketageVO)BeanMapper.map((Object)((Object)entity), EquipmentPicketageVO.class);
        equipmentInviteEntity.setTenderStage(5);
        this.equipmentInviteService.updateById((Object)equipmentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u5b9a\u6807");
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(2);
        processEntity.setFrontendUrl("equipment/picketage");
        this.processService.saveOrUpdate((Object)processEntity);
        return vo;
    }

    @Override
    public List<EquipmentPicketageSupplierVO> querySupplierList(Long picketageId) {
        EquipmentPicketageEntity equipmentPicketageEntity = (EquipmentPicketageEntity)((Object)super.selectById((Serializable)picketageId));
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = equipmentPicketageEntity.getPicketageSupplierList();
        List list = BeanMapper.mapList(picketageSupplierList, EquipmentPicketageSupplierVO.class);
        return list;
    }

    @Override
    public EquipmentPicketageVO saveSupplierBatch(EquipmentPicketageVO saveorUpdateVO) {
        EquipmentPicketageEntity stuffPicketageEntity = (EquipmentPicketageEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        List<EquipmentPicketageSupplierEntity> picketageSupplierList = stuffPicketageEntity.getPicketageSupplierList();
        if (CollectionUtils.isNotEmpty(picketageSupplierList)) {
            return this.queryDetail(saveorUpdateVO.getId());
        }
        List equipmentPicketageSupplierEntities = BeanMapper.mapList((Iterable)saveorUpdateVO.getPicketageSupplierList(), EquipmentPicketageSupplierEntity.class);
        for (EquipmentPicketageSupplierEntity equipmentPicketageSupplierEntity : equipmentPicketageSupplierEntities) {
            equipmentPicketageSupplierEntity.setTenderFlag(0);
        }
        this.equipmentPicketageSupplierService.saveBatch(equipmentPicketageSupplierEntities);
        List equipmentDocumentDetailList = saveorUpdateVO.getEquipmentDocumentDetailList();
        ArrayList documentSellVOArrayList = new ArrayList();
        for (EquipmentDocumentDetailVO equipmentDocumentDetailVO : equipmentDocumentDetailList) {
            documentSellVOArrayList.addAll(equipmentDocumentDetailVO.getEquipmentDocumentSellVOList());
        }
        List equipmentDocumentSellEntityList = BeanMapper.mapList(documentSellVOArrayList, EquipmentDocumentSellEntity.class);
        this.equipmentDocumentSellService.saveOrUpdateBatch(equipmentDocumentSellEntityList);
        return this.queryDetail(saveorUpdateVO.getId());
    }
}

