/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.stuff.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.bean.StuffDocumentEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSchemeEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSupplierEntity;
import com.ejianc.business.tender.stuff.bean.StuffInviteEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkRecordDetailEntity;
import com.ejianc.business.tender.stuff.bean.StuffTalkRecordEntity;
import com.ejianc.business.tender.stuff.mapper.StuffTalkMapper;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSchemeService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSellService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentSupplierService;
import com.ejianc.business.tender.stuff.service.IStuffInviteService;
import com.ejianc.business.tender.stuff.service.IStuffTalkDetailService;
import com.ejianc.business.tender.stuff.service.IStuffTalkRecordDetailService;
import com.ejianc.business.tender.stuff.service.IStuffTalkRecordService;
import com.ejianc.business.tender.stuff.service.IStuffTalkService;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSellVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierTbVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.stuff.vo.StuffQuotationMaterialVO;
import com.ejianc.business.tender.stuff.vo.StuffQuotationSchemeVO;
import com.ejianc.business.tender.stuff.vo.StuffQuotationSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffTalkDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffTalkRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffTalkVO;
import com.ejianc.business.tender.stuff.vo.SupplierReplenishVO;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="stuffTalkService")
public class StuffTalkServiceImpl
extends BaseServiceImpl<StuffTalkMapper, StuffTalkEntity>
implements IStuffTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private IStuffTalkDetailService stuffTalkDetailService;
    @Autowired
    private IStuffTalkRecordService stuffTalkRecordService;
    @Autowired
    private IStuffTalkRecordDetailService stuffTalkRecordDetailService;
    @Autowired
    private IStuffDocumentSellService stuffDocumentSellService;
    @Autowired
    private IStuffDocumentService stuffDocumentService;
    @Autowired
    private IStuffInviteService stuffInviteService;
    @Autowired
    private IStuffDocumentSupplierService stuffDocumentSupplierService;
    @Autowired
    private IStuffDocumentSchemeService stuffDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_SUPPLIER_TYPE = "BT202202000004";
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public StuffTalkVO publishTalk(Long id) {
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)id));
        stuffTalkEntity.setPublishFlag(0);
        super.updateById((Object)stuffTalkEntity);
        StuffDocumentSupplierTbVO stuffDocumentSupplierTbVO = new StuffDocumentSupplierTbVO();
        stuffDocumentSupplierTbVO.setSourceId(stuffTalkEntity.getInviteId().toString());
        stuffDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        stuffDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(stuffTalkEntity.getTalkStartTime());
        stuffDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(stuffTalkEntity.getTalkEndTime());
        stuffDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        stuffDocumentSupplierTbVO.setMemo(stuffTalkEntity.getMemo());
        stuffDocumentSupplierTbVO.setTalkMoney(stuffTalkEntity.getTalkMoney());
        stuffDocumentSupplierTbVO.setTalkNum(stuffTalkEntity.getTalkNum());
        stuffDocumentSupplierTbVO.setTenderName(stuffTalkEntity.getTalkName());
        stuffDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)stuffDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public StuffTalkVO extendTalk(StuffTalkDetailVO stuffTalkDetailVO) {
        StuffTalkDetailEntity stuffDocumentRecordEntity = (StuffTalkDetailEntity)((Object)BeanMapper.map((Object)stuffTalkDetailVO, StuffTalkDetailEntity.class));
        this.stuffTalkDetailService.save((Object)stuffDocumentRecordEntity);
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)stuffTalkDetailVO.getTalkId()));
        stuffTalkEntity.setTalkEndTime(stuffTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)stuffTalkEntity);
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(stuffTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(stuffTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(stuffTalkDetailVO.getTalkId());
    }

    @Override
    public StuffTalkVO saveTalk(Long documentId) {
        StuffTalkEntity entity = new StuffTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StuffDocumentEntity documentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.stuffDocumentService.saveOrUpdate((Object)documentEntity);
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(documentId));
        StuffInviteEntity stuffInviteEntity = (StuffInviteEntity)((Object)this.stuffInviteService.selectById(stuffDocumentEntity.getInviteId()));
        entity.setProjectCode(stuffDocumentEntity.getProjectCode());
        entity.setInviteId(stuffDocumentEntity.getInviteId());
        entity.setProjectId(stuffDocumentEntity.getProjectId());
        entity.setProjectName(stuffDocumentEntity.getProjectName());
        entity.setOrgId(stuffDocumentEntity.getOrgId());
        entity.setOrgName(stuffDocumentEntity.getOrgName());
        entity.setParentOrgId(stuffDocumentEntity.getParentOrgId());
        entity.setParentOrgName(stuffDocumentEntity.getParentOrgName());
        entity.setBrandFlag(stuffDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(stuffDocumentEntity.getPurchaseType());
        entity.setTalkName(stuffInviteEntity.getTenderName());
        entity.setFloatingType(stuffDocumentEntity.getFloatingType());
        super.save((Object)entity);
        stuffInviteEntity.setTenderStage(7);
        this.stuffInviteService.updateById((Object)stuffInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(stuffDocumentEntity.getInviteId());
        processEntity.setType(0);
        processEntity.setFrontendUrl("stuff/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        StuffTalkVO vo = (StuffTalkVO)BeanMapper.map((Object)((Object)entity), StuffTalkVO.class);
        StuffTalkVO stuffTalkVO = this.queryDetail(vo.getId());
        return stuffTalkVO;
    }

    @Override
    public StuffTalkVO queryDetail(Long id) {
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)id));
        StuffTalkVO stuffTalkVO = (StuffTalkVO)BeanMapper.map((Object)((Object)stuffTalkEntity), StuffTalkVO.class);
        Integer talkNum = stuffTalkEntity.getTalkNum();
        this.logger.info("------------------------------------------\u67e5\u8be2\u8f6e\u65701-------------------------------------" + talkNum);
        if (stuffTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        this.logger.info("------------------------------------------\u67e5\u8be2\u8f6e\u65702-------------------------------------" + talkNum);
        StuffDocumentVO stuffDocumentVO = this.stuffDocumentService.queryDocDetailTalk(stuffTalkEntity.getBillId(), talkNum);
        stuffTalkVO.setStuffDocumentDetailSellList(stuffDocumentVO.getStuffDocumentDetailSellList());
        stuffTalkVO.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getStuffDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)stuffTalkEntity.getBillId());
        lambda.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.stuffDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, StuffDocumentSupplierVO.class);
        stuffTalkVO.setStuffDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(StuffTalkRecordEntity::getBillId, (Object)stuffTalkEntity.getBillId());
        lambdaRecord.orderByAsc(StuffTalkRecordEntity::getTalkNum);
        List stuffTalkRecordEntityList = this.stuffTalkRecordService.list((Wrapper)lambdaRecord);
        List stuffTalkRecordList = BeanMapper.mapList((Iterable)stuffTalkRecordEntityList, StuffTalkRecordVO.class);
        stuffTalkVO.setTalkRecordEntityList(stuffTalkRecordList);
        return stuffTalkVO;
    }

    @Override
    @Transactional
    public StuffTalkVO againSaveTalk(Long id) {
        StuffTalkEntity entity = new StuffTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(stuffTalkEntity.getProjectCode());
        entity.setProjectId(stuffTalkEntity.getProjectId());
        entity.setProjectName(stuffTalkEntity.getProjectName());
        entity.setOrgId(stuffTalkEntity.getOrgId());
        entity.setOrgName(stuffTalkEntity.getOrgName());
        entity.setParentOrgId(stuffTalkEntity.getParentOrgId());
        entity.setParentOrgName(stuffTalkEntity.getParentOrgName());
        entity.setBrandFlag(stuffTalkEntity.getBrandFlag());
        entity.setBillId(stuffTalkEntity.getBillId());
        entity.setInviteId(stuffTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(stuffTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(stuffTalkEntity.getPurchaseType());
        super.save((Object)entity);
        StuffTalkRecordEntity stuffTalkRecordEntity = (StuffTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)stuffTalkEntity), StuffTalkRecordEntity.class));
        stuffTalkRecordEntity.setTalkId(stuffTalkEntity.getId());
        stuffTalkRecordEntity.setId(null);
        this.stuffTalkRecordService.save((Object)stuffTalkRecordEntity);
        List<StuffTalkDetailEntity> stuffTalkDetailList = stuffTalkEntity.getStuffTalkDetailList();
        List stuffTalkRecordDetailEntityList = BeanMapper.mapList(stuffTalkDetailList, StuffTalkRecordDetailEntity.class);
        for (StuffTalkRecordDetailEntity stuffTalkRecordDetailEntity : stuffTalkRecordDetailEntityList) {
            stuffTalkRecordDetailEntity.setId(null);
            stuffTalkRecordDetailEntity.setRecordId(stuffTalkRecordEntity.getId());
        }
        this.stuffTalkRecordDetailService.saveBatch(stuffTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)stuffTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        StuffTalkVO vo = (StuffTalkVO)BeanMapper.map((Object)((Object)entity), StuffTalkVO.class);
        this.addLastSell(stuffTalkEntity.getTalkNum(), stuffTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public StuffTalkVO replenishSell(Long id) {
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = stuffTalkEntity.getTalkNum();
        Long billId = stuffTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new StuffTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = stuffTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)stuffTalkEntity.getBillId());
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)stuffTalkEntity.getBillId());
        lambdaSupplierFirst.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        StuffTalkEntity stuffTalkEntity = (StuffTalkEntity)((Object)((StuffTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<StuffQuotationMaterialVO> materialVOList = new ArrayList<StuffQuotationMaterialVO>();
        List<StuffDocumentSellEntity> stuffDocumentSellEntities = this.stuffDocumentSellService.selectMaterialType(stuffTalkEntity.getBillId());
        Integer talkNum = stuffDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(stuffDocumentSellEntities, StuffDocumentSellVO.class);
        Map<Long, List<StuffDocumentSellVO>> collect = sellEntityList.stream().filter(map -> map.getProjectId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getProjectId));
        for (List<StuffDocumentSellVO> sellVOS : collect.values()) {
            Map<Long, List<StuffDocumentSellVO>> listMap = sellVOS.stream().filter(map -> map.getMaterialId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getMaterialId));
            for (Long materialTypeId : listMap.keySet()) {
                StuffQuotationMaterialVO materialVO = new StuffQuotationMaterialVO();
                List<StuffDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
                for (StuffDocumentSellVO sellVO : materialTypeList) {
                    materialVO = (StuffQuotationMaterialVO)BeanMapper.map((Object)sellVO, StuffQuotationMaterialVO.class);
                }
                List stuffQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, StuffQuotationSupplierVO.class);
                List supplierVOS = stuffQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<StuffQuotationSupplierVO>(Comparator.comparing(StuffQuotationSupplierVO::getSupplierId))), ArrayList::new));
                materialVO.setSupplierList(supplierVOS);
                Map<Long, List<StuffDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getSupplierId));
                for (StuffQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                    List<StuffDocumentSellVO> stuffDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                    for (StuffDocumentSellVO stuffDocumentSellVO : stuffDocumentSellVOS) {
                        supplierVO.setSupplierName(stuffDocumentSellVO.getSupplierName());
                    }
                    List stuffQuotationSchemeVOS = BeanMapper.mapList(stuffDocumentSellVOS, StuffQuotationSchemeVO.class);
                    List schemeVOS = stuffQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<StuffQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                    supplierVO.setSchemeList(schemeVOS);
                    Map<String, List<StuffDocumentSellVO>> schemeMap = stuffDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(StuffDocumentSellVO::getSchemeName));
                    for (StuffQuotationSchemeVO stuffQuotationSchemeVO : supplierVO.getSchemeList()) {
                        List<StuffDocumentSellVO> priceList = schemeMap.get(stuffQuotationSchemeVO.getSchemeName());
                        if (priceList.size() < talkNum + 1) {
                            StuffDocumentSellVO documentSellVO = new StuffDocumentSellVO();
                            documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                            documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                            documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                            documentSellVO.setTalkNum(talkNum);
                            priceList.add(0, documentSellVO);
                        }
                        stuffQuotationSchemeVO.setPriceList(priceList);
                    }
                }
                materialVOList.add(materialVO);
            }
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", stuffDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public StuffTalkVO saveOrUpdates(StuffTalkVO saveorUpdateVO) {
        StuffTalkEntity entity = (StuffTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, StuffTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        StuffTalkVO vo = (StuffTalkVO)BeanMapper.map((Object)((Object)entity), StuffTalkVO.class);
        StuffTalkVO stuffTalkVO = this.queryDetail(vo.getId());
        return stuffTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(StuffDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(StuffDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.stuffDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(StuffDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, StuffDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        StuffDocumentEntity stuffDocumentEntity = (StuffDocumentEntity)((Object)this.stuffDocumentService.selectById(docId));
        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(stuffDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            if (stuffDocumentSupplierEntity.getSupplierTenantId() != null) {
                supplierReplenishVO.setTenantId(Long.toString(stuffDocumentSupplierEntity.getSupplierTenantId()));
            }
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplierEntityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList) {
            stuffDocumentSupplierEntity.setId(IdWorker.getId());
            stuffDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.stuffDocumentSupplierService.saveBatch(documentSupplierEntityNewList);
        for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (Object stuffDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!(stuffDocumentSupplierEntity.getSupplierId() != null ? stuffDocumentSupplierEntity.getSupplierId().equals(((StuffDocumentSupplierEntity)((Object)stuffDocumentSupplierLastEntity)).getSupplierId()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(stuffDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", stuffDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess() : stuffDocumentSupplierEntity.getLinkMobile().equals(((StuffDocumentSupplierEntity)((Object)stuffDocumentSupplierLastEntity)).getLinkMobile()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(stuffDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", stuffDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess())) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(StuffDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(StuffDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(StuffDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.stuffDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList) {
            stuffDocumentSchemeEntity.setId(IdWorker.getId());
            stuffDocumentSchemeEntity.setTalkNum(talkNum);
            for (StuffDocumentSupplierEntity stuffDocumentSupplierEntity : documentSupplierEntityNewList) {
                if (stuffDocumentSchemeEntity.getIsMobile() != null) {
                    if (!stuffDocumentSchemeEntity.getSupplierId().equals(stuffDocumentSupplierEntity.getSupplierId())) continue;
                    stuffDocumentSchemeEntity.setDocumentSupplierId(stuffDocumentSupplierEntity.getId());
                    continue;
                }
                if (!stuffDocumentSchemeEntity.getSupplierName().equals(stuffDocumentSupplierEntity.getSupplierName())) continue;
                stuffDocumentSchemeEntity.setDocumentSupplierId(stuffDocumentSupplierEntity.getId());
            }
        }
        this.stuffDocumentSchemeService.saveBatch(schemeList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(StuffDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(StuffDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(StuffDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.stuffDocumentSellService.list((Wrapper)lambdaSell);
        for (StuffDocumentSellEntity stuffDocumentSellEntity : sellList) {
            stuffDocumentSellEntity.setId(null);
            stuffDocumentSellEntity.setTalkNum(talkNum);
            for (StuffDocumentSchemeEntity stuffDocumentSchemeEntity : schemeList) {
                if (stuffDocumentSellEntity.getIsMobile() != null) {
                    if (!stuffDocumentSellEntity.getSupplierId().equals(stuffDocumentSchemeEntity.getSupplierId()) || !stuffDocumentSellEntity.getSchemeName().equals(stuffDocumentSchemeEntity.getSchemeName())) continue;
                    stuffDocumentSellEntity.setSchemeId(stuffDocumentSchemeEntity.getId());
                    continue;
                }
                if (!stuffDocumentSellEntity.getSupplierName().equals(stuffDocumentSchemeEntity.getSupplierName()) || !stuffDocumentSellEntity.getSchemeName().equals(stuffDocumentSchemeEntity.getSchemeName())) continue;
                stuffDocumentSellEntity.setSchemeId(stuffDocumentSchemeEntity.getId());
            }
        }
        this.stuffDocumentSellService.saveBatch(sellList);
    }
}

