package com.ejianc.business.trade.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.trade.vo.ConfirmationZiVO;

/**
 * 订货确认单
 * 
 * @author generator
 * 
 */
public class ConfirmationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long dhdwId; // 订货单位id
    private String dhdwName; // 订货单位名称
    private Long lxrId; // 联系人id
    private String lxrName; // 联系人
    private String lxfs; // 联系方式
    private Long contractId; // 采购合同id
    private String contractName; // 采购合同名称
    private String receiveAddress; // 收货地址


    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
    }
    @ReferSerialTransfer(referCode = "trade_cghtdj")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    private List<ConfirmationZiVO> confirmationZiList = new ArrayList<>(); // 订货确认单子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDhdwId() {
        return dhdwId;
    }
    @ReferDeserialTransfer
    public void setDhdwId(Long dhdwId) {
        this.dhdwId = dhdwId;
    }
    public String getDhdwName() {
        return dhdwName;
    }

    public void setDhdwName(String dhdwName) {
        this.dhdwName = dhdwName;
    }
    public Long getLxrId() {
        return lxrId;
    }

    public void setLxrId(Long lxrId) {
        this.lxrId = lxrId;
    }
    public String getLxrName() {
        return lxrName;
    }

    public void setLxrName(String lxrName) {
        this.lxrName = lxrName;
    }
    public String getLxfs() {
        return lxfs;
    }

    public void setLxfs(String lxfs) {
        this.lxfs = lxfs;
    }
    
     public List<ConfirmationZiVO> getConfirmationZiList() {
        return confirmationZiList;
     }

     public void setConfirmationZiList(List<ConfirmationZiVO> confirmationZiList) {
        this.confirmationZiList = confirmationZiList;
     }
}
