package com.ejianc.business.tradematerial.check.api;


import com.ejianc.business.tradematerial.check.hystrix.ITradeCheckHystrix;
import com.ejianc.business.tradematerial.check.vo.CheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(
        name = "ejc-trade-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-trade-web",
        fallback = ITradeCheckHystrix.class
)
public interface ICheckApi {

    @PostMapping(value = "/check/saveOrUpdate")
    CommonResponse<CheckVO> saveOrUpdateApi(@RequestBody CheckVO saveOrUpdateVO);

}
