package com.ejianc.business.tradematerial.contract.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 主合同实体
 * 
 * @author generator
 * 
 */
@ApiModel("主合同实体")
public class ContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

//    @ConvertField
    @ApiModelProperty("采购类型 1-自采，2-集采")
    private String purchaseType;
    @ApiModelProperty("集采/自采")
    private String purchaseTypeName;
    @ApiModelProperty("定标结果Id")
    private Long targetResultId;
    @ApiModelProperty("定标结果名称")
    private String targetResultName;
    @ApiModelProperty("项目Id")
    @ConvertField
    private Long projectId;
    @ApiModelProperty("项目名称")
    @ConvertField
    private String projectName;
    @ApiModelProperty("项目地点")
    private String projectPlace;
    @ApiModelProperty("单据编号")
    @ConvertField(targetField = "contractCode")
    private String billCode;
    @ApiModelProperty("合同名称")
    @ConvertField
    private String contractName;
    @ApiModelProperty("合同类别Id")
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId;
    @ApiModelProperty("合同类别名称")
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName;
    private String contractPropertyCode; // 采购类别code
    private String contractPropertyName; // 采购类别名称
    @ApiModelProperty("甲方Id")
    @ConvertField(targetField = "partyaId")
    private Long customerId;
    @ApiModelProperty("甲方名称")
    @ConvertField(targetField = "partyaName")
    private String customerName;
    @ApiModelProperty("乙方Id")
    @ConvertField(targetField = "partybId")
    private Long supplierId;
    @ApiModelProperty("乙方名称")
    @ConvertField(targetField = "partybName")
    private String supplierName;
    @ApiModelProperty("签订日期")
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;
    @ApiModelProperty("签约地点")
    @ConvertField
    private String signPlace;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private String signatureStatus;
    @ApiModelProperty("合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】")
    @ConvertField
    private String performanceStatus;
    @ApiModelProperty("经办人")
    @ConvertField
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    @ConvertField
    private String employeeName;
    @ApiModelProperty("合同税率")
    @ConvertField
    private BigDecimal taxRate;
    @ApiModelProperty("合同支付比例")
    private BigDecimal payScale;
    @ApiModelProperty("甲方经办人Id")
    private Long customerEmployeeId;
    @ApiModelProperty("甲方经办人名称")
    private String customerEmployeeName;
    @ApiModelProperty("甲方经办人电话")
    private String customerEmployeeMobile;
    @ApiModelProperty("乙方经办人名称")
    @ConvertField(targetField = "supplierProjectManagerName")
    private String supplierEmployeeName;
    @ApiModelProperty("乙方经办人电话")
    @ConvertField(targetField = "supplierProjectManagerLink")
    private String supplierEmployeeMobile;
    @ApiModelProperty("计价方式：1-固定单价、2-浮动单价、3-固定总价")
    @ConvertField
    private String pricingType;
    @ApiModelProperty("起草方式：1、在线起草，2、上传合同，3、线下签订")
    private String draftType;
    @ApiModelProperty("合同附件路径")
    private String contractFilePath;
    @ApiModelProperty("合同附件Id")
    private Long contractFileId;
    @ApiModelProperty("合同模板Id")
    private Long contractTemplateId;
    @ApiModelProperty("合同模板名称")
    private String contractTemplateName;
    @ApiModelProperty("合同附件版本Id")
    private Long contractFileVersionId;
    @ApiModelProperty("合同附件版本")
    private Long contractFileVersion;
    @ApiModelProperty("合同金额")
    @ConvertField
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    @ConvertField
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    @ConvertField
    private BigDecimal contractTax;
    @ApiModelProperty("清单金额")
    private BigDecimal detailTaxMny;
    @ApiModelProperty("清单金额（无税）")
    private BigDecimal detailMny;
    @ApiModelProperty("清单税额")
    private BigDecimal detailTax;
    @ApiModelProperty("其他费用金额")
    private BigDecimal freeTaxMny;
    @ApiModelProperty("其他费用金额（无税）")
    private BigDecimal freeMny;
    @ApiModelProperty("其他费用税额")
    private BigDecimal freeTax;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("提交日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;
    @ApiModelProperty("项目部Id")
    @ConvertField
    private Long orgId;
    @ApiModelProperty("项目部名称")
    @ConvertField
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    @ConvertField
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    @ConvertField
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    @ConvertField
    private String parentOrgCode;
    @ApiModelProperty("合同高亮附件路径")
    private String contractFileHighlightPath;
    @ApiModelProperty("合同高亮附件Id")
    private Long contractFileHighlightId;
    @ApiModelProperty("初始版本金额")
    private BigDecimal baseMoney;
    @ApiModelProperty("初始版本(含税)金额")
    private BigDecimal baseMoneyWithTax;
    @ApiModelProperty("变更前金额")
    private BigDecimal beforeChangeMny;
    @ApiModelProperty("变更前金额（含税）")
    private BigDecimal beforeChangeMnyWithTax;
    @ApiModelProperty("变更中金额")
    private BigDecimal changingMny;
    @ApiModelProperty("变更中金额（含税）")
    private BigDecimal changingMnyWithTax;
    @ApiModelProperty("变更单号")
    private String changeCode;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更状态(1-未变更 2-变更中 3-已变更)")
    @ConvertField
    private Integer changeStatus;
    @ApiModelProperty("是否补充协议(1:是，0：否)")
    @ConvertField
    private Integer supplementFlag;
    @ApiModelProperty("主合同Id")
    @ConvertField
    private Long mainContractId;
    @ApiModelProperty("主合同编码")
    @ConvertField
    private String mainContractCode;
    @ApiModelProperty("主合同名称")
    @ConvertField
    private String mainContractName;
    @ApiModelProperty("补充项描述")
    private String supplementDescribe;
    @ApiModelProperty("主合同创建日期(用于合同、补充协议排序)")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate;
    @ApiModelProperty("变更日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;
    @ApiModelProperty("变更合同签章状态")
    private Integer changeContractSignatureStatus;
    @ApiModelProperty("变更起草方式：1-上传附件，2-线下签订")
    private String changeDraftType;
    @ApiModelProperty("变更附件Id")
    private Long changeFileId;
    @ApiModelProperty("变更合同名称")
    private String changeContractName;
    @ApiModelProperty("签章完成合同文件Id")
    private Long signedFileId;
    @ApiModelProperty("累计预付款金额")
    private BigDecimal totalPrepayMny;
    @ApiModelProperty("累计付款金额")
    private BigDecimal totalPayMny;
    @ApiModelProperty("累计冲抵金额")
    private BigDecimal totalOffsetMny;
    @ApiModelProperty("累计结算金额(不含税)")
    private BigDecimal totalSettlementMny;
    @ApiModelProperty("累计结算金额")
    private BigDecimal totalSettlementTaxMny;
    @ApiModelProperty("累计收票金额(不含税)")
    private BigDecimal totalInvoiceMny;
    @ApiModelProperty("累计收票金额")
    private BigDecimal totalInvoiceTaxMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("数据来源 0-定标结果")
    private Integer systemType;
    private Long contractId;

    private String settlementPayment; // 结算付款
    private String priceFloatType; // 单价浮动方式
    private Long thirdPartyId; // 第三方id
    private String thirdPartyName; // 第三方名称
    private Long thirdPartyEmployeeId; // 第三方经办人Id
    private String thirdPartyEmployeeName; // 第三方经办人名称
    private String thirdPartyEmployeeMobile; // 第三方经办人电话
    private Integer purchaseMethod; // 采购方式（1：直采2：代采）

    /**
     * 单据状态名称（不入库） ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private String billStateName;
    @ApiModelProperty("合同类型（0-物资采购合同，1-混凝土合同）")
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）

    /**
     * 线上起草，审批中修改的合同是否已重新进行合同编辑
     */
    private Boolean contractFileSyncFlag = true;

    /**
     * 发票类型Id
     */
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    private String invoiceTypeName;

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    /**
     * 完工结算单生效日期
     */
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishSettleDate;

    private Long watermarkContractFileId;
    @ConvertField
    private String orgCode; // 项目部编码
    @ConvertField
    private Integer filingStatus;//是否归档 1：是；0：否
    @ConvertField
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否

    @ApiModelProperty("主合同明细实体")
    private List<ContractDetailVO> contractDetailList = new ArrayList<>();
    @ApiModelProperty("主合同其他费用实体")
    private List<ContractFeeVO> contractFeeList = new ArrayList<>();
    @ApiModelProperty("主合同付款阶段实体")
    @ConvertField(targetField = "contractSubPaymentNodeList", targetFieldType = ConvertField.TargetType.CLASS)
    private List<ContractStageVO> contractStageList = new ArrayList<>();
    @ApiModelProperty("主合同条款实体")
    private List<ContractClauseVO> contractClauseList = new ArrayList<>();
    @ApiModelProperty("主合同外加剂实体")
    private List<ContractAdmixtureVO> contractAdmixtureList = new ArrayList<>();
    private Long materialId; // 物资合同主键


    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }

    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }
    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }

    public List<ContractAdmixtureVO> getContractAdmixtureList() {
        return contractAdmixtureList;
    }

    public void setContractAdmixtureList(List<ContractAdmixtureVO> contractAdmixtureList) {
        this.contractAdmixtureList = contractAdmixtureList;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getSystemType() {
        return systemType;
    }

    public void setSystemType(Integer systemType) {
        this.systemType = systemType;
    }


    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }
    @ReferDeserialTransfer
    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    /**
     * 补充协议集合（不入库）
     */
    private List<ContractVO> supplementList = new ArrayList<>();

    /**
     * 是否能新增补充协议（不入库）
     */
    private Boolean editFlag;


    /**
     * 补充协议次数（不入库）
     */
    private Integer supplementNum;

    /**
     * 累计补充金额（不入库）
     */
    private BigDecimal allSupplementAmt;

    /**
     * 补充金额比例（不入库）
     */
    private BigDecimal supplementAmtRate;

    public BigDecimal getAllSupplementAmt() {
        return allSupplementAmt;
    }

    public void setAllSupplementAmt(BigDecimal allSupplementAmt) {
        this.allSupplementAmt = allSupplementAmt;
    }

    public BigDecimal getSupplementAmtRate() {
        return supplementAmtRate;
    }

    public void setSupplementAmtRate(BigDecimal supplementAmtRate) {
        this.supplementAmtRate = supplementAmtRate;
    }

    public Boolean getEditFlag() {
        return editFlag;
    }

    public void setEditFlag(Boolean editFlag) {
        this.editFlag = editFlag;
    }

    public Integer getSupplementNum() {
        return supplementNum;
    }

    public void setSupplementNum(Integer supplementNum) {
        this.supplementNum = supplementNum;
    }

    public List<ContractVO> getSupplementList() {
        return supplementList;
    }

    public void setSupplementList(List<ContractVO> supplementList) {
        this.supplementList = supplementList;
    }

    /**
     * 采购类型 1-自采，2-集采
     */
    public String getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购类型 1-自采，2-集采
     */
    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 集采/自采
     */
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    /**
     * 集采/自采
     */
    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    /**
     * 定标结果Id
     */
    @ReferSerialTransfer(referCode="refStuffsupplierData")
    public Long getTargetResultId() {
        return targetResultId;
    }

    /**
     * 定标结果Id
     */
    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }
    /**
     * 定标结果名称
     */
    public String getTargetResultName() {
        return targetResultName;
    }

    /**
     * 定标结果名称
     */
    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目地点
     */
    public String getProjectPlace() {
        return projectPlace;
    }

    /**
     * 项目地点
     */
    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类别Id
     */
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    /**
     * 合同类别Id
     */
    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    /**
     * 合同类别名称
     */
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    /**
     * 合同类别名称
     */
    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    /**
     * 甲方Id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 乙方Id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 签订日期
     */
    public Date getSignDate() {
        return signDate;
    }

    /**
     * 签订日期
     */
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 签约地点
     */
    public String getSignPlace() {
        return signPlace;
    }

    /**
     * 签约地点
     */
    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public String getSignatureStatus() {
        return signatureStatus;
    }

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getPayScale() {
        return payScale;
    }

    /**
     * 合同支付比例
     */
    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    /**
     * 甲方经办人Id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    /**
     * 甲方经办人Id
     */
    @ReferDeserialTransfer
    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }
    /**
     * 甲方经办人名称
     */
    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    /**
     * 甲方经办人名称
     */
    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }
    /**
     * 甲方经办人电话
     */
    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    /**
     * 甲方经办人电话
     */
    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }
    /**
     * 乙方经办人名称
     */
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    /**
     * 乙方经办人名称
     */
    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    /**
     * 乙方经办人电话
     */
    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    /**
     * 乙方经办人电话
     */
    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }
    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    public String getPricingType() {
        return pricingType;
    }

    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    /**
     * 起草方式：1、在线起草，2、上传合同，3、线下签订
     */
    public String getDraftType() {
        return draftType;
    }

    /**
     * 起草方式：1、在线起草，2、上传合同，3、线下签订
     */
    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    /**
     * 合同附件路径
     */
    public String getContractFilePath() {
        return contractFilePath;
    }

    /**
     * 合同附件路径
     */
    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }
    /**
     * 合同附件Id
     */
    public Long getContractFileId() {
        return contractFileId;
    }

    /**
     * 合同附件Id
     */
    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    /**
     * 合同模板Id
     */
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    /**
     * 合同模板Id
     */
    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    /**
     * 合同模板名称
     */
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    /**
     * 合同模板名称
     */
    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    /**
     * 合同附件版本Id
     */
    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    /**
     * 合同附件版本Id
     */
    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }
    /**
     * 合同附件版本
     */
    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    /**
     * 合同附件版本
     */
    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税额
     */
    public BigDecimal getContractTax() {
        return contractTax;
    }

    /**
     * 合同税额
     */
    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    /**
     * 清单金额
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 清单金额
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 清单金额（无税）
     */
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 清单金额（无税）
     */
    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 清单税额
     */
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 清单税额
     */
    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 其他费用金额
     */
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    /**
     * 其他费用金额
     */
    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    /**
     * 其他费用金额（无税）
     */
    public BigDecimal getFreeMny() {
        return freeMny;
    }

    /**
     * 其他费用金额（无税）
     */
    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }
    /**
     * 其他费用税额
     */
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    /**
     * 其他费用税额
     */
    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 项目部Id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同高亮附件路径
     */
    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    /**
     * 合同高亮附件路径
     */
    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }
    /**
     * 合同高亮附件Id
     */
    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    /**
     * 合同高亮附件Id
     */
    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 初始版本(含税)金额
     */
    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    /**
     * 初始版本(含税)金额
     */
    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 主合同Id
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同Id
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 补充项描述
     */
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    /**
     * 补充项描述
     */
    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    /**
     * 主合同创建日期(用于合同、补充协议排序)
     */
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    /**
     * 主合同创建日期(用于合同、补充协议排序)
     */
    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    /**
     * 变更日期
     */
    public Date getChangeDate() {
        return changeDate;
    }

    /**
     * 变更日期
     */
    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    /**
     * 变更合同签章状态
     */
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    /**
     * 变更合同签章状态
     */
    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    /**
     * 变更起草方式：1-上传附件，2-线下签订
     */
    public String getChangeDraftType() {
        return changeDraftType;
    }

    /**
     * 变更起草方式：1-上传附件，2-线下签订
     */
    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    /**
     * 变更附件Id
     */
    public Long getChangeFileId() {
        return changeFileId;
    }

    /**
     * 变更附件Id
     */
    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }
    /**
     * 变更合同名称
     */
    public String getChangeContractName() {
        return changeContractName;
    }

    /**
     * 变更合同名称
     */
    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    /**
     * 签章完成合同文件Id
     */
    public Long getSignedFileId() {
        return signedFileId;
    }

    /**
     * 签章完成合同文件Id
     */
    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
    /**
     * 累计预付款金额
     */
    public BigDecimal getTotalPrepayMny() {
        return totalPrepayMny;
    }

    /**
     * 累计预付款金额
     */
    public void setTotalPrepayMny(BigDecimal totalPrepayMny) {
        this.totalPrepayMny = totalPrepayMny;
    }
    /**
     * 累计付款金额
     */
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    /**
     * 累计付款金额
     */
    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    /**
     * 累计冲抵金额
     */
    public BigDecimal getTotalOffsetMny() {
        return totalOffsetMny;
    }

    /**
     * 累计冲抵金额
     */
    public void setTotalOffsetMny(BigDecimal totalOffsetMny) {
        this.totalOffsetMny = totalOffsetMny;
    }
    /**
     * 累计结算金额(不含税)
     */
    public BigDecimal getTotalSettlementMny() {
        return totalSettlementMny;
    }

    /**
     * 累计结算金额(不含税)
     */
    public void setTotalSettlementMny(BigDecimal totalSettlementMny) {
        this.totalSettlementMny = totalSettlementMny;
    }
    /**
     * 累计结算金额
     */
    public BigDecimal getTotalSettlementTaxMny() {
        return totalSettlementTaxMny;
    }

    /**
     * 累计结算金额
     */
    public void setTotalSettlementTaxMny(BigDecimal totalSettlementTaxMny) {
        this.totalSettlementTaxMny = totalSettlementTaxMny;
    }
    /**
     * 累计收票金额(不含税)
     */
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    /**
     * 累计收票金额(不含税)
     */
    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    /**
     * 累计收票金额
     */
    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    /**
     * 累计收票金额
     */
    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ContractDetailVO> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractDetailVO> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }

    public List<ContractFeeVO> getContractFeeList() {
        return contractFeeList;
    }

    public void setContractFeeList(List<ContractFeeVO> contractFeeList) {
        this.contractFeeList = contractFeeList;
    }

    public List<ContractStageVO> getContractStageList() {
        return contractStageList;
    }

    public void setContractStageList(List<ContractStageVO> contractStageList) {
        this.contractStageList = contractStageList;
    }

    public List<ContractClauseVO> getContractClauseList() {
        return contractClauseList;
    }

    public void setContractClauseList(List<ContractClauseVO> contractClauseList) {
        this.contractClauseList = contractClauseList;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getThirdPartyId() {
        return thirdPartyId;
    }
    @ReferDeserialTransfer
    public void setThirdPartyId(Long thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public String getThirdPartyName() {
        return thirdPartyName;
    }

    public void setThirdPartyName(String thirdPartyName) {
        this.thirdPartyName = thirdPartyName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getThirdPartyEmployeeId() {
        return thirdPartyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setThirdPartyEmployeeId(Long thirdPartyEmployeeId) {
        this.thirdPartyEmployeeId = thirdPartyEmployeeId;
    }

    public String getThirdPartyEmployeeName() {
        return thirdPartyEmployeeName;
    }

    public void setThirdPartyEmployeeName(String thirdPartyEmployeeName) {
        this.thirdPartyEmployeeName = thirdPartyEmployeeName;
    }

    public String getThirdPartyEmployeeMobile() {
        return thirdPartyEmployeeMobile;
    }

    public void setThirdPartyEmployeeMobile(String thirdPartyEmployeeMobile) {
        this.thirdPartyEmployeeMobile = thirdPartyEmployeeMobile;
    }

    public Integer getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(Integer purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }
}
