package com.ejianc.business.trade.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 发货单子表
 * 
 * @author generator
 * 
 */
public class ShipmentsZiVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long zhuId; // 主表ID
    private Long gfId; // 供方id
    private String gfCode; // 供方编号
    private String gfName; // 供方名字
    private Long cplbId; // 产品类别id
    private String cplbName; // 产品类别
    private Long pmId; // 品名id
    private String pmName; // 品名
    private Long ggId; // 规格id
    private String ggName; // 规格
    private Long czId; // 材质id
    private String czName; // 材质
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insertDate; // 下单日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arrivalDate; // 预计到货日期
    private BigDecimal webPrice; // 参考价格
    private BigDecimal price; // 单价
    private Integer num; // 数量
    private BigDecimal totalPrice; // 金额
    private Long confirmationZiId; // 订货单子表id


    public Long getConfirmationZiId() {
        return confirmationZiId;
    }

    public void setConfirmationZiId(Long confirmationZiId) {
        this.confirmationZiId = confirmationZiId;
    }
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getZhuId() {
        return zhuId;
    }

    public void setZhuId(Long zhuId) {
        this.zhuId = zhuId;
    }

    @ReferSerialTransfer(referCode = "trade_materials")
    public Long getGfId() {
        return gfId;
    }
    @ReferDeserialTransfer
    public void setGfId(Long gfId) {
        this.gfId = gfId;
    }
    public String getGfCode() {
        return gfCode;
    }

    public void setGfCode(String gfCode) {
        this.gfCode = gfCode;
    }
    public String getGfName() {
        return gfName;
    }

    public void setGfName(String gfName) {
        this.gfName = gfName;
    }
    public Long getCplbId() {
        return cplbId;
    }

    public void setCplbId(Long cplbId) {
        this.cplbId = cplbId;
    }
    public String getCplbName() {
        return cplbName;
    }

    public void setCplbName(String cplbName) {
        this.cplbName = cplbName;
    }

    @ReferSerialTransfer(referCode = "trade_materials")
    public Long getPmId() {
        return pmId;
    }
    @ReferDeserialTransfer
    public void setPmId(Long pmId) {
        this.pmId = pmId;
    }
    public String getPmName() {
        return pmName;
    }

    public void setPmName(String pmName) {
        this.pmName = pmName;
    }


    @ReferSerialTransfer(referCode = "trade_materials")
    public Long getGgId() {
        return ggId;
    }
    @ReferDeserialTransfer
    public void setGgId(Long ggId) {
        this.ggId = ggId;
    }
    public String getGgName() {
        return ggName;
    }

    public void setGgName(String ggName) {
        this.ggName = ggName;
    }

    @ReferSerialTransfer(referCode = "trade_materials")
    public Long getCzId() {
        return czId;
    }
    @ReferDeserialTransfer
    public void setCzId(Long czId) {
        this.czId = czId;
    }
    public String getCzName() {
        return czName;
    }

    public void setCzName(String czName) {
        this.czName = czName;
    }
    public Date getInsertDate() {
        return insertDate;
    }

    public void setInsertDate(Date insertDate) {
        this.insertDate = insertDate;
    }
    public Date getArrivalDate() {
        return arrivalDate;
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }
    public BigDecimal getWebPrice() {
        return webPrice;
    }

    public void setWebPrice(BigDecimal webPrice) {
        this.webPrice = webPrice;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}
