package com.ejianc.business.tradematerial.contract.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 主合同付款阶段实体
 * 
 * @author generator
 * 
 */
@ApiModel("主合同付款阶段实体")
public class ContractStageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("付款阶段名称")
    @ConvertField(targetField = "paymentNodeName")
    private String stageName;
    @ApiModelProperty("付款阶段比例(%)")
    @ConvertField(targetField = "totalActualPayRecTax")
    private BigDecimal stageScale;
    @ApiModelProperty("备注")
    @ConvertField(targetField = "memo")
    private String stageMemo;
    @ApiModelProperty("所属合同Id")
    private Long contractId;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;

    @ConvertField(targetField = "sourceId,id")
    private Long id;

    @ConvertField
    private Integer dr;
    //模板导出使用
    private String stageScaleStr;

    public String getStageScaleStr() {
        return stageScaleStr;
    }

    public void setStageScaleStr(String stageScaleStr) {
        this.stageScaleStr = stageScaleStr;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    /**
     * 付款阶段名称
     */
    public String getStageName() {
        return stageName;
    }

    /**
     * 付款阶段名称
     */
    public void setStageName(String stageName) {
        this.stageName = stageName;
    }
    /**
     * 付款阶段比例(%)
     */
    public BigDecimal getStageScale() {
        return stageScale;
    }

    /**
     * 付款阶段比例(%)
     */
    public void setStageScale(BigDecimal stageScale) {
        this.stageScale = stageScale;
    }
    /**
     * 备注
     */
    public String getStageMemo() {
        return stageMemo;
    }

    /**
     * 备注
     */
    public void setStageMemo(String stageMemo) {
        this.stageMemo = stageMemo;
    }
    /**
     * 所属合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 所属合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    
}
