package com.ejianc.business.tradematerial.finance.api;


import com.ejianc.business.tradematerial.check.hystrix.ITradeCheckHystrix;
import com.ejianc.business.tradematerial.check.vo.CheckVO;
import com.ejianc.business.tradematerial.finance.hystrix.IPayMentHystrix;
import com.ejianc.business.tradematerial.finance.vo.IncomeRegisterVO;
import com.ejianc.business.tradematerial.finance.vo.PaymentApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(
        name = "ejc-trade-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-trade-web",
        fallback = IPayMentHystrix.class
)
public interface IPayMentApi {

    @PostMapping(value = "/paymentApply/saveOrUpdate")
    CommonResponse<PaymentApplyVO> saveOrUpdateApi(@RequestBody PaymentApplyVO saveOrUpdateVO);

    @PostMapping(value = "/incomeRegister/saveOrUpdate")
    CommonResponse<PaymentApplyVO> saveOrUpdate(@RequestBody IncomeRegisterVO saveOrUpdateVO);

}
