package com.ejianc.business.tradematerial.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

/**
 *  单据处理结果基础类
 *
 * @author CJ
 * @Description: 单据处理结果类
 * @date 2022/6/17 17:25
 */
public class BillHandleResultVO extends BaseVO {

    private static final long serialVersionUID = 2947652305496860444L;

    public static final String MESSAGE_QUEUE = "billHandleResultTrade";

    public static String HANDLE_CODE_SUC = "success";
    public static String HANDLE_CODE_FAIL = "fail";

    /**
     * 处理单据的类型:paymentApply-付款申请单,salaryPayApply-工人工资支付申请单
     */
    private String handleBillType;

    /**
     * 处理单据的数据
     */
    private String billDataJson;

    /**
     * 单据处理结果码：success-成功，fail-失败
     */
    private String handleResultCode;

    /**
     * 单据处理结果信息
     */
    private String handleResultMsg;

    /**
     * 单据处理结果接受服务实现类名
     */
    private Boolean handleWithSubService;

    /**
     * 处理单据的业务主键
     */
    private String handleBillIdStr;

    public String getHandleBillType() {
        return handleBillType;
    }

    public void setHandleBillType(String handleBillType) {
        this.handleBillType = handleBillType;
    }

    public String getBillDataJson() {
        return billDataJson;
    }

    public void setBillDataJson(String billDataJson) {
        this.billDataJson = billDataJson;
    }

    public String getHandleResultCode() {
        return handleResultCode;
    }

    public void setHandleResultCode(String handleResultCode) {
        this.handleResultCode = handleResultCode;
    }

    public String getHandleResultMsg() {
        return handleResultMsg;
    }

    public void setHandleResultMsg(String handleResultMsg) {
        this.handleResultMsg = handleResultMsg;
    }

    public Boolean getHandleWithSubService() {
        return handleWithSubService;
    }

    public void setHandleWithSubService(Boolean handleWithSubService) {
        this.handleWithSubService = handleWithSubService;
    }

    public String getHandleBillIdStr() {
        return handleBillIdStr;
    }

    public void setHandleBillIdStr(String handleBillIdStr) {
        this.handleBillIdStr = handleBillIdStr;
    }
}
