package com.ejianc.business.trade.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.trade.bean.ReceiveZiEntity;
/**
 * 收货单
 * 
 * @author generator
 * 
 */
 @TableName("t_trade_receive")
public class ReceiveEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="receive_address")
    private String receiveAddress; // 收货地址
    @TableField(value="lxr_id")
    private Long lxrId; // 联系人id
    @TableField(value="lxr_name")
    private String lxrName; // 联系人
    @TableField(value="lxfs")
    private String lxfs; // 联系方式
    @TableField(value="shipments_date")
    private Date shipmentsDate; // 发货日期
    @TableField(value="car_id")
    private String carId; // 车牌号
    @TableField(value="driver_phone")
    private String driverPhone; // 司机手机号
    @TableField(value="shipments_id")
    private Long shipmentsId; // 发货单id
    @TableField(value="receive_date")
    private Date receiveDate; // 签收日期
    @TableField(value="receive_num")
    private Integer receiveNum; // 收货总数
    @TableField(value="xxpbm")
    private String xxpbm; // 销项票编码
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="receiveZiService", pidName = "zhuId")
    private List<ReceiveZiEntity> receiveZiList = new ArrayList<>(); // 收货单子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
    }
    public Long getLxrId() {
        return lxrId;
    }

    public void setLxrId(Long lxrId) {
        this.lxrId = lxrId;
    }
    public String getLxrName() {
        return lxrName;
    }

    public void setLxrName(String lxrName) {
        this.lxrName = lxrName;
    }
    public String getLxfs() {
        return lxfs;
    }

    public void setLxfs(String lxfs) {
        this.lxfs = lxfs;
    }
    public Date getShipmentsDate() {
        return shipmentsDate;
    }

    public void setShipmentsDate(Date shipmentsDate) {
        this.shipmentsDate = shipmentsDate;
    }
    public String getCarId() {
        return carId;
    }

    public void setCarId(String carId) {
        this.carId = carId;
    }
    public String getDriverPhone() {
        return driverPhone;
    }

    public void setDriverPhone(String driverPhone) {
        this.driverPhone = driverPhone;
    }
    public Long getShipmentsId() {
        return shipmentsId;
    }

    public void setShipmentsId(Long shipmentsId) {
        this.shipmentsId = shipmentsId;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Integer getReceiveNum() {
        return receiveNum;
    }

    public void setReceiveNum(Integer receiveNum) {
        this.receiveNum = receiveNum;
    }
    public String getXxpbm() {
        return xxpbm;
    }

    public void setXxpbm(String xxpbm) {
        this.xxpbm = xxpbm;
    }
    

    public List<ReceiveZiEntity> getReceiveZiList() {
        return receiveZiList;
    }

    public void setReceiveZiList(List<ReceiveZiEntity> receiveZiList) {
        this.receiveZiList = receiveZiList;
    }
}
