package com.ejianc.business.trade.service.impl;

import com.ejianc.business.trade.bean.ReceiveEntity;
import com.ejianc.business.trade.bean.ReceiveZiEntity;
import com.ejianc.business.trade.bean.SaleLibraryEntity;
import com.ejianc.business.trade.service.IReceiveService;
import com.ejianc.business.trade.service.IReceiveZiService;
import com.ejianc.business.trade.service.ISaleLibraryService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("receive") 
public class ReceiveBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IReceiveService service;
	@Autowired
	private IReceiveZiService receiveZiService;

	@Autowired
	private ISaleLibraryService saleLibraryService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReceiveEntity receiveEntity = service.getById(billId);//收货单
		if (receiveEntity != null){


			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("zhuId", new Parameter(QueryParam.EQ, billId));
			queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			List<ReceiveZiEntity> receiveZiEntities = receiveZiService.queryList(queryParam);//收货单子表
			BigDecimal bigDecimal = new BigDecimal(0);//获取总金额
			for (ReceiveZiEntity ziEntity : receiveZiEntities){
				bigDecimal =  bigDecimal.add(ziEntity.getTotalPrice());
			}


			SaleLibraryEntity saleLibraryEntity = new SaleLibraryEntity();
			saleLibraryEntity.setBillCode(receiveEntity.getBillCode());
			saleLibraryEntity.setReceiveId(receiveEntity.getId());
			saleLibraryEntity.setReceiveDate(receiveEntity.getReceiveDate());
			//应收款日期
			saleLibraryEntity.setAccountsDueDate(new Date(receiveEntity.getReceiveDate().getTime() + (long)30 * 24 * 60 * 60 * 1000));
			//合同周期
			saleLibraryEntity.setHtzq(30);
			//月息
			saleLibraryEntity.setYx(new BigDecimal(0.01));
			//收货总数
			saleLibraryEntity.setReceiveNum(receiveEntity.getReceiveNum());
			//收货总金额
			saleLibraryEntity.setReceivePrice(bigDecimal);
			//欠款总金额
			saleLibraryEntity.setQkzje(bigDecimal);
			//销项票编码
			saleLibraryEntity.setXxpbm(receiveEntity.getXxpbm());
			saleLibraryEntity.setOrgId(receiveEntity.getOrgId());
			saleLibraryEntity.setOrgName(receiveEntity.getOrgName());

			saleLibraryEntity.setProjectId(receiveEntity.getLxrId());
			saleLibraryEntity.setProjectName(receiveEntity.getLxrName());

			saleLibraryService.saveOrUpdate(saleLibraryEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
