package com.ejianc.business.tradematerial.contract.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeVO;
import com.ejianc.business.tradematerial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.tradematerial.contract.vo.MaterialReportVO;
import com.ejianc.business.tradematerial.settlement.vo.SettlementVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 主合同实体
 *
 * @author generator
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    List<ContractChangeVO> getContractChangeList(@Param("contractIds") List<Long> contractIds);

    List<SettlementVO> getSettlementList(@Param("contractIds") List<Long> contractIds);

    List<MaterialReportVO> quueryMaterialByProject(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("projectId") Long projectId);

    List<ContractMaterialReportVO> quueryMaterialByOrg(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<ContractMaterialReportVO> getOrderNum(@Param("contractIds") List<Long> contractIds);

    List<ContractMaterialReportVO> getCheckNum(@Param("contractIds") List<Long> contractIds);

    List<ContractMaterialReportVO> getSettleNum(@Param("contractIds") List<Long> contractIds);

}
