package com.ejianc.business.tradematerial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.contract.bean.ContractFeeEntity;
import com.ejianc.business.tradematerial.contract.service.IContractFeeService;
import com.ejianc.business.tradematerial.contract.vo.ContractFeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 签章流程
 *
 * @author generator
 */
@Controller
@RequestMapping("contractFee")
public class ContractFeeController implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    private IContractFeeService service;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("参照")
    @RequestMapping(value = "/refContractFeeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractFeeVO>> refContractFeeData(@RequestParam Integer pageNumber,
                                                                   @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (!_con.containsKey("contractId")) {
                throw new BusinessException("合同信息不能为空！");
            }
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
        }
        else {
            throw new BusinessException("合同信息不能为空！");
        }

        IPage<ContractFeeEntity> page = service.queryPage(param, false);
        IPage<ContractFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractFeeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
