package com.ejianc.business.tradematerial.contract.service;

import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.vo.ContractDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 主合同明细实体
 *
 * @author generator
 */
public interface IContractDetailService extends IBaseService<ContractDetailEntity> {

    /**
     * 根据合同id获取从树形参照里面选择的材料档案
     * 只有分类，没有材料id
     *
     * @param contractId 合同id
     * @return 采购明细
     */
    String getContractDetailByTree(Long contractId);

    /**
     * 根据合同id获取从列表参照里面选择的材料档案
     * 分类id有值
     *
     * @param contractId 合同id
     * @return 采购明细
     */
    String getContractDetailByTable(Long contractId);

    /**
     * 获取列表详情
     * @param contractId 合同id
     * @return 列表详情
     */
    List<ContractDetailVO> getContractDetail(Long contractId);

}
