package com.ejianc.business.tradematerial.contract.service;

import com.ejianc.business.tradematerial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.tradematerial.contract.vo.ContractRelieveVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 合同解除表
 *
 * @author generator
 */
public interface IContractRelieveService extends IBaseService<ContractRelieveEntity> {

    /**
     * 保存合同解除
     *
     * @param saveOrUpdateVO 合同解除信息
     * @return 保存后信息
     */
    ContractRelieveVO save(ContractRelieveVO saveOrUpdateVO);

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    CommonResponse<String> relieveContract(String billId, String status, String refCode);

    ExecutionVO targetCost(ContractRelieveVO map, String linkUrl, Integer contractType);
}
