package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.contract.bean.ContractAdmixtureEntity;
import com.ejianc.business.tradematerial.contract.mapper.ContractAdmixtureMapper;
import com.ejianc.business.tradematerial.contract.service.IContractAdmixtureService;
import com.ejianc.business.tradematerial.contract.vo.ContractAdmixtureVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * 合同外加剂表
 *
 * @author generator
 */
@Service("contractAdmixtureService")
public class ContractAdmixtureServiceImpl extends BaseServiceImpl<ContractAdmixtureMapper, ContractAdmixtureEntity> implements IContractAdmixtureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String CONTRACT_ID = "contractId";

    /**
     * 合同外加剂查询（参照）
     *
     * @param pageNumber   分页
     * @param pageSize     分页大小
     * @param condition    额外参数
     * @param searchObject 模糊查询
     * @param searchText   模糊查询
     * @return 查询结果
     */
    @Override
    public IPage<ContractAdmixtureVO> queryAdmixtureRefData(Integer pageNumber, Integer pageSize, String condition,
                                                            String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        logger.info("入参：pageSize={}，pageNumber={}，searchText={}，searchObject={}，condition={}", pageSize, pageNumber,
                searchText, searchObject, condition);
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            JSONObject _con = JSONObject.parseObject(condition);
            // 如果没有合同id，则抛出异常
            if (!_con.containsKey(CONTRACT_ID)) {
                throw new BusinessException("合同信息为空！");
            }
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get(CONTRACT_ID)));
        }
        else {
            throw new BusinessException("合同信息为空！");
        }
        logger.info("查询参数：{}", JSONObject.toJSONString(param));
        IPage<ContractAdmixtureEntity> page = super.queryPage(param, false);
        IPage<ContractAdmixtureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractAdmixtureVO.class));
        return pageData;
    }

    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<ContractAdmixtureEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        baseMapper.delete(deleteWrapper);
    }
}
