package com.ejianc.business.tradematerial.contract.service.impl;

import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.mapper.ContractDetailMapper;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.vo.ContractDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 主合同明细实体
 *
 * @author generator
 */
@Service("contractDetailService")
public class ContractDetailServiceImpl extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity> implements IContractDetailService {

    /**
     * 根据合同id获取从树形参照里面选择的材料档案
     * 只有分类，没有材料id
     *
     * @param contractId 合同id
     * @return 采购明细
     */
    @Override
    public String getContractDetailByTree(Long contractId) {
        return this.queryContractDetailToString(contractId, true);
    }

    /**
     * 根据合同id获取从列表参照里面选择的材料档案
     * 分类id有值
     *
     * @param contractId 合同id
     * @return 采购明细
     */
    @Override
    public String getContractDetailByTable(Long contractId) {
        return this.queryContractDetailToString(contractId, false);
    }

    /**
     * 获取列表详情
     * @param contractId 合同id
     * @return 列表详情
     */
    @Override
    public List<ContractDetailVO> getContractDetail(Long contractId) {
        List<ContractDetailEntity> list = this.queryContractDetail(contractId, true);
        return BeanMapper.mapList(list, ContractDetailVO.class);
    }


    /**
     * 根据列表返回id字符串
     * @param contractId 合同id
     * @param flag 是否查询树形参照
     * @return id字符串
     */
    private String queryContractDetailToString(Long contractId, boolean flag) {
        List<ContractDetailEntity> list = this.queryContractDetail(contractId, flag);
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ContractDetailEntity entity : list) {
                sb.append(entity.getMaterialTypeId()).append(",");
            }
            // 截取最后一位逗号
            if (sb.length() > 0) {
                sb.delete(sb.length() - 1, sb.length());
            }
        }
        return sb.toString();
    }

    /**
     * 查询明细列表
     *
     * @param contractId 合同id
     * @param flag       是否查询树形参照到的数据（true，树形。false，列表参照）
     * @return 查询结果
     */
    private List<ContractDetailEntity> queryContractDetail(Long contractId, boolean flag) {
        if (contractId == null) {
            throw new BusinessException("合同信息为空！");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        if (flag) {
            queryParam.getParams().put("material_id", new Parameter(QueryParam.EQ, null));
        }
        else {
            queryParam.getParams().put("material_id", new Parameter(QueryParam.NE, null));
        }
        return super.queryList(queryParam);
    }
}
