package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractFreezeEntity;
import com.ejianc.business.tradematerial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.tradematerial.contract.service.IContractFreezeService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.contract.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("contractFreeze")
public class ContractFreezeBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IContractFreezeService service;

	@Autowired
	private IContractService contractService;
	@Autowired
	private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("-------------进入合同冻结/解冻afterSubmitProcessor方法-------------------------");
		ContractFreezeEntity entity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		logger.info("查询出用户信息：{}", JSONObject.toJSONString(userContext));
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(entity);
		logger.info("提交前回调：{}", JSONObject.toJSONString(entity));
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("-------------终审审核回调----------------");
		ContractFreezeEntity contractFreezeEntity = service.selectById(billId);
		if (contractFreezeEntity != null) {
			contractFreezeEntity.setEffectiveDate(new Date());
			service.saveOrUpdate(contractFreezeEntity,false);

			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("id", new Parameter(QueryParam.EQ, contractFreezeEntity.getContractId()));
			List<ContractEntity> contractList = contractService.queryList(queryParam);
			ContractEntity contractEntity = contractList.get(0);
			if (PerformanceStatusEnum.已冻结.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.已冻结.getCode());
			}
			else if (PerformanceStatusEnum.履约中.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
			}
			contractService.saveOrUpdate(contractEntity,false);
			// 推送合同池
			contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
			logger.info("终审审核完，合同信息：{}", JSONObject.toJSONString(contractEntity));
		}
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//		CommonResponse<String> checkResponse = bpmBackCheck(billId, state, billTypeCode);
//		if (!checkResponse.isSuccess()) {
//			return  CommonResponse.error(checkResponse.getMsg());
//		}
//		logger.info("-------------弃审前回调----------------");
//		ContractFreezeEntity contractFreezeEntity = service.selectById(billId);
//		if (contractFreezeEntity != null) {
//			contractFreezeEntity.setEffectiveDate(null);
//			contractFreezeEntity.setCommitDate(null);
//			contractFreezeEntity.setCommitUserCode(null);
//			contractFreezeEntity.setCommitUserName(null);
//			service.saveOrUpdate(contractFreezeEntity,false);
//
//			QueryParam queryParam = new QueryParam();
//			queryParam.getParams().put("id", new Parameter(QueryParam.EQ, contractFreezeEntity.getContractId()));
//			List<ContractEntity> contractList = contractService.queryList(queryParam);
//			ContractEntity contractEntity = contractList.get(0);
//			// 撤回时，如果合同是冻结，则修改为履约中
//			if (PerformanceStatusEnum.已冻结.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
//				contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
//			}
//			else if (PerformanceStatusEnum.履约中.getCode().equals(contractFreezeEntity.getPerformanceStatus())) {
//				contractEntity.setPerformanceStatus(PerformanceStatusEnum.已冻结.getCode());
//			}
//			contractService.saveOrUpdate(contractEntity,false);
//			logger.info("终审审核完，合同信息：{}", JSONObject.toJSONString(contractEntity));
//		}
//		logger.info("-------------弃审前回调结束----------------");
//		return CommonResponse.success("弃审/撤回前校验回调成功！");
		return CommonResponse.error("合同冻结/解冻不允许撤回！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
