package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;

import com.ejianc.business.tradematerial.contract.bean.*;
import com.ejianc.business.tradematerial.contract.enums.*;
import com.ejianc.business.tradematerial.contract.mapper.ContractMapper;
import com.ejianc.business.tradematerial.contract.service.*;
import com.ejianc.business.tradematerial.contract.vo.*;
import com.ejianc.business.tradematerial.settlement.service.ISettlementService;
import com.ejianc.business.tradematerial.settlement.vo.SettlementVO;
import com.ejianc.business.tradematerial.utils.CommonUtils;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 主合同实体
 *
 * @author generator
 *
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 物资合同 */
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    /** 混凝土合同 */
    private static final String PURCHASE_CONTRACT_CONCRETE_BILL_CODE = "CONTRACT_CONCRETE";

    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_0 = 0;
//    /** 合同类型（0-物资采购合同，1-混凝土合同） */
//    private static final Integer CONTRACT_TYPE_1 = 1;

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;

    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;

    private final String MAIN_CONTRACT_REFCODE = "contractMaterial";

    private static final String CHECK_PARAM_CODE = "P-434f5499";

    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_SUP_CODE = "P-CO2iY888";//消耗材补充金额控制
    private static final String C_SUP_CODE = "P-K496W490";//混凝补充金额控制
    private static final String M_PLAN_CODE = "P-CcZ6rO87";//消耗材总计划金额控制
    private static final String C_PLAN_CODE = "P-00g5A089";//混凝总计划金额控制

    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182"; // 合同更新签订日期控制

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(contractVo.getParentOrgCode()) && contractVo.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                contractVo.setParentOrgCode(orgVO.getCode());
//            }
//        }
//        if (StringUtils.isEmpty(contractVo.getOrgCode()) && contractVo.getOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                contractVo.setOrgCode(orgVO.getCode());
//            }
//        }

        if (contractVo.getOrgId() != null && (StringUtils.isEmpty(contractVo.getOrgCode())
                || StringUtils.isEmpty(contractVo.getParentOrgCode()) || StringUtils.isEmpty(contractVo.getOrgName()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVo.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVo.setOrgCode(orgVO.getCode());
                if(StringUtils.isEmpty(contractVo.getOrgName())){
                    contractVo.setOrgName(orgVO.getName());
                }
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        contractVo.setParentOrgId(parentOrgVO.getId());
                        contractVo.setParentOrgCode(parentOrgVO.getCode());
                        contractVo.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    contractVo.setParentOrgId(contractVo.getOrgId());
                    contractVo.setParentOrgCode(contractVo.getOrgCode());
                    contractVo.setParentOrgName(contractVo.getOrgName());
                }
            }
        }
        // 参照定标结果新增、编辑合同，需要给初始签订数量赋值
        if(contractVo.getTargetResultId() != null && CollectionUtils.isNotEmpty(contractVo.getContractDetailList())){
            for (ContractDetailVO detailVO:contractVo.getContractDetailList()) {
                detailVO.setInitNum(detailVO.getNum());
            }
        }
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        if (!isControl){
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
                // 合同编码生成
                entity.setBillCode(this.getContractBillCode(contractVo));
            }
        }
        if (entity.getId() == null) {
            //设置归档状态
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        if (contractVo.getMaterialId() != null) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("material_id", new Parameter(QueryParam.EQ, contractVo.getMaterialId()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractVo.getId()));
            List<ContractEntity> contractEntities = service.queryList(queryParam, false);
            if (contractEntities != null && contractEntities.size() > 0) {
                throw new BusinessException("该合同已存在，不允许保存!");
            }
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());

        // 原合同变更删除附件逻辑，修改为下面这种方式
//        if (entity.getContractFileId() != null) {
//            if (entity.getId() != null) {
//                ContractEntity contract = super.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl) {
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            } else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl) {
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//        }

        // 1、合同保存方法增加逻辑
        if (entity.getContractFileId() != null) {
            //合同旧数据
            ContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (!isControl) {

            boolean saveFlag = super.saveOrUpdate(entity, false);
            if (!saveFlag) {
                throw new BusinessException("合同保存失败！");
            }
            if (contractVo.getId() == null && contractVo.getTargetResultId() != null) {
                this.updateTargetResult(contractVo, 0);
            }
            if (contractVo.getId() != null && contractVo.getTargetResultId() != null) {
                ContractEntity contractEntity = super.selectById(contractVo.getId());

                // 如果是合同修改，先对修改前合同做反向操作，再进行占用
                this.updateTargetResult(BeanMapper.map(contractEntity, com.ejianc.business.tradematerial.contract.vo.ContractVO.class), 1);
                this.updateTargetResult(contractVo, 0);
            }

            //起草方式为使用合同模板时，将合同文件同步标识置为未同步
            if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())
                    || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
        }
        return CommonResponse.success(BeanMapper.map(entity, ContractVO.class));
    }

    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        logger.info("生成编码规则，GenerateBillCodeType=：{}", GenerateBillCodeType);
        switch (GenerateBillCodeType) {
            case "common":
                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
                if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVo.getContractType())) {
                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
                }
                BillCodeParam billCodeParam = BillCodeParam
                        .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    contractBillCode = billCode.getData();
                }
                else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                break;
            default:
                throw new BusinessException("编码生成失败！");
        }
        logger.info("生成de编码，contractBillCode=：{}", contractBillCode);
        return contractBillCode;
    }


    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = BeanMapper.map(contractVo, ContractEntity.class);
        List<ContractEntity> entities = null;
        List<ContractChangeEntity> entitiesc = null;
        //主合同
        ContractEntity mainContract = service.selectById(contractVo.getMainContractId());
        if(null == mainContract) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        if (!isControl) {
            if (StringUtils.isEmpty(contractVo.getBillCode())) {
//                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
//                if (MaterialContractTypeEnum.混凝土.getCode().equals(contractVo.getContractType())) {
//                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
//                }
//                BillCodeParam billCodeParam = BillCodeParam.build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if (billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                } else {
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
                QueryParam billCodeParam = new QueryParam();
                billCodeParam.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
                List<Integer> billStateList = new ArrayList<>();
                billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                billCodeParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
                List<ContractEntity> billCOdeSupplementList = service.queryList(billCodeParam, false);
                String supplementNum = "";
                if (billCOdeSupplementList.size() < 9) {
                    supplementNum += "0" + (billCOdeSupplementList.size() + 1);
                }else {
                    supplementNum += (billCOdeSupplementList.size() + 1);
                }
                //设置补充协议编码
                entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, contractVo.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {

            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", contractVo.getMainContractId()));
            List<ContractEntity> supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractVo.getBillCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        // 校验其他单据
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (FilingStatusEnum.已归档.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = super.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl){
                        delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl){
                        delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            }
        }
        if (!isControl){
            super.saveOrUpdate(entity, false);

            //集采时不推成本执行数据
            if (entity.getPurchaseType().equals("1")) {
                //目标成本推送
                String linkUrl;
                if (entity.getContractType() == 0) {
                    linkUrl = BaseHost + "ejc-promaterial-frontend/#/supplement/card?id=" + entity.getId();
                }
                else {
                    linkUrl = BaseHost + "ejc-promaterial-frontend/#/supplementConcrete/card?id=" + entity.getId();
                }
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, ContractVO.class),linkUrl,0,entity.getContractType());
                logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
                CommonResponse<String> response = executionApi.aggPush(executionVO);
                if (!response.isSuccess()){
                    throw new BusinessException("目标成本推送失败,"+response.getMsg());
                }
            }

        }
        return BeanMapper.map(entity, ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = super.selectById(contractId);
        ContractVO supplementVO = new ContractVO();


        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());

//        supplementVO.setTargetResultId(contractVO.getTargetResultId());
//        supplementVO.setTargetResultName(contractVO.getTargetResultName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setContractCategoryName(contractVO.getContractCategoryName());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(1);
        supplementVO.setSignatureStatus(SignatureStatusEnum.未签章.getCode().toString());
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
        supplementVO.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setContractPropertyCode(contractVO.getContractPropertyCode());
        supplementVO.setContractPropertyName(contractVO.getContractPropertyName());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());

        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = super.selectById(id);
        entity.setContractDetailList(null);
        ContractVO contractVo = BeanMapper.map(entity, ContractVO.class);
        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, id);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.中止项);
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setContractDetailList(BeanMapper.mapList(details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
//
        return resp;
    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO recordVO = new ContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());

        QueryWrapper<ContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("signature_status", SignatureStatusEnum.已签章.getCode());
        query.orderByDesc("create_time");
        List<ContractEntity> supplementEntities = super.list(query);

        recordVO.setSupplementList(BeanMapper.mapList(supplementEntities, ContractVO.class));
        //补充协议次数
        recordVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        //设置补充金额比例
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        logger.info("进入主合同签章状态修改方法，修改参数：billId:{},status:{},refCode:{}", billId, status, refCode);
        ContractEntity contract = super.selectById(billId);
        if (contract != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                contract.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
                contract.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
                contract.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
                contract.setFilingRef(0);
                contract.setEffectiveDate(new Date());

                //查询参数判断是否需要更新合同签订日期，
                CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    logger.error("查询电中签章合同-【id-{}】是否更新合同签订日期参数失败，暂不更新合同签订日期: {}", billId,
                            JSONObject.toJSONString(response));
                }
                if (null != response.getData() && "1".equals(response.getData().getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    //更新合同签订日期
                    logger.info("合同【id-{}，原签订日期：{}, 根据电子签章合同更新合同签订日期参数:{}，将合同签订日期改为当前签章完成日期:{}】", billId,
                            sdf.format(contract.getSignDate()), JSONObject.toJSONString(response.getData()),
                            sdf.format(new Date()));
                    contract.setSignDate(new Date());
                }
            } else {
                contract.setSignatureStatus(String.valueOf(status));
            }
            super.saveOrUpdate(contract, false);
            this.pushContract(BeanMapper.map(contract, ContractVO.class));
            logger.info("主合同签章状态已修改，修改后签章状态:{}---------------->",contract.getSignatureStatus());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增补充协议
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())){
            return false;
        }
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, 1);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl,Integer type,Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        List contractDetailList;
        if (contractType==0){
            if (type==0){
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.消耗材合同.getCode());
            }else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.消耗材合同变更.getCode());
            }
        }else {
            if (type==0){
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.混凝土合同.getCode());
            }else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.混凝土变更合同.getCode());
            }
        }
        switch (contractVO.getContractPropertyCode()){
            case "proMaterial-1": totalVO.setBussinessType(BussinessTypeEnum.大宗材物资采购合同.getCode());break;
            case "proMaterial-2": totalVO.setBussinessType(BussinessTypeEnum.周转材物资采购合同.getCode());break;
            case "proMaterial-3": totalVO.setBussinessType(BussinessTypeEnum.零星材料物资采购合同.getCode());break;
            case "contractConcrete-1": totalVO.setBussinessType(BussinessTypeEnum.混凝土采购合同.getCode());break;
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractDetailList !=null){
            for (ContractDetailVO planDetailVO : contractVO.getContractDetailList()) {
                if ("del".equals(planDetailVO.getRowState())){
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                //判断是否是分类
                if (planDetailVO.getMaterialId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO==null){
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMoney());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getDetailTaxMny());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    /**
     * 推送合同项目池
     *
     * @param contractVO 需要推送的合同数据
     */
    @Override
    public Boolean pushContract(ContractVO contractVO) {
        return true;
    }

    /**
     * 将合同重新推送合同池
     *
     * @param id 合同id
     * @return 推送结果
     */
    @Override
    public ContractVO syncPushContract(Long id) {
        return null;
    }

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    @Override
    public void pushDelContract(ContractVO contractVO) {
    }

    /**
     * 是否可以添加合同解除
     *
     * @param id 合同id
     * @return true:可以添加合同解除单据
     */
    @Override
    public boolean addRelieveFlag(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getPerformanceStatus())){
            return false;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        List<ContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        return CollectionUtils.isEmpty(relieveEntityList);
    }

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 集采合同只能本机做合同变更、补充协议等操作
        ContractEntity contractEntity = super.selectById(id);
        if (PurchaseTypeEnum.公司集采.getCode().equals(contractEntity.getPurchaseType())) {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (!orgId.equals(contractEntity.getOrgId())) {
                throw new BusinessException("当前组织无法对该合同进行操作！");
            }
        }
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<ContractChangeEntity> contractChangeEntityList = contractChangeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }

        // 查询合同解除
        List<ContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<ContractFreezeEntity> freezeEntityList = freezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }
    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO,String authority) {
        return null;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {

        return null;
    }

    /**
     * 推送目标成本
     *
     * @param id 合同id
     * @return 推送结果
     */
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
//        //目标成本推送
//        ContractVO contractVO = service.queryDetail(id);
//        if (PurchaseTypeEnum.公司集采.getCode().equals(contractVO.getPurchaseType())) {
//            return CommonResponse.error("公司集采不支持目标成本推送！");
//        }
//        // 合同作废推送作废信息
//        if (PerformanceStatusEnum.已解除.getCode().equals(contractVO.getPerformanceStatus())) {
//            QueryWrapper<ContractRelieveEntity> queryWrapper = new QueryWrapper<>();
//            queryWrapper.eq("contract_id", id);
//            ContractRelieveEntity contractRelieveEntity = relieveService.getOne(queryWrapper);
//            //目标成本推送
//            String linkUrl;
//            if (contractVO.getContractType() == 0) {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId();
//            }
//            else {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
//            }
//            ExecutionVO executionVO = relieveService.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),
//                    linkUrl, contractVO.getContractType());
//            logger.info("目标成本推送合同解除数据" + JSON.toJSONString(executionVO));
//            CommonResponse<String> response = executionApi.aggPush(executionVO);
//            if (!response.isSuccess()) {
//                throw new BusinessException("目标成本推送失败," + response.getMsg());
//            }
//        }
//        // 查询变更合同信息
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
//        List<ContractChangeEntity> changeEntityList = contractChangeService.queryList(queryParam, false);
//        String linkUrl;
//        ExecutionVO executionVO;
//        if (CollectionUtils.isNotEmpty(changeEntityList)) {
//            ContractChangeEntity changeEntity = changeEntityList.get(0);
//            ContractChangeVO changeVO = contractChangeService.queryDetail(changeEntity.getId());
//            if (changeEntity.getContractType() == 0) {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractChange/card?id=" + changeEntity.getId();
//            }
//            else {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractChange/card?id=" + changeEntity.getId();
//            }
//            executionVO= service.targetCost(BeanMapper.map(changeVO, ContractVO.class), linkUrl, 1, changeEntity.getContractType());
//        }
//        else {
//            if (contractVO.getContractType() == 0) {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO.getId();
//            }
//            else {
//                linkUrl = BaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO.getId();
//            }
//            executionVO= service.targetCost(contractVO, linkUrl, 0, contractVO.getContractType());
//        }
//        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
//        CommonResponse<String> response = executionApi.aggPush(executionVO);
//        if (!response.isSuccess()) {
//            throw new BusinessException("目标成本推送失败," + response.getMsg());
//        }
        return CommonResponse.success("目标成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2){
//        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
//        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
//        paramsCheckVO.setWarnType("none");
//        /*添加参数控制区域---*/
//        paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
//        if(!("proMaterial-2".equals(vo.getContractPropertyCode())&&MaterialContractTypeEnum.消耗材.getCode().equals(vo.getContractType()))){//proMaterial-1 - 大众(主要)   proMaterial-2-周转  proMaterial-3-零星
//            paramsCheckVOS.addAll(this.checkParamsMnyPlan( vo));//总计划控制补充、主合同金额
//        }
//        if(vo.getSupplementFlag()!=null && Objects.equals(vo.getSupplementFlag(), SuplementFlagEnum.是补充协议.getCode())){
//            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
//        }
//        if(null!=this.priceCheckParams(vo)){
//            paramsCheckVOS.add(this.priceCheckParams(vo));//历史价格控合同明细价格
//        }
//        if(paramsCheckVO2!=null){//组合成本参数
//            paramsCheckVOS.add(paramsCheckVO2);
//        }
//        /*添加参数控制区域---*/
//        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
//        String[] paramsArray = {"alert", "warn", "none"};
//        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
//            for (ParamsCheckVO checkVO : paramsCheckVOS) {
//                String warnType = checkVO.getWarnType();
//                if(map.containsKey(warnType)){
//                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
//                    checkDsVOS.addAll(checkVO.getDataSource());
//                    map.put(warnType,checkDsVOS);
//                }else {
//                    map.put(warnType,checkVO.getDataSource());
//                }
//            }
//        }
//        for (String s : paramsArray) {
//            if(map.containsKey(s)){
//                paramsCheckVO.setWarnType(s);
//                paramsCheckVO.setDataSource(map.get(s));
//                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
//                    paramsCheckVO.setWarnType("none");
//                }else {
//                    return paramsCheckVO;
//                }
//            }
//        }
        return null;
    }
    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnySup(ContractVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
//        String[] paramsArray = {"none", "warn", "alert"};
//        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
//        if (PurchaseTypeEnum.公司集采.getCode().equals(vo.getPurchaseType())) {
//            // 集采合同直接赋值为不控制
//            return paramsCheckVOS;
//        }
//        BigDecimal contractTaxMnySup = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次补充协议金额
//        ContractEntity contractEntity = super.selectById(vo.getMainContractId());
//        BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();//初始合同金额
//        BigDecimal totalSupMoney =  contractTaxMnySup;//累计补充金额  默认赋值本次
//        //查询累计补充金额
//        QueryParam supplementQueryParam = new QueryParam();
//        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
//        if (vo.getId() != null) {
//            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
//        }
//        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
//        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
//        List<ContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
//        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementContractList)){
//            for (ContractEntity entity : supplementContractList) {
//                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(),totalSupMoney);//累加变更金额
//            }
//        }
//        String CHECK_PARAM_CODE = "";
//        switch (vo.getContractType()){//类型（0-物资采购，1-混凝土）
//            case 0:CHECK_PARAM_CODE= M_SUP_CODE;break;
//            case 1:CHECK_PARAM_CODE= C_SUP_CODE;break;
//        }
////        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
//        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
//        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
//            List<BillParamVO> data = billParamByCode.getData();
//            logger.info("金额控制信息返回："+ JSONObject.toJSONString(data));
//            if(CollectionUtils.isNotEmpty(data)){
//                for (BillParamVO datum : data) {
//                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
//                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
//                    BigDecimal roleValue = datum.getRoleValue();
//                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
//                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
//                    if (totalSupMoney.compareTo(comMny) > 0) {
//                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
//                        paramsCheckDsVO.setOrgName(datum.getOrgName());
//                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
//                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
//                        StringBuffer stringBuffer = new StringBuffer();
//                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
//                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
//                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
//                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
//                        paramsCheckDsVO.setContent(stringBuffer.toString());
//                        checkDsVOS.add(paramsCheckDsVO);
//                    }
//                    paramsCheckVO.setDataSource(checkDsVOS);
//                    paramsCheckVOS.add(paramsCheckVO);
//                }
//            }
//
//        } else {
//            logger.info(billParamByCode.getMsg());
//            throw new BusinessException("获取控制参数失败");
//        }
        return null;
    }
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(ContractVO vo) {
        return null;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractVO vo) {
//        // 1、获取施工合同金额信息
//        CommonResponse<BigDecimal> contractionData = contractPoolApi.queryContractionTaxMny(vo.getProjectId());
//        if (!(contractionData.isSuccess() && null != contractionData.getData())) {
//            logger.info(contractionData.getMsg());
//            throw new BusinessException("获取施工合同信息失败！");
//        }
//        // 施工合同总金额
//        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
//        logger.info("获取项目：{}下，施工合同总金额：{}", vo.getProjectId(), contractionTaxMny);
//
//        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
//        String[] paramsArray = {"none", "warn", "alert"};
//        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0){
//            // 该项目无施工合同直接赋值为不控制
//            return paramsCheckVOList;
//        }
//        // 2、获取参数控制规则
//        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
//        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
//            List<BillParamVO> data = billParamByCode.getData();
//            if(CollectionUtils.isNotEmpty(data)){
//
//                CommonResponse<BigDecimal> projectData = executionApi.queryTotalContMny(vo.getProjectId());
//                if (!(projectData.isSuccess() && null != projectData.getData())) {
//                    logger.info(projectData.getMsg());
//                    throw new BusinessException("获取目标成本项目信息失败！");
//                }
//
//                // 支出合同总金额
//                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
//                logger.info("获取目标成本项目：{}下，所有支出合同总金额：{}", vo.getProjectId(), allExpenseContractTaxMny);
//
//                // 本次变动金额（首次金额或修改后金额）
//                BigDecimal thisTimeChangeTaxMny = BigDecimal.ZERO;
//                ContractEntity contractEntity = service.selectById(vo.getId());
//                if (null != contractEntity){
//                    thisTimeChangeTaxMny = ComputeUtil.safeSub(vo.getContractTaxMny(), contractEntity.getContractTaxMny()).setScale(2,BigDecimal.ROUND_HALF_UP);
//                }else {
//                    thisTimeChangeTaxMny = vo.getContractTaxMny();
//                }
//                logger.info("本次变动金额：{}", thisTimeChangeTaxMny);
//
//
//                for (BillParamVO billParamVO : data) {
//                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
//                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
//
//                    // 比例
//                    BigDecimal roleValue = billParamVO.getRoleValue();
//                    // 施工合同总金额 乘 比例后金额
//                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractionTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
//                    logger.info("施工合同金额*比例后金额：{}", comMny);
//                    // 含本次合同金额
//                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd(allExpenseContractTaxMny, thisTimeChangeTaxMny).setScale(2,BigDecimal.ROUND_HALF_UP);;
//                    logger.info("含本次合同金额：{}", sumPayContractTaxMny);
//
//
//                    if (sumPayContractTaxMny.compareTo(comMny) > 0) {
//                        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
//
//                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
//                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
//                        paramsCheckDsVO.setWarnItem("支出超施工合同");
//                        paramsCheckDsVO.setWarnName("累计支出合同金额大于施工合同金额");
//                        StringBuffer stringBuffer = new StringBuffer();
//                        stringBuffer.append("本次合同金额：").append(vo.getContractTaxMny())
//                                .append("元，含本次合同金额：").append(sumPayContractTaxMny)
//                                .append("元，施工合同金额*").append(roleValue).append("% = ").append(comMny)
//                                .append("元。超出金额：").append(ComputeUtil.safeSub(sumPayContractTaxMny, comMny).setScale(2,BigDecimal.ROUND_HALF_UP)).append("元");
//                        paramsCheckDsVO.setContent(stringBuffer.toString());
//                        checkDsVOS.add(paramsCheckDsVO);
//                        logger.info("paramsCheckDsVO:{}", JSONObject.toJSONString(paramsCheckDsVO));
//                    }else{
//                        paramsCheckVO.setWarnType(paramsArray[0]);
//                        paramsCheckVOList.add(paramsCheckVO);
//                        return paramsCheckVOList;
//                    }
//                    paramsCheckVO.setDataSource(checkDsVOS);
//                    paramsCheckVOList.add(paramsCheckVO);
//                }
//            }
//        } else {
//            logger.info(billParamByCode.getMsg());
//            throw new BusinessException("获取控制参数失败");
//        }
        return null;
    }
    //价格库合同参数控制
    @Override
    public ParamsCheckVO priceCheckParams(ContractVO vo) {
        return  null;
    }


    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    /**
     * 查询合同付款申请列表
     *
     * @param id 合同id
     * @return 查询结果
     */
    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse<List<PaymentApplyVO>> resultData = paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (resultData != null) {
            List<PaymentApplyVO> paymentApplyVOList = resultData.getData();
            if (CollectionUtils.isNotEmpty(paymentApplyVOList)) {
                resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null)
                        .map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null)
                        .map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null)
                        .map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                paymentApplyVOList.forEach(item -> {
                    item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                    item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                    item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
                });
                resultVO.setPaymentApplyList(paymentApplyVOList);
            }
        }
        ContractEntity contractEntity = service.selectById(id);
        if (null != contractEntity) {
            resultVO.setContractId(id);
            resultVO.setAddType(contractEntity.getTargetResultId() == null ? 1 : 0);
            resultVO.setContractFlag(contractEntity.getSupplementFlag());
            resultVO.setContractMny(contractEntity.getContractTaxMny());
            if (null != resultVO.getTotalActualMny()) {
                resultVO.setPaymentRate((resultVO.getTotalActualMny()
                        .divide(resultVO.getContractMny(), 8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100)));
            }
            else {
                resultVO.setPaymentRate(BigDecimal.ZERO);
            }
            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }
        CommonResponse<String> addFlagData = paymentApplyApi.queryAddFlagContractId(id);
        if (addFlagData != null && addFlagData.getData() != null) {
            if (addFlagData.getData().equals("1")) {
                resultVO.setAddFlag(true);
            }
        }
        return resultVO;
    }
    @Override
    public List<MaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId) {
        List<MaterialReportVO> list = baseMapper.quueryMaterialByProject(pages, queryWrapper,projectId);
        CommonResponse<Map<Long, BigDecimal>> resDate = iDutyApi.queryDoc(projectId);
        if(!resDate.isSuccess()) {
            throw new BusinessException("获取成本数量信息失败,请刷新后重试!");
        }
        Map<Long, BigDecimal> map= resDate.getData();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                if(null!=map&&map.containsKey(e.getMaterialId())){
                  e.setMbNum(map.get(e.getMaterialId())==null?BigDecimal.ZERO:map.get(e.getMaterialId()));
                }
            });
        }
        return list;
    }

    @Override
    public List<ContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper) {
        List<ContractMaterialReportVO> contractMaterialReportVOList = baseMapper.quueryMaterialByOrg(page, wrapper);
        //计算税率等
//        合同单价  合同量汇总,合同金额汇总,合同单价= 合同金额汇总/合同量汇总  合同税率=合同金额汇总/合同金额汇总（无税）-1,
        if (CollectionUtils.isNotEmpty(contractMaterialReportVOList)){
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList){
                //计算单价
                if (contractMaterialReportVO.getContractNum() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractNum()) == 0){
                    contractMaterialReportVO.setContractTaxPrice(BigDecimal.ZERO);
                }else {
                    contractMaterialReportVO.setContractTaxPrice(contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractNum(), 8, ROUND_HALF_DOWN));
                }
                //计算税率
//                bb.compareTo(BigDecimal.ZERO)!=0
                if ((contractMaterialReportVO.getContractMny() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractMny()) == 0)){
                    contractMaterialReportVO.setContractTaxRate(BigDecimal.ZERO);
                }else {
                    BigDecimal contractTaxRate = contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractMny(), 8, ROUND_HALF_DOWN).subtract(new BigDecimal(1));
                    contractMaterialReportVO.setContractTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }
            //取所有合同主键
            List<Long> contractIds = contractMaterialReportVOList.stream().map(ContractMaterialReportVO::getContractId).collect(Collectors.toList());
            //订单量
            List<ContractMaterialReportVO> orderList = baseMapper.getOrderNum(contractIds);
            //验收量
            List<ContractMaterialReportVO> checkList = baseMapper.getCheckNum(contractIds);
            //结算量
            List<ContractMaterialReportVO> settleList = baseMapper.getSettleNum(contractIds);
            if (CollectionUtils.isNotEmpty(settleList)) {
                for (ContractMaterialReportVO contractMaterialReportVO : settleList){

                //计算结算单价
                if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementNum()) == 0){
                    contractMaterialReportVO.setSettlementTaxPrice(BigDecimal.ZERO);
                }else {
                    contractMaterialReportVO.setSettlementTaxPrice(contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementNum(), 8, ROUND_HALF_DOWN));
                }
                //计算税率
                if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementMny()) == 0){
                    contractMaterialReportVO.setSettlementTaxRate(BigDecimal.ZERO);
                }else {
                    BigDecimal contractTaxRate = contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementMny(), 8, ROUND_HALF_DOWN).subtract(new BigDecimal(1));
                    contractMaterialReportVO.setSettlementTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }

            }

            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList){
                //orderList
                for (ContractMaterialReportVO order : orderList){
                    if (contractMaterialReportVO.getContractId().equals(order.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(order.getMaterialId())){
                        contractMaterialReportVO.setOrderNum(order.getOrderNum());
                    }
                }
                for (ContractMaterialReportVO check : checkList){
                    if (contractMaterialReportVO.getContractId().equals(check.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(check.getMaterialId())){
                        contractMaterialReportVO.setCheckNum(check.getCheckNum());
                    }
                }
                for (ContractMaterialReportVO settle : settleList){
                    if (contractMaterialReportVO.getContractId().equals(settle.getContractId()) &&
                            contractMaterialReportVO.getMaterialId().equals(settle.getMaterialId())){
                        contractMaterialReportVO.setSettlementNum(settle.getSettlementNum());
                        contractMaterialReportVO.setSettlementTaxRate(settle.getSettlementTaxRate());
                        contractMaterialReportVO.setSettlementTaxPrice(settle.getSettlementTaxPrice());
                        contractMaterialReportVO.setSettlementTaxMny(settle.getSettlementTaxMny());
                    }
                }

            }

        }

        return contractMaterialReportVOList;
    }

    /**
     * 占用/释放 定标结果
     *
     * @param vo   合同vo
     * @param type 0占用，1释放
     */
    @Override
    public void updateTargetResult(ContractVO vo, Integer type) {
//        if (vo.getTargetResultId() == null) return;
//        if (CollectionUtils.isEmpty(vo.getContractDetailList())) return;
//        TenderPicketageVO picketageVO = new TenderPicketageVO();
//        picketageVO.setId(vo.getTargetResultId()); // 定标参照id
//        picketageVO.setContractMoneyTax(vo.getContractTaxMny()); // 合同金额（含税）
//        picketageVO.setContractMoney(vo.getContractMny()); // 合同金额
//        List<TenderPicketageDetailVO> list = new ArrayList<>();
//        for (ContractDetailVO detailVO : vo.getContractDetailList()) {
//            // 删除的不做占用处理
//            if ("del".equals(detailVO.getRowState())) continue;
//            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
//            tenderDetailVo.setId(Long.valueOf(detailVO.getSourceId()));
//            tenderDetailVo.setSignNum(detailVO.getNum());
//            list.add(tenderDetailVo);
//        }
//        picketageVO.setTenderPicketageDetailList(list);
//        CommonResponse<String> response;
//        String typeStr = 0 == type ? "占用" : "释放";
//        logger.info("{}定标结果请求参数：{}", typeStr, JSONObject.toJSONString(picketageVO));
//        // 占用
//        if (0 == type) {
//            response = tenderApi.updateStatus(picketageVO);
//        }
//        // 释放
//        else {
//            response = tenderApi.delUpdateStatus(picketageVO);
//        }
//        logger.info("{}定标结果请求结果：{}", typeStr, JSONObject.toJSONString(response));
//        if (!response.isSuccess()) {
//            throw new BusinessException(typeStr + "定标结果失败！");
//        }
    }

    /**
     * 根据定标结果id查询对应合同
     *
     * @param targetResultIdList 定标结果id
     * @return 查询结果
     */
    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
//        List<SignContractVo> rtnList = new ArrayList<>();
//        if (CollectionUtils.isEmpty(targetResultIdList)) return rtnList;
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
//        queryParam.getOrderMap().put("signDate", QueryParam.DESC);
//        List<ContractEntity> entityList = super.queryList(queryParam, false);
//        if (CollectionUtils.isEmpty(entityList)) return rtnList;
//        for (ContractEntity entity : entityList) {
//            SignContractVo vo = new SignContractVo();
//            vo.setBillCode(entity.getBillCode());
//            vo.setContractId(entity.getId());
//            vo.setContractName(entity.getContractName());
//            vo.setSupplierId(entity.getSupplierId());
//            vo.setSupplierName(entity.getSupplierName());
//            vo.setContractMny(entity.getContractMny());
//            vo.setContractTaxMny(entity.getContractTaxMny());
//            vo.setSignDate(entity.getSignDate());
//            vo.setBillState(entity.getBillState());
//            vo.setLinkUrl(this.getContractLinkUrl(entity.getTargetResultId(), entity.getId(),
//                    entity.getSupplementFlag(), entity.getPerformanceStatus(), entity.getContractType()));
//            rtnList.add(vo);
//        }

        return null;
    }

    /**
     * 获取合同跳转路径（不包含baseHost）
     *
     * @param targetResultId    定标结果id
     * @param contractId        合同id
     * @param supplementFlag    是否补充协议
     * @param performanceStatus 履约状态
     * @param contractType      合同类型
     * @return 合同路径
     */
    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag,
                                      String performanceStatus, Integer contractType) {
        int targetType = targetResultId == null ? 1 : 0;
        String url = "/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id="
                + contractId + "&supplementFlag=" + supplementFlag
                + "&targetType=" + targetType + "&performanceStatus="
                + performanceStatus;
        if (MaterialContractTypeEnum.混凝土.getCode().equals(contractType)) {
            url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id="
                    + contractId + "&supplementFlag=" + supplementFlag
                    + "&targetType=" + targetType + "&performanceStatus="
                    + performanceStatus;
        }
        return url;
    }

    /**
     * 校验明细数量
     *
     * @param detailList     需要校验明细
     * @param contractId     合同id
     * @param targetResultId 定标结果id
     */
    private void checkDetailTenderNum(List<ContractDetailVO> detailList, Long contractId, Long targetResultId) {
        if (targetResultId == null) return;
        if (CollectionUtils.isEmpty(detailList)) return;
        // 先校验传入数据签订数量是否大于可签订数量
        for (ContractDetailVO vo : detailList) {
            if(vo.getSignNum() == null || vo.getSignNum().compareTo(vo.getNum()) < 0){
                throw new BusinessException("签订数量不能大于可签订数量");
            }
        }
        List<String> sourceIdList = detailList.stream().map(ContractDetailVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter(QueryParam.NE, contractId));
        }
        List<ContractDetailEntity> detailEntityList = contractDetailService.queryList(detailParam, false);
        // 没有查询出结果则不校验
        if (CollectionUtils.isEmpty(detailEntityList)) return;
        Map<String, List<ContractDetailEntity>> queryMap = detailEntityList.stream()
                .collect(Collectors.groupingBy(ContractDetailEntity::getSourceId));
        for (ContractDetailVO detail : detailList) {
            List<ContractDetailEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            // 列表为空则说明改材料未签订过合同，跳过验证
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO; // 已签订总数量
            for (ContractDetailEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum); // 剩余总数量
            // 剩余数量小于列表传入的数量，则抛出异常
            if (sy.compareTo(detail.getNum()) < 0) {
                throw new BusinessException(detail.getMaterialName() + "采购数量不能超过" + sy);
            }
        }
    }

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        ContractEntity contractEntity = super.selectById(id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = "BT211227000000003";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.混凝土.getCode().equals(contractEntity.getContractType())) {
                billType = "BT220215000000001";
                sourceType ="contractConcrete";
            }
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                    contractEntity.getBillCode(), billType, sourceType);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = super.selectById(contractId);
        // 不限制
        if("0".equals(valueData)){
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(contractEntity.getFilingStatus());
        }
    }

    @Override
    public CommonResponse<List<MaterialMnyVO>> queryMaterialMnyByYear(String year, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //查询本下
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        List<ContractEntity> contractList = super.queryList(param);
        List<MaterialMnyVO> materialMnyList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(contractList)){
            List<Long> contractIds = contractList.stream().map(ContractEntity::getId).collect(Collectors.toList());
            logger.info("查出符合条件合同id：{}", JSONObject.toJSONString(contractIds));

            QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("DATE_FORMAT(create_time,'%Y')", year);
            wrapper.in("contract_id", contractIds);
            wrapper.eq("dr", 0);
            wrapper.isNotNull("material_type_name");
            wrapper.select("material_type_name as materialTypeName, material_type_id as materialTypeId, sum( detail_tax_mny ) AS detailTaxMny");
            wrapper.groupBy("material_type_id");
            wrapper.orderByDesc("detailTaxMny");
            wrapper.last("limit 5");
            List<ContractDetailEntity> contractDetailList = contractDetailService.list(wrapper);

            if (CollectionUtils.isNotEmpty(contractDetailList)){
                logger.info("查出符合条件合同id：{}", JSONObject.toJSONString(contractDetailList));
                materialMnyList = BeanMapper.mapList(contractDetailList, MaterialMnyVO.class);
            }
        }

        return CommonResponse.success("查询物料金额使用数据成功！", materialMnyList);
    }
}
